# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['telegram_updates_tweets']

package_data = \
{'': ['*']}

install_requires = \
['click>=7.1.2,<8.0.0', 'telethon>=1.18.2,<2.0.0', 'tweepy>=3.10.0,<4.0.0']

extras_require = \
{'logging': ['pymongo>=3.11.2,<4.0.0', 'matplotlib>=3.3.3,<4.0.0'],
 'monitoring': ['Flask>=1.1.2,<2.0.0', 'waitress>=1.4.4,<2.0.0']}

setup_kwargs = {
    'name': 'telegram-updates-tweets',
    'version': '0.1.5',
    'description': 'This package monitors the number of participants in a telegram channel and can post gains/losses updates to twitter',
    'long_description': '# Telegram Updates Tweets\nThis package monitors the number of participants in a telegram channel and can post gains/losses updates to twitter.\nIt requires a twitter API key and telegram API key.\n\n## Installation\n\nUse the package manager [pip](https://pip.pypa.io/en/stable/) to install telegram_updates_tweets.\n\n### Simple version\n\n```bash\npip install telegram_updates_tweets\n```\n\n### With monitoring and database logging\n\n```bash\npip install telegram_updates_tweets[logging,monitoring]\n```\n\n## Usage\nThe package is configured with a bunch of options. It also supports environmental variabls (see docker instructions below for details).\n\n### Simple version (powershell)\n```powershell\npython -m telegram_updates_tweets --tweet-losses 100 `\n--twitter-key OopNaGdhsdhgsgRg0FVAOzC `\n--twitter-secret VWyvs87IKYsgsdhdswgg23g3g3gPbcETEV8HlvmnCx `\n--twitter-access-token 134062562626437-1zh50lhr3dggsgsg8oYGrSh3eW `\n--twitter-access-token-secret 5jGpCn79ZexhcQafaf43yt3gNEKWQVzzU `\n--telegram-api-id 20161454 `\n--telegram-api-hash b7dae636835151536egwgf6ffc69 `\n--telegram-channel-name CHANNELNAME `\n--tweet-loss-template \'Der Kanal hat {loss_step} Leser verloren und ist jetzt bei {count}\' `\n--tweet-graph-template \'24h Bericht, aktuelle Anzahl der Leser ist {count}, Änderung {total_change:+d} Leser\'\n```\n### Logging/monitoring version (powershell)\n```powershell\npython -m telegram_updates_tweets --tweet-losses 100 `\n--twitter-key OopNaGdhsdhgsgRg0FVAOzC `\n--twitter-secret VWyvs87IKYsgsdhdswgg23g3g3gPbcETEV8HlvmnCx `\n--twitter-access-token 134062562626437-1zh50lhr3dggsgsg8oYGrSh3eW `\n--twitter-access-token-secret 5jGpCn79ZexhcQafaf43yt3gNEKWQVzzU `\n--telegram-api-id 20161454 `\n--telegram-api-hash b7dae636835151536egwgf6ffc69 `\n--mongodb 127.0.0.1:27017 --telegram-channel-name CHANNELNAME `\n--tweet-loss-template \'Der Kanal hat {loss_step} Leser verloren und ist jetzt bei {count}\' `\n--tweet-graph-template \'24h Bericht, aktuelle Anzahl der Leser ist {count}, Änderung {total_change:+d} Leser\' `\n--tweet-graph 20 `\n--tweet-graph-img-template \'Innerhalb der letzten {hours} Std.: {total_change:+d} Leser\' `\n--monitoring-port 3134 --monitoring-password \'sgwjth23iut2tkjakd\'\n```\n\n### Template variables\n`--tweet-loss-template` and `--tweet-gain-template`\n- `{loss_step}` is the `--tweet-losses` parameter\n- `{gain_step}` is the `--tweet-gains` parameter\n- `{count}` is the current number of participants in the channel\n- `{channel_name}` is the channel name as defined by `--telegram-channel-name`\n\n`--tweet-graph-img-template` is the title in the image of the 24h report image\n- `{hours}` is the rounded number between the oldest and the newest datapoint in the database (typically integer 24)\n- `{total_change:+d}` is the count of the oldest datapoint minus the count of the newest, `+d` add an explicit plus sign to positive numbers\n\n### Docker image\nThe application can be pulled with\n\n```powershell\ndocker pull jcq9kw2s/telegram_updates_tweets:latest\n```\n\n#### Env File\nTo configure the application within the docker image I recommend using a `.env` file.\nThe variable names have a prefix `TT_` and are the uppercase versions with underscores of the options described below.\n\nExample for `.env` with logging and monitoring:\n\n```txt\nTT_TWEET_LOSSES=100\nTT_TWITTER_KEY=g3g3g3gwegwgfejhegweg\nTT_TWITTER_SECRET=sjgpjpiowgjij0u030t32jgjpjwjijjoijygyupsjfjsofjofjo\nTT_TWITTER_ACCESS_TOKEN=162162615161515-1515kjk1j5h12hjlk1b1g54\nTT_TWITTER_ACCESS_TOKEN_SECRET=5mklmjijafkshfishifhaohfhhg3f23fih2\nTT_TELEGRAM_API_ID=515661515\nTT_TELEGRAM_API_HASH=15414141414ef1fffafffdf14\nTT_MONGODB=host.docker.internal:27017\nTT_TELEGRAM_CHANNEL_NAME=CHANNELNAME\nTT_TWEET_LOSS_TEMPLATE=Der Kanal hat {loss_step} Leser verloren und ist jetzt bei {count} #hashtag\nTT_TWEET_GRAPH_TEMPLATE=24h Bericht, aktuelle Anzahl der Leser ist {count}, Änderung {total_change:+d} Leser @someacc #hashtab\nTT_TWEET_GRAPH=20\nTT_TWEET_GRAPH_IMG_TEMPLATE=Innerhalb der letzten {hours} Std.: {total_change:+d} Leser\nTT_MONITORING_PORT=12345\nTT_MONITORING_PASSWORD=256n52jj512b412b1\n```\n#### Running docker image\nI recommend running the python module in terminal first to get the session of telegram and mount it into the container, the `session-journal` file should not need to be mounted.\n\nPowershell\n\n```powershell\ndocker run --name tt -v "$pwd/anon.session:/app/anon.session" --network="host" --env-file .env -p 12345:12345 -it jcq9kw2s/telegram_updates_tweets:latest\n```\n\nFor development\n\n```powershell\ndocker stop tt;docker rm tt;docker run --name tt -v "$pwd/anon.session:/app/anon.session"  --network="host" --env-file .env -p 12345:12345 -it jcq9kw2s/telegram_updates_tweets:latest\n```\n\n## Options\n```text\nUsage: python -m telegram_updates_tweets [OPTIONS]\n\n  Connects to telegram as a user and checks every 60minutes the subscriber\n  count of the given channel. It allows to tweet gains and/or losses with\n  additional info.\n\nOptions:\n  --tweet-gains INTEGER           Deactivated if <=0, otherwise describes the\n                                  step. Example: 100 -> tweet at 1900, 2000,\n                                  2100, ...\n\n  --tweet-losses INTEGER          Deactivated if <=0, otherwise describes the\n                                  step. Example: 100 -> tweet at 2100, 2000,\n                                  1900, ...\n\n  --tweet-loss-template TEXT      This template will be formatted and posted\n                                  on loss\n\n  --tweet-gain-template TEXT      This template will be formatted and posted\n                                  on gain\n\n  --tweet-graph INTEGER           Deactivated if <0, otherwise 0..23 specifies\n                                  the time when to post a 24h summary graph\n                                  (requires mongodb)\n\n  --tweet-graph-template TEXT     This template will be formatted and posted\n                                  if --tweet-graph is specified\n\n  --tweet-graph-img-template TEXT\n                                  This template will be formatted and used in\n                                  the image if --tweet-graph is specified\n\n  --monitoring-port INTEGER       Deactivated if <=0, otherwise 0..65000\n                                  specifies the port which allows to fetch\n                                  monitoring information. Requires\n                                  --monitoring-password\n\n  --monitoring-password TEXT      Is required if --monitoring-port is set. Is\n                                  used in basic authentication password,\n                                  username can be any.\n\n  --check-frequency INTEGER       Check period in seconds\n  --twitter-key TEXT              Also called API key, is created by the\n                                  twitter app\n\n  --twitter-secret TEXT           The secret of the twitter app\n  --twitter-access-token TEXT     The access token of the oauth procedure\n  --twitter-access-token-secret TEXT\n                                  The secret of the oauth access token\n  --telegram-api-id INTEGER       The number created by telegram\n  --telegram-api-hash TEXT        The api hash created by telegram\n  --telegram-channel-name TEXT    The name of the channel of interest\n  --mongodb TEXT                  IP:PORT of the mongo db, if not set, no data\n                                  will be logged\n\n  --help                          Show this message and exit.\n```\n\n## Monitoring\nIf you want to have downtime alerts via email, I recommend using a Google Cloud Service.\n1. Start your application with `--monitoring-port` and `--monitoring-password`\n1. Go to `Operations>Monitoring>Uptime Checks`\n2. Create Uptime Check\n3. Target\n- Protocol: HTTP\n- Resource Type: URL\n- Hostname: your-server-url.host.com\n- Path: `/`\n- Check Frequency: 15min\n- More Options:\n- Regions: Global\n- Host Header: empty\n- Port: as set in `--monitoring-port`\n- Encrypt custom headers: unchecked\n- Authentication, Username: `user`\n- Authentication, Password: as set in `--monitoring-password`\n4. Response Validation\n- Response Timeout: 10s\n- Content matching is enabled: checked\n- Response Content Match Type: `Contains`\n- Response Content: `OK`\n- Log Check Failures: checked\n5.  Alert and Notification\nCreate an email notification channel\n## Development\n1. After cloning this repo execute `git config core.hooksPath hooks` in the root directory.\n2. Install poetry https://python-poetry.org/docs/\n3. `poetry config settings.virtualenvs.in-project true`\n4. `poetry install`\n4. `poetry shell`\n\n## API keys\nTo use this package a twitter API key and a telegram API key are needed, these keys will be used to request OAUTH tokens from one twitter account and a telegram account.\n\n1. Create a twitter APP with \'write\' permission https://developer.twitter.com/en/portal/projects-and-apps\n- this creates the `--twitter-key` and the ` --twitter-secret`\n- the application will print a `authorization link`, open it, give permission to your own app the use your twitter profile\n- it will print the `--twitter-access-token` and `--twitter-access-token-secret`\n- all subsequent calls should use all four parameters\n2. Create a telegram APP as described in https://core.telegram.org/api/obtaining_api_id\n- this generates a `--telegram-api-id` (numbers) and `--telegram-api-hash` (string)\n- when the application is started with this parameters, it will ask for your phone number, you will receive a code from telegram, enter it in the application\n- this will create a token file called \'anon.session\' and \'anon.session-journal\'\n- all subsequent calls should not prompt for other info\n## Contributing\nPull requests are welcome. For major changes, please open an issue first to discuss what you would like to change.\n\nPlease make sure to update tests as appropriate.\n\n## License\n[MIT](https://choosealicense.com/licenses/mit/)\n',
    'author': 'Alexander Jahn',
    'author_email': 'jahn.alexander@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/AlxndrJhn/telegram_updates_tweets',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
