# -*- coding: utf-8 -*-
from os import path
from os import environ
from .parse import parse
from .coerce import coerce
from .inherit import inherit
from .readonly import ReadOnlyDict


def read_config(config_input):
    '''
    read_config assumes `config_input` is one of the following in this
    order:

        1. a file path string.
        2. an environment variable name.
        3. a raw config string.

    '''
    def _readlines(pth):
        with open(pth, 'r') as fh_:
            return fh_.read()

    if path.exists(config_input):
        config_input = _readlines(config_input)

    elif config_input in environ and path.exists(environ[config_input]):
        config_input = _readlines(environ[config_input])

    return config_input.split('\n')


def load(config_path, inheritance=False, readonly=True):

    config = parse(read_config(config_path))

    config = coerce(config)

    if inheritance is True:
        config = inherit(config)

    if readonly is True:
        config = ReadOnlyDict(config)

    return config
