"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Simulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const data_type_1 = require("../domain/data-type");
const response_code_1 = require("../domain/response-code");
const automation_simulation_1 = require("./document/automation-simulation");
const command_simulation_1 = require("./document/command-simulation");
class Simulation {
    constructor(document, props) {
        this.document = document;
        this.props = props;
    }
    static ofAutomation(document, props) {
        return new Simulation(document, props);
    }
    static ofCommand(document, props) {
        return new Simulation(document, props);
    }
    /**
     * Synthesize before calling this function!
     * You can use this to Synthesize: SynthUtils.synthesize(stack);
     *
     * Executes the SSM Document in simulation mode.
     * This method DOES NOT result in invocation of SSM APIs.
     * Rather, all steps are executed locally and mimic the behavior of SSM.
     * If any inputs are not provided in this function, the specified defaults for the inputs will be used.
     * @param inputs the inputs to feed into the simulated execution.
     * @returns the outputs of all the executed steps.
     */
    simulate(inputs) {
        this.document.docInputs.forEach(docInput => {
            if (inputs[docInput.name] == undefined) {
                inputs[docInput.name] = docInput.defaultValue;
                if (docInput.defaultValue == undefined) {
                    throw new Error(`Value not provided for ${docInput.name} and no default value was provided`);
                }
            }
        });
        for (let key in inputs) {
            const value = inputs[key];
            const matchedInput = this.document.docInputs.filter(docInput => docInput.name == key)[0];
            if (matchedInput == undefined) {
                throw new Error(`Value provided to simulation {${key}:${value}} is not a supported input for this document`);
            }
            try {
                matchedInput.validate(value);
            }
            catch (e) {
                const message = e.message;
                throw new Error(`Value provided to simulation {${key}:${value}} failed validation: ${message}`);
            }
        }
        const simulationResult = this.start(inputs);
        var outputValues = [];
        if (simulationResult.responseCode == response_code_1.ResponseCode.SUCCESS) {
            outputValues = this.document.docOutputs.map(docOutput => {
                const valueOfOutput = (simulationResult.outputs ?? {})[docOutput.name];
                if (!new data_type_1.DataType(docOutput.outputType).validateType(valueOfOutput)) {
                    throw new Error(`Document output ${docOutput.name} did not match type ${docOutput.outputType}: ${valueOfOutput}`);
                }
                return valueOfOutput;
            });
        }
        return { ...{ documentOutputs: outputValues }, ...simulationResult };
    }
    /**
     * Delegates the execution of the Document to the subclass (Automation, etc).
     * @param inputs a merge of the defined inputs to the document and the default values if not supplied.
     * @returns the outputs that were emitted from all of the steps.
     */
    start(inputs) {
        switch (this.document.documentType()) {
            case ('Automation'):
                return new automation_simulation_1.AutomationSimulation(this.document, this.props).start(inputs);
            case ('Command'):
                return new command_simulation_1.CommandSimulation(this.document, this.props).start(inputs);
            default:
                throw new Error('No simulation available for document of type: ' + this.document.documentType());
        }
    }
}
exports.Simulation = Simulation;
_a = JSII_RTTI_SYMBOL_1;
Simulation[_a] = { fqn: "@cdklabs/cdk-ssm-documents.Simulation", version: "0.0.30" };
//# sourceMappingURL=data:application/json;base64,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