"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CopyImageSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const data_type_1 = require("../../domain/data-type");
const response_code_1 = require("../../domain/response-code");
const aws_api_step_1 = require("../../parent-steps/automation/aws-api-step");
const wait_for_and_assert_1 = require("../../parent-steps/automation/sub-steps/wait-for-and-assert");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_simulation_1 = require("../automation-step-simulation");
const automation_simulation_base_1 = require("./automation-simulation-base");
const aws_service_1 = require("../../domain/aws-service");
/**
 * AutomationStep implemenation for aws:copyImage
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-copyimage.html
 */
class CopyImageSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step, props) {
        super(step);
        this.action = 'aws:copyImage';
        this.copyImageStep = step;
        this.props = props;
    }
    executeStep(inputs) {
        console.log(`CopyImage: Creating copy of image ${this.copyImageStep.sourceImageId}`);
        const imageId = this.copyImage(inputs);
        console.log(`CopyImage: Waiting for ${imageId} to be available`);
        const state = this.waitForImageAvailable(imageId);
        console.log(`CopyImage: Image ${imageId} is available`);
        return {
            ImageId: imageId,
            ImageState: state,
        };
    }
    copyImage(inputs) {
        const apiParamMap = {
            Name: this.copyImageStep.imageName,
            SourceImageId: this.copyImageStep.sourceImageId,
            SourceRegion: this.copyImageStep.sourceRegion,
            ClientToken: this.copyImageStep.clientToken,
            Description: this.copyImageStep.imageDescription,
            Encrypted: this.copyImageStep.encrypted,
            KmsKeyId: this.copyImageStep.kmsKeyId,
        };
        const apiParams = prune_and_transform_record_1.pruneAndTransformRecord(apiParamMap, x => x.resolve(inputs));
        const result = new automation_step_simulation_1.AutomationStepSimulation(new aws_api_step_1.AwsApiStep(new aws_cdk_lib_1.Stack(), 'copyImage', {
            service: aws_service_1.AwsService.EC2,
            pascalCaseApi: 'CopyImage',
            apiParams,
            outputs: [{
                    outputType: data_type_1.DataTypeEnum.STRING,
                    name: 'ImageId',
                    selector: '$.ImageId',
                }],
        }), this.props).invoke({});
        if (result.responseCode !== response_code_1.ResponseCode.SUCCESS) {
            throw new Error(`Copy image failed for ${apiParams.SourceImageId}: ${result.stackTrace}`);
        }
        return result.outputs?.['copyImage.ImageId'];
    }
    waitForImageAvailable(imageId) {
        wait_for_and_assert_1.waitForAndAssertImageAvailable({
            imageId: imageId,
        }, this.props);
        return 'available';
    }
}
exports.CopyImageSimulation = CopyImageSimulation;
_a = JSII_RTTI_SYMBOL_1;
CopyImageSimulation[_a] = { fqn: "@cdklabs/cdk-ssm-documents.CopyImageSimulation", version: "0.0.30" };
//# sourceMappingURL=data:application/json;base64,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