"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Step = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const observer_1 = require("../interface/observer");
class Step extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.name = props.name ?? id;
        if (this.name.length < 3 || this.name.length > 128) {
            throw new Error('Name is not in size range [3:128] rather was ' + this.name.length);
        }
        this.description = props.description ?? undefined;
        this.inputObserver = props.inputObserver ?? new observer_1.NoopObserver();
        this.outputObserver = props.outputObserver ?? new observer_1.NoopObserver();
    }
}
exports.Step = Step;
_a = JSII_RTTI_SYMBOL_1;
Step[_a] = { fqn: "@cdklabs/cdk-ssm-documents.Step", version: "0.0.30" };
//# sourceMappingURL=data:application/json;base64,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