"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExecuteStateMachineStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_1 = require("../automation-step");
/**
 * AutomationStep implementation of [aws:executeStateMachine](https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-executeStateMachine.html)
 */
class ExecuteStateMachineStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:executeStateMachine';
        this.stateMachineArn = props.stateMachineArn;
        this.executionName = props.executionName;
        this.input = props.input;
    }
    /**
       * No outputs emitted from Delete Stack step
       * @returns []
       */
    listOutputs() {
        return [];
    }
    listInputs() {
        const inputs = [
            this.stateMachineArn,
            this.executionName,
            this.input,
        ];
        return inputs.flatMap(i => i?.requiredInputs() ?? []);
    }
    toSsmEntry() {
        return this.prepareSsmEntry(prune_and_transform_record_1.pruneAndTransformRecord({
            stateMachineArn: this.stateMachineArn,
            name: this.executionName,
            input: this.input,
        }, x => x.print()));
    }
}
exports.ExecuteStateMachineStep = ExecuteStateMachineStep;
_a = JSII_RTTI_SYMBOL_1;
ExecuteStateMachineStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.ExecuteStateMachineStep", version: "0.0.30" };
//# sourceMappingURL=data:application/json;base64,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