"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsApiStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const __1 = require("../..");
const automation_step_1 = require("../automation-step");
/**
 * AutomationStep implementation of aws:executeAwsApi
 */
class AwsApiStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:executeAwsApi';
        this.service = props.service;
        this.pascalCaseApi = props.pascalCaseApi;
        this.apiParams = new __1.DictFormat(props.apiParams);
        this.outputs = props.outputs;
        this.javaScriptApi = props.javaScriptApi ??
            (this.pascalCaseApi.charAt(0).toLowerCase() + this.pascalCaseApi.slice(1));
    }
    /**
       * @returns Outputs as specified in params
       */
    listOutputs() {
        return this.outputs;
    }
    /**
       * Derives the inputs by parsing the apiParams to find matches for inputs in double circle braces ("{{ INPUT }}").
       * @returns list of required inputs.
       */
    listInputs() {
        return this.apiParams.requiredInputs();
    }
    toSsmEntry() {
        return super.prepareSsmEntry({
            ...{
                Service: this.service.namespace,
                Api: this.pascalCaseApi,
            },
            ...this.apiParams.format,
        });
    }
}
exports.AwsApiStep = AwsApiStep;
_a = JSII_RTTI_SYMBOL_1;
AwsApiStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.AwsApiStep", version: "0.0.30" };
//# sourceMappingURL=data:application/json;base64,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