import { GenericVariable, HardCodedValueBase, IGenericVariable } from './variable';
/**
 * Boolean type that can be null
 */
export declare type NullableBoolean = boolean;
/**
 * A boolean variable
 */
export interface IBooleanVariable extends IGenericVariable {
    /**
       * Given the execution inputs, return the resolved value of this variable.
       * @param inputs are the execution inputs.
       */
    resolveToBoolean(inputs: Record<string, any>): NullableBoolean;
}
/**
 * A hard-coded boolean variable.
 * Used when not dependent on step inputs.
 */
export declare class HardCodedBoolean extends HardCodedValueBase<boolean> implements IBooleanVariable {
    static readonly TRUE: HardCodedBoolean;
    static readonly FALSE: HardCodedBoolean;
    resolveToBoolean(inputs: Record<string, any>): NullableBoolean;
    protected assertType(value: any): void;
}
/**
 * A boolean variable reference.
 * Used to resolve the value from step inputs.
 */
export declare class BooleanVariable extends GenericVariable implements IBooleanVariable {
    static of(reference: string): BooleanVariable;
    resolveToBoolean(inputs: Record<string, any>): NullableBoolean;
    protected assertType(value: any): void;
}
/**
 * Assert that the given value is a NullableBoolean.
 * @param value value to assert
 */
export declare function assertBoolean(value: any): asserts value is NullableBoolean;
/**
 * Whether the given value is a NullableBoolean.
 * @param value value to check
 * @returns true if the value is a NullableBoolean, otherwise false
 */
export declare function isBoolean(value: any): value is NullableBoolean;
