"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Continue = exports.Abort = exports.StepNameFallback = exports.StepFallback = exports.OnCancel = exports.OnFailure = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Steps can specify an action to take onFailure.
 * See docs here: https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-actions.html#failProp
 * The supported actions are abort (default), continue, or invoking a specific step.
 * This behavior can be adopted by using the static methods available on OnFailure.
 */
class OnFailure {
    /**
     * Invoke a specific step. Provide the step object to execute for the onFailure action.
     * If you don't have a handle to the step object, use the invokeStepByName function.
     */
    static invokeStep(step) {
        return new StepFallback(step, false);
    }
    /**
     * Invoke a specific step by the step name for the OnFailure action.
     */
    static invokeStepByName(stepName) {
        return new StepNameFallback(stepName, false);
    }
    /**
     * To abort execution if a failure occurs during execution of the current step.
     * (This is the default behavior.)
     */
    static abort() {
        return new Abort();
    }
    /**
     * To continue execution of the subsequent step if a failure occurs during execution of the current step.
     */
    static continue() {
        return new Continue();
    }
}
exports.OnFailure = OnFailure;
_a = JSII_RTTI_SYMBOL_1;
OnFailure[_a] = { fqn: "@cdklabs/cdk-ssm-documents.OnFailure", version: "0.0.30" };
/**
 * Steps can specify an action to take onCancel.
 * See docs here: https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-actions.html#canProp
 * The supported actions are abort (default) or invoking a specific step.
 * This behavior can be adopted by using the static methods available on OnCancel.
 */
class OnCancel extends OnFailure {
    /**
     * Invoke a specific step. Provide the step object to execute for the onCancel action.
     * If you don't have a handle to the step object, use the invokeStepByName function.
     * Not all action types may be invoked during cancellation. See documentation referenced on this class.
     */
    static invokeStep(step) {
        return new StepFallback(step, true);
    }
    /**
     * Invoke a specific step by the step name for the OnCancel action.
     * Not all action types may be invoked during cancellation. See documentation referenced on this class.
     */
    static invokeStepByName(stepName) {
        return new StepNameFallback(stepName, true);
    }
    /**
     * To abort execution if a cancellation occurs during execution of the current step.
     * (This is the default behavior.)
     */
    static abort() {
        return new Abort();
    }
}
exports.OnCancel = OnCancel;
_b = JSII_RTTI_SYMBOL_1;
OnCancel[_b] = { fqn: "@cdklabs/cdk-ssm-documents.OnCancel", version: "0.0.30" };
class StepFallback extends OnCancel {
    constructor(step, validateStepAction) {
        super();
        this.step = step;
        if (validateStepAction && StepFallback.ILLEGAL_FALLBACK_ACTIONS.includes(step.action)) {
            throw new Error('Cannot fallback to step of type ' + step.action);
        }
    }
    stepToInvoke(_currentStep) {
        return this.step.name;
    }
    toSsmValue() {
        return 'step:' + this.step.name;
    }
}
exports.StepFallback = StepFallback;
_c = JSII_RTTI_SYMBOL_1;
StepFallback[_c] = { fqn: "@cdklabs/cdk-ssm-documents.StepFallback", version: "0.0.30" };
StepFallback.ILLEGAL_FALLBACK_ACTIONS = ['aws:approve', 'aws:copyImage', 'aws:createImage', 'aws:createStack',
    'aws:createTags', 'aws:pause', 'aws:runInstances', 'aws:sleep'];
class StepNameFallback extends OnCancel {
    constructor(step, validateStepAction) {
        super();
        this.step = step;
        this.validateStepAction = validateStepAction;
    }
    stepToInvoke(currentStep) {
        const stepToJumpTo = currentStep.allStepsInExecution?.filter(s => s.name == this.step);
        if (stepToJumpTo == undefined || stepToJumpTo.length != 1) {
            throw new Error('Cannot find fallback step ' + this.step);
        }
        if (this.validateStepAction && StepFallback.ILLEGAL_FALLBACK_ACTIONS.includes(stepToJumpTo[0].action)) {
            throw new Error('Cannot fallback to step of type ' + stepToJumpTo[0].action);
        }
        return this.step;
    }
    toSsmValue() {
        return 'step:' + this.step;
    }
}
exports.StepNameFallback = StepNameFallback;
_d = JSII_RTTI_SYMBOL_1;
StepNameFallback[_d] = { fqn: "@cdklabs/cdk-ssm-documents.StepNameFallback", version: "0.0.30" };
class Abort extends OnCancel {
    stepToInvoke(_currentStep) {
        return '';
    }
    toSsmValue() {
        return 'Abort';
    }
}
exports.Abort = Abort;
_e = JSII_RTTI_SYMBOL_1;
Abort[_e] = { fqn: "@cdklabs/cdk-ssm-documents.Abort", version: "0.0.30" };
class Continue extends OnFailure {
    stepToInvoke(currentStep) {
        return currentStep.nextStep?.name ?? '';
    }
    toSsmValue() {
        return 'Continue';
    }
}
exports.Continue = Continue;
_f = JSII_RTTI_SYMBOL_1;
Continue[_f] = { fqn: "@cdklabs/cdk-ssm-documents.Continue", version: "0.0.30" };
//# sourceMappingURL=data:application/json;base64,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