import { SecureVariable } from './variables/secure-string-variable';
export declare abstract class AuthMethod {
    static ofNone(): AuthMethod;
    static ofBasic(userName: SecureVariable, password: SecureVariable): AuthMethod;
    static ofDigest(userName: SecureVariable, password: SecureVariable): AuthMethod;
    abstract toEntry(): {
        [p: string]: any;
    };
    abstract requiredInputs(): string[];
}
export declare class NoAuthMethod extends AuthMethod {
    requiredInputs(): string[];
    toEntry(): {
        [p: string]: any;
    };
}
export declare class UsernamePasswordAuthMethod extends AuthMethod {
    readonly authMethod: string;
    readonly userName: SecureVariable;
    readonly password: SecureVariable;
    constructor(authMethod: string, userName: SecureVariable, password: SecureVariable);
    requiredInputs(): string[];
    toEntry(): {
        [p: string]: any;
    };
}
