"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CommandDocument = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const document_builder_1 = require("./document-builder");
const ssm_document_1 = require("./ssm-document");
/**
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html
 * The CommandDocument will delegate execution responsibility to the CammandSteps that it receives.
 * The SsmDocument parent class contains methods to runSimulation() as well as print().
 */
class CommandDocument extends ssm_document_1.SsmDocument {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.builder = new document_builder_1.CommandDocumentBuilder();
    }
    addStep(component) {
        component.addToDocument(this.builder);
    }
    buildSsmDocument() {
        const runCommandSteps = this.collectedSteps().map(step => step.toSsmEntry());
        const root = {
            description: this.description,
            schemaVersion: '2.2',
            parameters: this.formatInputs(),
        };
        if (this.assumeRole) {
            root.assumeRole = this.assumeRole;
        }
        if (this.docOutputs.length > 0) {
            root.outputs = this.docOutputs.map(o => o.name);
        }
        root.mainSteps = runCommandSteps;
        return root;
    }
    collectedSteps() {
        if (this.builder.steps.length == 0) {
            throw new Error('No Steps found. Either you did not declare steps or did not synthesize CDK. ' +
                'Be sure to run cdk.SynthUtils.synthesize(stack) prior to printing or running simulation');
        }
        return this.builder.steps;
    }
    documentType() {
        return 'Command';
    }
}
exports.CommandDocument = CommandDocument;
_a = JSII_RTTI_SYMBOL_1;
CommandDocument[_a] = { fqn: "@cdklabs/cdk-ssm-documents.CommandDocument", version: "0.0.30" };
//# sourceMappingURL=data:application/json;base64,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