import { Construct } from 'constructs';
import { IAutomationComponent } from '../construct/document-component';
import { AutomationStep } from '../parent-steps/automation-step';
import { AutomationDocumentBuilder } from './document-builder';
import { SsmDocumentProps, SsmDocument } from './ssm-document';
/**
 * Options for AutomationDocument
 */
export interface AutomationDocumentProps extends SsmDocumentProps {
}
/**
 * The AutomationDocuemnt used to both build the SSM Automation yaml/json and to use in simulation.
 * The AutomationDocument will delegate execution responsibility to the AutomationSteps that it receives.
 * The SsmDocument parent class contains methods to runSimulation() as well as print().
 */
export declare class AutomationDocument extends SsmDocument {
    readonly builder: AutomationDocumentBuilder;
    constructor(scope: Construct, id: string, props: AutomationDocumentProps);
    addStep(component: IAutomationComponent): void;
    collectedSteps(): AutomationStep[];
    /**
       * @returns an object that can be used to build the json/yaml string representation of this document.
       */
    protected buildSsmDocument(): {
        [name: string]: any;
    };
    /**
       * Ensures that all outputs specified in the Automation document are valid and that the steps and outputs exist.
       * Throws if any output specified cannot be found.
       */
    private validateOutputs;
    documentType(): string;
}
