import { WebSocketRouteAuthorizerBindOptions, WebSocketRouteAuthorizerConfig, IWebSocketRouteAuthorizer } from '@aws-cdk/aws-apigatewayv2';
import { IFunction } from '@aws-cdk/aws-lambda';
/**
 * (experimental) Properties to initialize WebSocketTokenAuthorizer.
 *
 * @experimental
 */
export interface WebSocketLambdaAuthorizerProps {
    /**
     * (experimental) The name of the authorizer.
     *
     * @default - same value as `id` passed in the constructor.
     * @experimental
     */
    readonly authorizerName?: string;
    /**
     * (experimental) The identity source for which authorization is requested.
     *
     * Request parameter match `'route.request.querystring|header.[a-zA-z0-9._-]+'`.
     * Staged variable match `'stageVariables.[a-zA-Z0-9._-]+'`.
     * Context parameter match `'context.[a-zA-Z0-9._-]+'`.
     *
     * @default ['route.request.header.Authorization']
     * @experimental
     */
    readonly identitySource?: string[];
}
/**
 * (experimental) Authorize WebSocket Api routes via a lambda function.
 *
 * @experimental
 */
export declare class WebSocketLambdaAuthorizer implements IWebSocketRouteAuthorizer {
    private readonly id;
    private readonly handler;
    private readonly props;
    private authorizer?;
    private webSocketApi?;
    /**
     * @experimental
     */
    constructor(id: string, handler: IFunction, props?: WebSocketLambdaAuthorizerProps);
    /**
     * (experimental) (experimental) Bind this authorizer to a specified WebSocket route.
     *
     * @experimental
     */
    bind(options: WebSocketRouteAuthorizerBindOptions): WebSocketRouteAuthorizerConfig;
}
