/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.net.InetAddress;
import java.util.List;
import org.jgroups.protocols.PingData;
import org.jgroups.stack.RouterStub;
import org.jgroups.util.Promise;

public class RouterStubGet
implements RouterStub.MembersNotification {
    protected RouterStub stub;
    protected Promise<Void> promise = new Promise();

    protected void start(String host, int port, String cluster_name, boolean nio) {
        try {
            this.stub = new RouterStub(null, 0, InetAddress.getByName(host), port, nio, null, null);
            this.stub.connect();
            this.stub.getMembers(cluster_name, this);
            this.promise.getResult(5000L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.stub.destroy();
        }
    }

    @Override
    public void members(List<PingData> mbrs) {
        int cnt = 1;
        for (PingData data : mbrs) {
            System.out.printf("%d: %s\n", cnt++, data);
        }
        if (this.stub != null) {
            this.stub.destroy();
        }
        this.promise.setResult(null);
    }

    public static void main(String[] args2) {
        String host = "localhost";
        int port = 12001;
        String cluster_name = "draw";
        boolean nio = true;
        for (int i = 0; i < args2.length; ++i) {
            if (args2[i].equals("-host")) {
                host = args2[++i];
                continue;
            }
            if (args2[i].equals("-port")) {
                port = Integer.parseInt(args2[++i]);
                continue;
            }
            if (args2[i].equals("-cluster")) {
                cluster_name = args2[++i];
                continue;
            }
            if (args2[i].equals("-nio")) {
                nio = Boolean.parseBoolean(args2[++i]);
                continue;
            }
            RouterStubGet.help();
            return;
        }
        RouterStubGet get2 = new RouterStubGet();
        get2.start(host, port, cluster_name, nio);
    }

    private static void help() {
        System.out.println("RouterStubGet [-host <host>] [-port <port>] [-cluster <cluster name (default: draw>] [-nio true|false]");
    }
}

