/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.response;

import org.infinispan.configuration.cache.XSiteStateTransferMode;
import org.infinispan.remoting.RpcException;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.ResponseCollectors;
import org.infinispan.xsite.response.AutoStateTransferResponse;

public class AutoStateTransferResponseCollector
implements ResponseCollector<AutoStateTransferResponse> {
    private boolean isOffline;
    private XSiteStateTransferMode stateTransferMode;

    public AutoStateTransferResponseCollector(boolean isOffline, XSiteStateTransferMode stateTransferMode) {
        this.isOffline = isOffline;
        this.stateTransferMode = stateTransferMode;
    }

    @Override
    public synchronized AutoStateTransferResponse finish() {
        return new AutoStateTransferResponse(this.isOffline, this.stateTransferMode);
    }

    @Override
    public final AutoStateTransferResponse addResponse(Address sender, Response response) {
        if (response instanceof AutoStateTransferResponse) {
            this.merge((AutoStateTransferResponse)response);
        } else {
            if (response instanceof ExceptionResponse) {
                throw ResponseCollectors.wrapRemoteException(sender, ((ExceptionResponse)response).getException());
            }
            if (!(response instanceof CacheNotFoundResponse)) {
                throw ResponseCollectors.wrapRemoteException(sender, new RpcException("Unknown response type: " + response));
            }
        }
        return null;
    }

    public synchronized void merge(AutoStateTransferResponse response) {
        boolean bl = this.isOffline = this.isOffline || response.isOffline();
        if (response.stateTransferMode() == XSiteStateTransferMode.MANUAL) {
            this.stateTransferMode = XSiteStateTransferMode.MANUAL;
        }
    }
}

