/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.Parameter;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.xsite.SecurityActions;
import org.infinispan.xsite.XSiteAdminOperations;
import org.infinispan.xsite.statetransfer.XSiteStateTransferManager;
import org.infinispan.xsite.status.ContainerSiteStatusBuilder;
import org.infinispan.xsite.status.SiteStatus;

@Scope(value=Scopes.GLOBAL)
@MBean(objectName="GlobalXSiteAdminOperations", description="Exposes tooling for handling backing up data to remote sites.")
public class GlobalXSiteAdminOperations {
    public static final String CACHE_DELIMITER = ",";
    @Inject
    EmbeddedCacheManager cacheManager;

    private static void addCacheAdmin(Cache<?, ?> cache, List<CacheXSiteAdminOperation> list) {
        ComponentRegistry cacheRegistry;
        XSiteAdminOperations operation;
        if (cache != null && (operation = (cacheRegistry = SecurityActions.getCacheComponentRegistry(cache.getAdvancedCache())).getComponent(XSiteAdminOperations.class)) != null) {
            list.add(new CacheXSiteAdminOperation(cache.getName(), operation));
        }
    }

    public Map<String, String> takeAllCachesOffline(String site) {
        return this.performMultiCacheOperation(operations -> operations.takeSiteOffline(site));
    }

    public Map<String, String> bringAllCachesOnline(String site) {
        return this.performMultiCacheOperation(operations -> operations.bringSiteOnline(site));
    }

    public Map<String, String> pushStateAllCaches(String site) {
        return this.performMultiCacheOperation(operations -> operations.pushState(site));
    }

    public Map<String, String> cancelPushStateAllCaches(String site) {
        return this.performMultiCacheOperation(operations -> operations.cancelPushState(site));
    }

    @ManagedOperation(description="Takes this site offline in all caches in the cluster.", displayName="Takes this site offline in all caches in the cluster.")
    public String takeSiteOffline(@Parameter(name="site", description="The name of the backup site") String site) {
        return this.toJMXResponse(this.performMultiCacheOperation(operations -> operations.takeSiteOffline(site)));
    }

    @ManagedOperation(description="Brings the given site back online on all the caches.", displayName="Brings the given site back online on all the caches.")
    public String bringSiteOnline(@Parameter(name="site", description="The name of the backup site") String site) {
        return this.toJMXResponse(this.performMultiCacheOperation(operations -> operations.bringSiteOnline(site)));
    }

    @ManagedOperation(displayName="Push state to site", description="Pushes the state of all caches to the corresponding remote site if the cache backups to it. The remote site will be bring back online", name="pushState")
    public final String pushState(@Parameter(description="The destination site name", name="SiteName") String site) {
        return this.toJMXResponse(this.performMultiCacheOperation(operations -> operations.pushState(site)));
    }

    @ManagedOperation(displayName="Cancel Push State", description="Cancels the push state on all the caches to remote site.", name="CancelPushState")
    public final String cancelPushState(@Parameter(description="The destination site name", name="SiteName") String site) {
        return this.toJMXResponse(this.performMultiCacheOperation(operations -> operations.cancelPushState(site)));
    }

    public final Map<String, SiteStatus> globalStatus() {
        SecurityActions.checkPermission(this.cacheManager, AuthorizationPermission.ADMIN);
        Iterator<CacheXSiteAdminOperation> iterator2 = this.collectXSiteAdminOperation().iterator();
        if (!iterator2.hasNext()) {
            return Collections.emptyMap();
        }
        HashMap<String, ContainerSiteStatusBuilder> siteStatusBuilderMap = new HashMap<String, ContainerSiteStatusBuilder>();
        while (iterator2.hasNext()) {
            CacheXSiteAdminOperation xsiteAdminOperation = iterator2.next();
            xsiteAdminOperation.xSiteAdminOperations.clusterStatus().forEach((site, status) -> {
                ContainerSiteStatusBuilder builder = (ContainerSiteStatusBuilder)siteStatusBuilderMap.get(site);
                if (builder == null) {
                    builder = new ContainerSiteStatusBuilder();
                    siteStatusBuilderMap.put((String)site, builder);
                }
                builder.addCacheName(xsiteAdminOperation.cacheName, (SiteStatus)status);
            });
        }
        HashMap<String, SiteStatus> result = new HashMap<String, SiteStatus>();
        siteStatusBuilderMap.forEach((site, builder) -> result.put((String)site, builder.build()));
        return result;
    }

    public void onSitesUp(Collection<String> sitesUp) {
        for (ComponentRegistry registry : SecurityActions.getGlobalComponentRegistry(this.cacheManager).getNamedComponentRegistries()) {
            ComponentRef<XSiteStateTransferManager> st = registry.getXSiteStateTransferManager();
            if (st == null) continue;
            st.running().startAutomaticStateTransfer(sitesUp);
        }
    }

    private String toJMXResponse(Map<String, String> results) {
        return results.entrySet().stream().map(e -> (String)e.getKey() + ": " + (String)e.getValue()).collect(Collectors.joining(CACHE_DELIMITER));
    }

    private Map<String, String> performMultiCacheOperation(Operation operation) {
        SecurityActions.checkPermission(this.cacheManager, AuthorizationPermission.ADMIN);
        Collection<CacheXSiteAdminOperation> admOps = this.collectXSiteAdminOperation();
        if (admOps.isEmpty()) {
            return Collections.emptyMap();
        }
        return admOps.stream().collect(Collectors.toMap(op -> ((CacheXSiteAdminOperation)op).cacheName, op -> {
            try {
                return operation.execute(((CacheXSiteAdminOperation)op).xSiteAdminOperations);
            }
            catch (Exception e) {
                return "Exception on " + ((CacheXSiteAdminOperation)op).cacheName + " : " + e.getMessage();
            }
        }));
    }

    private Collection<CacheXSiteAdminOperation> collectXSiteAdminOperation() {
        Set<String> cacheNames = this.cacheManager.getCacheNames();
        ArrayList<CacheXSiteAdminOperation> operations = new ArrayList<CacheXSiteAdminOperation>(cacheNames.size() + 1);
        for (String cacheName : cacheNames) {
            GlobalXSiteAdminOperations.addCacheAdmin(this.cacheManager.getCache(cacheName, false), operations);
        }
        return operations;
    }

    private static class CacheXSiteAdminOperation {
        private final String cacheName;
        private final XSiteAdminOperations xSiteAdminOperations;

        private CacheXSiteAdminOperation(String cacheName, XSiteAdminOperations xSiteAdminOperations) {
            this.cacheName = cacheName;
            this.xSiteAdminOperations = xSiteAdminOperations;
        }
    }

    private static interface Operation {
        public String execute(XSiteAdminOperations var1);
    }
}

