/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.stream;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Deprecated
public class Streams {
    private static final Log log = LogFactory.getLog(Streams.class);
    public static final int DEFAULT_BUFFER_SIZE = 2048;

    public static boolean close(InputStream stream) {
        if (stream == null) {
            return true;
        }
        boolean success = true;
        try {
            stream.close();
        }
        catch (IOException e) {
            success = false;
        }
        return success;
    }

    public static boolean close(OutputStream stream) {
        if (stream == null) {
            return true;
        }
        boolean success = true;
        try {
            stream.close();
        }
        catch (IOException e) {
            success = false;
        }
        return success;
    }

    public static boolean close(Object stream) {
        boolean success;
        if (stream instanceof InputStream) {
            success = Streams.close((InputStream)stream);
        } else if (stream instanceof OutputStream) {
            success = Streams.close((OutputStream)stream);
        } else {
            throw new IllegalArgumentException("stream is not an InputStream or OutputStream");
        }
        return success;
    }

    public static boolean close(InputStream[] streams) {
        boolean success = true;
        for (InputStream stream : streams) {
            boolean rv = Streams.close(stream);
            if (rv) continue;
            success = false;
        }
        return success;
    }

    public static boolean close(OutputStream[] streams) {
        boolean success = true;
        for (OutputStream stream : streams) {
            boolean rv = Streams.close(stream);
            if (rv) continue;
            success = false;
        }
        return success;
    }

    public static boolean close(Object[] streams) {
        boolean success = true;
        for (Object stream : streams) {
            boolean rv = Streams.close(stream);
            if (rv) continue;
            success = false;
        }
        return success;
    }

    public static boolean fclose(OutputStream stream) {
        return Streams.flush(stream) && Streams.close(stream);
    }

    public static boolean fclose(OutputStream[] streams) {
        boolean success = true;
        for (OutputStream stream : streams) {
            boolean rv = Streams.fclose(stream);
            if (rv) continue;
            success = false;
        }
        return success;
    }

    public static boolean flush(OutputStream stream) {
        if (stream == null) {
            return true;
        }
        boolean success = true;
        try {
            stream.flush();
        }
        catch (IOException e) {
            success = false;
        }
        return success;
    }

    public static boolean flush(OutputStream[] streams) {
        boolean success = true;
        for (OutputStream stream : streams) {
            boolean rv = Streams.flush(stream);
            if (rv) continue;
            success = false;
        }
        return success;
    }

    public static long copy(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int read;
        long total = 0L;
        if (log.isTraceEnabled()) {
            log.tracef("copying %s to %s with buffer size: %d", (Object)input, (Object)output, (Object)buffer.length);
        }
        while ((read = input.read(buffer)) != -1) {
            output.write(buffer, 0, read);
            total += (long)read;
            if (!log.isTraceEnabled()) continue;
            log.tracef("bytes read: %d; total bytes read: %d", (long)read, total);
        }
        return total;
    }

    public static long copy(InputStream input, OutputStream output, int size) throws IOException {
        return Streams.copy(input, output, new byte[size]);
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        return Streams.copy(input, output, 2048);
    }

    public static long copyb(InputStream input, OutputStream output) throws IOException {
        if (!(input instanceof BufferedInputStream)) {
            input = new BufferedInputStream(input);
        }
        if (!(output instanceof BufferedOutputStream)) {
            output = new BufferedOutputStream(output);
        }
        long bytes = Streams.copy(input, output, 2048);
        output.flush();
        return bytes;
    }

    public static long copySome(InputStream input, OutputStream output, byte[] buffer, long length) throws IOException {
        int read;
        long total = 0L;
        boolean trace = log.isTraceEnabled();
        int readLength = Math.min((int)length, buffer.length);
        if (log.isTraceEnabled()) {
            log.tracef("initial read length: %d", readLength);
        }
        while (readLength != 0 && (read = input.read(buffer, 0, readLength)) != -1) {
            if (log.isTraceEnabled()) {
                log.tracef("read bytes: %d", read);
            }
            output.write(buffer, 0, read);
            total += (long)read;
            if (log.isTraceEnabled()) {
                log.tracef("total bytes read: %d", total);
            }
            readLength = Math.min((int)(length - total), buffer.length);
            if (!log.isTraceEnabled()) continue;
            log.tracef("next read length: %d", readLength);
        }
        return total;
    }

    public static long copySome(InputStream input, OutputStream output, int size, long length) throws IOException {
        return Streams.copySome(input, output, new byte[size], length);
    }

    public static long copySome(InputStream input, OutputStream output, long length) throws IOException {
        return Streams.copySome(input, output, 2048, length);
    }
}

