/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.infinispan.executors.LazyInitializingBlockingTaskAwareExecutorService;
import org.infinispan.util.concurrent.BlockingTaskAwareExecutorServiceImpl;
import org.jgroups.stack.DiagnosticsHandler;

class ThreadPoolProbeHandler
implements DiagnosticsHandler.ProbeHandler {
    private static final String KEY = "ispn-remote";
    private volatile ExecutorService executor;

    ThreadPoolProbeHandler() {
    }

    @Override
    public Map<String, String> handleProbe(String ... keys2) {
        if (keys2 == null || keys2.length == 0) {
            return null;
        }
        ThreadPoolExecutor exec = ThreadPoolProbeHandler.extract(this.executor);
        if (exec == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String[] stringArray = keys2;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String key;
            switch (key = stringArray[i]) {
                case "ispn-remote": {
                    map.put("active-thread", String.valueOf(exec.getActiveCount()));
                    map.put("min-thread", String.valueOf(exec.getCorePoolSize()));
                    map.put("max-thread", String.valueOf(exec.getMaximumPoolSize()));
                    map.put("current-pool-size", String.valueOf(exec.getPoolSize()));
                    map.put("largest-pool-size", String.valueOf(exec.getLargestPoolSize()));
                    map.put("keep-alive", String.valueOf(exec.getKeepAliveTime(TimeUnit.MILLISECONDS)));
                    map.put("queue-size", String.valueOf(exec.getQueue().size()));
                }
            }
        }
        return map.isEmpty() ? null : map;
    }

    @Override
    public String[] supportedKeys() {
        return new String[]{KEY};
    }

    void updateThreadPool(ExecutorService executorService) {
        if (executorService != null) {
            this.executor = executorService;
        }
    }

    private static ThreadPoolExecutor extract(ExecutorService service) {
        if (service instanceof ThreadPoolExecutor) {
            return (ThreadPoolExecutor)service;
        }
        if (service instanceof BlockingTaskAwareExecutorServiceImpl) {
            return ThreadPoolProbeHandler.extract(((BlockingTaskAwareExecutorServiceImpl)service).getExecutorService());
        }
        if (service instanceof LazyInitializingBlockingTaskAwareExecutorService) {
            return ThreadPoolProbeHandler.extract(((LazyInitializingBlockingTaskAwareExecutorService)service).getExecutorService());
        }
        return null;
    }
}

