/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.registry.impl;

import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.Cache;
import org.infinispan.configuration.ConfigurationManager;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.CacheManagerJmxRegistration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.registry.impl.SecurityActions;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
public class InternalCacheRegistryImpl
implements InternalCacheRegistry {
    private static final Log log = LogFactory.getLog(InternalCacheRegistryImpl.class);
    @Inject
    EmbeddedCacheManager cacheManager;
    @Inject
    CacheManagerJmxRegistration cacheManagerJmxRegistration;
    @Inject
    ConfigurationManager configurationManager;
    @Inject
    GlobalConfiguration globalConfiguration;
    private final ConcurrentMap<String, EnumSet<InternalCacheRegistry.Flag>> internalCaches = new ConcurrentHashMap<String, EnumSet<InternalCacheRegistry.Flag>>();
    private final Set<String> privateCaches = ConcurrentHashMap.newKeySet();

    @Override
    public void registerInternalCache(String name, Configuration configuration) {
        this.registerInternalCache(name, configuration, EnumSet.noneOf(InternalCacheRegistry.Flag.class));
    }

    @Override
    public synchronized void registerInternalCache(String name, Configuration configuration, EnumSet<InternalCacheRegistry.Flag> flags) {
        boolean configPresent;
        log.debugf("Registering internal cache %s %s", (Object)name, (Object)flags);
        boolean bl = configPresent = this.configurationManager.getConfiguration(name, false) != null;
        if ((flags.contains((Object)InternalCacheRegistry.Flag.EXCLUSIVE) || !this.internalCaches.containsKey(name)) && configPresent) {
            throw Log.CONFIG.existingConfigForInternalCache(name);
        }
        if (configPresent) {
            return;
        }
        ConfigurationBuilder builder = new ConfigurationBuilder().read(configuration);
        builder.statistics().disable();
        if (flags.contains((Object)InternalCacheRegistry.Flag.GLOBAL) && this.globalConfiguration.isClustered()) {
            builder.clustering().cacheMode(CacheMode.REPL_SYNC).stateTransfer().fetchInMemoryState(true).awaitInitialTransfer(true);
        }
        if (flags.contains((Object)InternalCacheRegistry.Flag.PERSISTENT)) {
            if (this.globalConfiguration.globalState().enabled()) {
                ((SingleFileStoreConfigurationBuilder)((SingleFileStoreConfigurationBuilder)((SingleFileStoreConfigurationBuilder)builder.persistence().availabilityInterval(-1).addSingleFileStore().location(this.globalConfiguration.globalState().persistentLocation()).segmented(false)).purgeOnStartup(false)).preload(true)).fetchPersistentState(true);
            } else {
                Log.CONFIG.warnUnableToPersistInternalCaches();
            }
        }
        SecurityActions.defineConfiguration(this.cacheManager, name, builder.build());
        this.internalCaches.put(name, flags);
        if (!flags.contains((Object)InternalCacheRegistry.Flag.USER)) {
            this.privateCaches.add(name);
        }
    }

    @Override
    public synchronized void unregisterInternalCache(String name) {
        log.debugf("Unregistering internal cache %s", (Object)name);
        if (this.isInternalCache(name)) {
            Cache cache = this.cacheManager.getCache(name, false);
            if (cache != null) {
                cache.stop();
            }
            this.internalCaches.remove(name);
            this.privateCaches.remove(name);
            SecurityActions.undefineConfiguration(this.cacheManager, name);
        }
    }

    @Override
    public boolean isInternalCache(String name) {
        return this.internalCaches.containsKey(name);
    }

    @Override
    public boolean isPrivateCache(String name) {
        return this.privateCaches.contains(name);
    }

    @Override
    public Set<String> getInternalCacheNames() {
        return this.internalCaches.keySet();
    }

    @Override
    public void filterPrivateCaches(Set<String> names) {
        names.removeAll(this.privateCaches);
    }

    @Override
    public boolean internalCacheHasFlag(String name, InternalCacheRegistry.Flag flag) {
        EnumSet flags = (EnumSet)this.internalCaches.get(name);
        return flags != null && flags.contains((Object)flag);
    }
}

