/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.protostream.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.marshall.BufferSizePredictor;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.commons.marshall.StreamAwareMarshaller;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.marshall.protostream.impl.MarshallableUserObject;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.util.logging.Log;

@Scope(value=Scopes.GLOBAL)
public abstract class AbstractInternalProtoStreamMarshaller
implements Marshaller,
StreamAwareMarshaller {
    private static final int PROTOSTREAM_DEFAULT_BUFFER_SIZE = 4096;
    @Inject
    protected SerializationContextRegistry ctxRegistry;
    @Inject
    @ComponentName(value="org.infinispan.marshaller.user")
    ComponentRef<Marshaller> userMarshallerRef;
    protected Marshaller userMarshaller;
    protected Log log;

    public abstract ImmutableSerializationContext getSerializationContext();

    protected AbstractInternalProtoStreamMarshaller(Log log) {
        this.log = log;
    }

    @Override
    @Start
    public void start() {
        this.userMarshaller = this.userMarshallerRef.running();
    }

    public Marshaller getUserMarshaller() {
        return this.userMarshaller;
    }

    @Override
    public ByteBuffer objectToBuffer(Object o) {
        return ByteBufferImpl.create(this.objectToByteBuffer(o, -1));
    }

    @Override
    public byte[] objectToByteBuffer(Object obj, int estimatedSize) {
        if (obj == null) {
            return null;
        }
        try {
            if (this.requiresWrapping(obj)) {
                obj = new MarshallableUserObject<Object>(obj);
            }
            int size = estimatedSize < 0 ? 4096 : estimatedSize;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(size);
            ProtobufUtil.toWrappedStream(this.getSerializationContext(), baos, obj, size);
            return baos.toByteArray();
        }
        catch (Throwable t) {
            this.log.cannotMarshall(obj.getClass(), t);
            if (t instanceof MarshallingException) {
                throw (MarshallingException)t;
            }
            throw new MarshallingException(t.getMessage(), t.getCause());
        }
    }

    @Override
    public byte[] objectToByteBuffer(Object obj) {
        return this.objectToByteBuffer(obj, this.sizeEstimate(obj));
    }

    @Override
    public Object objectFromByteBuffer(byte[] buf) throws IOException {
        return this.objectFromByteBuffer(buf, 0, buf.length);
    }

    @Override
    public Object objectFromByteBuffer(byte[] buf, int offset, int length) throws IOException {
        return this.unwrapAndInit(ProtobufUtil.fromWrappedByteArray(this.getSerializationContext(), buf, offset, length));
    }

    @Override
    public BufferSizePredictor getBufferSizePredictor(Object o) {
        return this.userMarshaller.getBufferSizePredictor(o);
    }

    @Override
    public void writeObject(Object o, OutputStream out) throws IOException {
        if (this.requiresWrapping(o)) {
            o = new MarshallableUserObject<Object>(o);
        }
        ProtobufUtil.toWrappedStream(this.getSerializationContext(), out, o, 4096);
    }

    @Override
    public Object readObject(InputStream in) throws ClassNotFoundException, IOException {
        return this.unwrapAndInit(ProtobufUtil.fromWrappedStream(this.getSerializationContext(), in));
    }

    protected Object unwrapAndInit(Object o) {
        if (o instanceof MarshallableUserObject) {
            return ((MarshallableUserObject)o).get();
        }
        return o;
    }

    @Override
    public boolean isMarshallable(Object o) {
        return this.isMarshallableWithProtoStream(o) || this.isUserMarshallable(o);
    }

    @Override
    public int sizeEstimate(Object o) {
        if (this.isMarshallableWithProtoStream(o)) {
            return 4096;
        }
        int userBytesEstimate = this.userMarshaller.getBufferSizePredictor(o.getClass()).nextSize(o);
        return MarshallableUserObject.size(userBytesEstimate);
    }

    @Override
    public MediaType mediaType() {
        return MediaType.APPLICATION_PROTOSTREAM;
    }

    private boolean requiresWrapping(Object o) {
        return !this.isMarshallableWithProtoStream(o);
    }

    private boolean isMarshallableWithProtoStream(Object o) {
        return this.getSerializationContext().canMarshall(o.getClass());
    }

    private boolean isUserMarshallable(Object o) {
        try {
            return this.userMarshaller.isMarshallable(o);
        }
        catch (Exception ignore) {
            return false;
        }
    }
}

