/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.RevokeBiasCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.distribution.BiasedCollector;
import org.infinispan.interceptors.distribution.CountDownCompletableFuture;
import org.infinispan.interceptors.distribution.ScatteredDistributionInterceptor;
import org.infinispan.remoting.responses.BiasRevocationResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.impl.MapResponseCollector;
import org.infinispan.scattered.BiasManager;
import org.infinispan.util.concurrent.CommandAckCollector;
import org.infinispan.util.concurrent.CompletableFutures;

public class BiasedScatteredDistributionInterceptor
extends ScatteredDistributionInterceptor {
    private CommandAckCollector commandAckCollector;
    private BiasManager biasManager;

    @Inject
    public void inject(CommandAckCollector collector, BiasManager biasManager) {
        this.commandAckCollector = collector;
        this.biasManager = biasManager;
    }

    @Override
    protected CompletionStage<ValidResponse> singleWriteOnRemotePrimary(Address target, DataWriteCommand command) {
        BiasedCollector collector = this.commandAckCollector.createBiased(command.getCommandInvocationId().getId(), command.getTopologyId());
        this.rpcManager.invokeCommand(target, (ReplicableCommand)command, collector, this.rpcManager.getSyncRpcOptions());
        return collector.getFuture();
    }

    @Override
    protected CompletionStage<ValidResponse> manyWriteOnRemotePrimary(Address target, WriteCommand command, CommandAckCollector.MultiTargetCollector multiTargetCollector) {
        BiasedCollector collector = multiTargetCollector.collectorFor(target);
        this.rpcManager.invokeCommand(target, (ReplicableCommand)command, collector, this.rpcManager.getSyncRpcOptions());
        return collector.getFuture();
    }

    @Override
    protected <C extends WriteCommand> CommandAckCollector.MultiTargetCollector createMultiTargetCollector(C command, int primaries) {
        return this.commandAckCollector.createMultiTargetCollector(command.getCommandInvocationId().getId(), primaries, command.getTopologyId());
    }

    @Override
    protected CompletionStage<?> completeSingleWriteOnPrimaryOriginator(DataWriteCommand command, Address backup, CompletionStage<?> rpcFuture) {
        CompletionStage<?> revokeFuture = this.revokeBiasSync(command.getKey(), backup, command.getTopologyId());
        return CompletableFuture.allOf(rpcFuture.toCompletableFuture(), revokeFuture.toCompletableFuture());
    }

    private CompletionStage<?> revokeBiasSync(Object key, Address backup, int topologyId) {
        BiasManager.Revocation revocation = this.biasManager.startRevokingRemoteBias(key, backup);
        if (revocation == null) {
            return CompletableFutures.completedNull();
        }
        if (revocation.shouldRevoke()) {
            CompletionStage<Map<Address, Response>> revocationRequest = this.sendRevokeBias(revocation.biased(), Collections.singleton(key), topologyId, null);
            revocationRequest.whenComplete(revocation);
            return revocationRequest;
        }
        return revocation.handleCompose(() -> this.revokeBiasSync(key, backup, topologyId));
    }

    @Override
    protected void completeManyWriteOnPrimaryOriginator(WriteCommand command, Address backup, CountDownCompletableFuture future) {
        this.revokeManyKeys(backup, future, command.getAffectedKeys(), command.getTopologyId());
    }

    private void revokeManyKeys(Address backup, CountDownCompletableFuture future, Collection<?> keys2, int topologyId) {
        HashMap<Address, GroupRevocation> revokedKeys = new HashMap<Address, GroupRevocation>();
        for (Object obj : keys2) {
            BiasManager.Revocation revocation = this.biasManager.startRevokingRemoteBias(obj, backup);
            if (revocation == null) continue;
            if (revocation.shouldRevoke()) {
                for (Address member : revocation.biased()) {
                    revokedKeys.computeIfAbsent(member, m3 -> new GroupRevocation()).add(obj, revocation);
                }
                continue;
            }
            future.increment();
            revocation.handleCompose(() -> {
                CompletionStage<?> revokeFuture = this.revokeBiasSync(key, backup, topologyId);
                revokeFuture.thenRun(future::countDown);
                return CompletableFutures.completedNull();
            });
        }
        for (Map.Entry entry : revokedKeys.entrySet()) {
            future.increment();
            this.sendRevokeBias(Collections.singleton((Address)entry.getKey()), ((GroupRevocation)entry.getValue()).keys, topologyId, null).whenComplete((nil, throwable) -> {
                if (throwable != null) {
                    ((GroupRevocation)mapping.getValue()).revocations.forEach(BiasManager.Revocation::fail);
                    future.completeExceptionally((Throwable)throwable);
                } else {
                    ((GroupRevocation)mapping.getValue()).revocations.forEach(BiasManager.Revocation::complete);
                    future.countDown();
                }
            });
        }
    }

    @Override
    protected Object singleWriteResponse(InvocationContext ctx, DataWriteCommand cmd, Object returnValue) {
        BiasManager.Revocation revocation;
        if (!cmd.isSuccessful() || (revocation = this.biasManager.startRevokingRemoteBias(cmd.getKey(), ctx.getOrigin())) == null) {
            return returnValue;
        }
        if (revocation.shouldRevoke()) {
            Address[] waitFor = revocation.biased().toArray(new Address[revocation.biased().size()]);
            this.sendRevokeBias(revocation.biased(), Collections.singleton(cmd.getKey()), cmd.getTopologyId(), cmd.getCommandInvocationId()).whenComplete(revocation);
            return new BiasRevocationResponse(returnValue, waitFor);
        }
        return BiasedScatteredDistributionInterceptor.asyncValue(revocation.toCompletionStage()).andHandle(ctx, cmd, (rCtx, rCommand, rv, throwable) -> this.singleWriteResponse(rCtx, (DataWriteCommand)rCommand, returnValue));
    }

    @Override
    protected Object manyWriteResponse(InvocationContext ctx, WriteCommand cmd, Object returnValue) {
        ArrayList<Address> waitFor = null;
        if (cmd.isSuccessful()) {
            Collection<?> keys2 = cmd.getAffectedKeys();
            HashMap<Address, GroupRevocation> revocations = new HashMap<Address, GroupRevocation>();
            ArrayList<CompletableFuture<CompletableFuture>> futures = null;
            for (Object obj : keys2) {
                BiasManager.Revocation revocation = this.biasManager.startRevokingRemoteBias(obj, ctx.getOrigin());
                if (revocation == null) continue;
                if (revocation.shouldRevoke()) {
                    if (waitFor == null) {
                        waitFor = new ArrayList<Address>(keys2.size());
                    }
                    waitFor.addAll(revocation.biased());
                    for (Address b : revocation.biased()) {
                        revocations.computeIfAbsent(b, a -> new GroupRevocation()).add(obj, revocation);
                    }
                    continue;
                }
                if (futures == null) {
                    futures = new ArrayList<CompletableFuture<CompletableFuture>>();
                }
                futures.add(revocation.handleCompose(() -> this.revokeBiasAsync(cmd, key, ctx.getOrigin())));
            }
            for (Map.Entry entry : revocations.entrySet()) {
                this.sendRevokeBias(Collections.singleton((Address)entry.getKey()), ((GroupRevocation)entry.getValue()).keys, cmd.getTopologyId(), cmd.getCommandInvocationId()).whenComplete((BiConsumer)entry.getValue());
            }
            if (futures != null) {
                ArrayList<Address> waitForFinal = waitFor;
                CompletableFuture[] completableFutureArray = futures.toArray(CompletableFutures.EMPTY_ARRAY);
                return BiasedScatteredDistributionInterceptor.asyncValue(CompletableFuture.allOf(completableFutureArray).thenApply(nil -> {
                    Address[] waitForAddresses = null;
                    if (waitForFinal != null) {
                        Stream.of(cfs).map(CompletableFuture::join).filter(Objects::nonNull).forEach(waitForFinal::addAll);
                        waitForAddresses = waitForFinal.toArray(Address.EMPTY_ARRAY);
                    }
                    return new BiasRevocationResponse(returnValue, waitForAddresses);
                }));
            }
        }
        if (waitFor == null) {
            return returnValue;
        }
        return new BiasRevocationResponse(returnValue, waitFor.toArray(Address.EMPTY_ARRAY));
    }

    private CompletableFuture<List<Address>> revokeBiasAsync(WriteCommand cmd, Object key, Address backup) {
        BiasManager.Revocation revocation = this.biasManager.startRevokingRemoteBias(key, backup);
        if (revocation == null) {
            return CompletableFutures.completedNull();
        }
        if (revocation.shouldRevoke()) {
            this.sendRevokeBias(revocation.biased(), Collections.singleton(key), cmd.getTopologyId(), cmd.getCommandInvocationId()).whenComplete(revocation);
            return CompletableFuture.completedFuture(revocation.biased());
        }
        return revocation.handleCompose(() -> this.revokeBiasAsync(cmd, key, backup));
    }

    private CompletionStage<Map<Address, Response>> sendRevokeBias(Collection<Address> targets, Collection<Object> keys2, int topologyId, CommandInvocationId commandInvocationId) {
        try {
            Address ackTarget = null;
            long id = 0L;
            if (commandInvocationId != null) {
                ackTarget = commandInvocationId.getAddress();
                id = commandInvocationId.getId();
            }
            RevokeBiasCommand revokeBiasCommand = this.cf.buildRevokeBiasCommand(ackTarget, id, topologyId, keys2);
            return this.rpcManager.invokeCommand(targets, (ReplicableCommand)revokeBiasCommand, MapResponseCollector.ignoreLeavers(targets.size()), this.rpcManager.getSyncRpcOptions());
        }
        catch (Throwable t) {
            return CompletableFutures.completedExceptionFuture(t);
        }
    }

    @Override
    protected Object handleClear(InvocationContext ctx, ClearCommand command, Object ignored) {
        Object superStage = super.handleClear(ctx, command, ignored);
        this.biasManager.clear();
        return superStage;
    }

    private static class GroupRevocation
    implements BiConsumer<Object, Throwable> {
        final Collection<Object> keys = new ArrayList<Object>();
        final Collection<BiasManager.Revocation> revocations = new ArrayList<BiasManager.Revocation>();

        private GroupRevocation() {
        }

        public void add(Object key, BiasManager.Revocation revocation) {
            this.keys.add(key);
            this.revocations.add(revocation);
        }

        @Override
        public void accept(Object o, Throwable throwable) {
            if (throwable != null) {
                this.revocations.forEach(BiasManager.Revocation::fail);
            } else {
                this.revocations.forEach(BiasManager.Revocation::complete);
            }
        }
    }
}

