/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.executors;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.executors.ManageableExecutorService;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;

@Scope(value=Scopes.GLOBAL)
public class LazyInitializingScheduledExecutorService
extends ManageableExecutorService<ScheduledExecutorService>
implements ScheduledExecutorService {
    private static final ScheduledExecutorService STOPPED = new ScheduledThreadPoolExecutor(0);
    private final ThreadPoolExecutorFactory<ScheduledExecutorService> executorFactory;
    private final ThreadFactory threadFactory;

    public LazyInitializingScheduledExecutorService(ThreadPoolExecutorFactory<ScheduledExecutorService> executorFactory, ThreadFactory threadFactory2) {
        this.executorFactory = executorFactory;
        this.threadFactory = threadFactory2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIfNeeded() {
        if (this.executor == null) {
            LazyInitializingScheduledExecutorService lazyInitializingScheduledExecutorService = this;
            synchronized (lazyInitializingScheduledExecutorService) {
                if (this.executor == null) {
                    this.executor = this.executorFactory.createExecutor(this.threadFactory);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        LazyInitializingScheduledExecutorService lazyInitializingScheduledExecutorService = this;
        synchronized (lazyInitializingScheduledExecutorService) {
            if (this.executor == null) {
                this.executor = STOPPED;
            }
            ((ScheduledExecutorService)this.executor).shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Stop
    public List<Runnable> shutdownNow() {
        LazyInitializingScheduledExecutorService lazyInitializingScheduledExecutorService = this;
        synchronized (lazyInitializingScheduledExecutorService) {
            if (this.executor == null) {
                this.executor = STOPPED;
            }
            return ((ScheduledExecutorService)this.executor).shutdownNow();
        }
    }

    @Override
    public boolean isShutdown() {
        return this.executor == null || ((ScheduledExecutorService)this.executor).isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executor == null || ((ScheduledExecutorService)this.executor).isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout2, TimeUnit unit) throws InterruptedException {
        if (this.executor == null) {
            return true;
        }
        return ((ScheduledExecutorService)this.executor).awaitTermination(timeout2, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        this.initIfNeeded();
        return ((ScheduledExecutorService)this.executor).submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        this.initIfNeeded();
        return ((ScheduledExecutorService)this.executor).submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        this.initIfNeeded();
        return ((ScheduledExecutorService)this.executor).submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        this.initIfNeeded();
        return ((ScheduledExecutorService)this.executor).invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout2, TimeUnit unit) throws InterruptedException {
        this.initIfNeeded();
        return ((ScheduledExecutorService)this.executor).invokeAll(tasks, timeout2, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        this.initIfNeeded();
        return ((ScheduledExecutorService)this.executor).invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout2, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.initIfNeeded();
        return ((ScheduledExecutorService)this.executor).invokeAny(tasks, timeout2, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.initIfNeeded();
        ((ScheduledExecutorService)this.executor).execute(command);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        this.initIfNeeded();
        return ((ScheduledExecutorService)this.executor).schedule(command, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        this.initIfNeeded();
        return ((ScheduledExecutorService)this.executor).schedule(callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        this.initIfNeeded();
        return ((ScheduledExecutorService)this.executor).scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        this.initIfNeeded();
        return ((ScheduledExecutorService)this.executor).scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    static {
        STOPPED.shutdown();
    }
}

