/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.infinispan.commons.util.AbstractEntrySizeCalculatorHelper;
import sun.misc.Unsafe;

public class PrimitiveEntrySizeCalculator
extends AbstractEntrySizeCalculatorHelper<Object, Object> {
    @Override
    public long calculateSize(Object key, Object value) {
        return this.handleObject(key) + this.handleObject(value);
    }

    protected long handleObject(Object object) {
        Class<?> objClass = object.getClass();
        if (objClass == String.class) {
            String realString = (String)object;
            long objectSize = PrimitiveEntrySizeCalculator.roundUpToNearest8(OBJECT_SIZE + POINTER_SIZE + 4 + POINTER_SIZE);
            return objectSize + PrimitiveEntrySizeCalculator.roundUpToNearest8(Unsafe.ARRAY_CHAR_BASE_OFFSET + realString.length() * Unsafe.ARRAY_CHAR_INDEX_SCALE);
        }
        if (objClass == Long.class) {
            long longValue = (Long)object;
            if (longValue >= -128L && longValue <= 127L) {
                return 0L;
            }
            return PrimitiveEntrySizeCalculator.roundUpToNearest8(Unsafe.ARRAY_LONG_INDEX_SCALE + OBJECT_SIZE + POINTER_SIZE);
        }
        if (objClass == Integer.class) {
            int intValue = (Integer)object;
            if (intValue >= -128 && intValue <= IntegerCacheConstraints.MAX_CACHE_VALUE) {
                return 0L;
            }
            return PrimitiveEntrySizeCalculator.roundUpToNearest8(Unsafe.ARRAY_INT_INDEX_SCALE + OBJECT_SIZE + POINTER_SIZE);
        }
        if (objClass == Short.class) {
            short shortValue = (Short)object;
            if (shortValue >= -128 && shortValue <= 127) {
                return 0L;
            }
            return PrimitiveEntrySizeCalculator.roundUpToNearest8(Unsafe.ARRAY_SHORT_INDEX_SCALE + OBJECT_SIZE + POINTER_SIZE);
        }
        if (objClass == Double.class) {
            return PrimitiveEntrySizeCalculator.roundUpToNearest8(Unsafe.ARRAY_DOUBLE_INDEX_SCALE + OBJECT_SIZE + POINTER_SIZE);
        }
        if (objClass == Float.class) {
            return PrimitiveEntrySizeCalculator.roundUpToNearest8(Unsafe.ARRAY_FLOAT_INDEX_SCALE + OBJECT_SIZE + POINTER_SIZE);
        }
        if (objClass == Boolean.class) {
            return 0L;
        }
        if (objClass == Character.class) {
            char charValue = ((Character)object).charValue();
            if (charValue >= '\u0000' && charValue <= '\u007f') {
                return 0L;
            }
            return PrimitiveEntrySizeCalculator.roundUpToNearest8(Unsafe.ARRAY_CHAR_INDEX_SCALE + OBJECT_SIZE + POINTER_SIZE);
        }
        if (objClass == Byte.class) {
            return 0L;
        }
        if (objClass.isArray()) {
            Unsafe unsafe = PrimitiveEntrySizeCalculator.getUnsafe();
            Class<?> compClass = objClass.getComponentType();
            int arrayLength = Array.getLength(object);
            long arraySize = PrimitiveEntrySizeCalculator.roundUpToNearest8(unsafe.arrayBaseOffset(objClass) + unsafe.arrayIndexScale(objClass) * arrayLength);
            if (!compClass.isPrimitive()) {
                for (int i = 0; i < arrayLength; ++i) {
                    arraySize += this.handleObject(Array.get(object, i));
                }
            }
            return arraySize;
        }
        throw new IllegalArgumentException("Size of Class " + objClass + " cannot be determined using given entry size calculator :" + this.getClass());
    }

    static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Class<Unsafe> k = Unsafe.class;
                        for (Field f : k.getDeclaredFields()) {
                            f.setAccessible(true);
                            Object x = f.get(null);
                            if (!k.isInstance(x)) continue;
                            return (Unsafe)k.cast(x);
                        }
                        throw new NoSuchFieldError("the Unsafe");
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException("Could not initialize intrinsics", e.getCause());
            }
        }
    }

    static class IntegerCacheConstraints {
        static final int MAX_CACHE_VALUE = IntegerCacheConstraints.calculateMaxIntCache();
        static final int MIN_CACHE_VALUE = -128;

        IntegerCacheConstraints() {
        }

        static int calculateMaxIntCache() {
            for (int i = 128; i < Integer.MAX_VALUE; ++i) {
                if (Integer.valueOf(i) == Integer.valueOf(i)) continue;
                return i - 1;
            }
            return Integer.MAX_VALUE;
        }
    }

    static class LongCacheConstraints {
        static final long MAX_CACHE_VALUE = 127L;
        static final long MIN_CACHE_VALUE = -128L;

        LongCacheConstraints() {
        }
    }

    static class ShortCacheConstraints {
        static final short MAX_CACHE_VALUE = 127;
        static final short MIN_CACHE_VALUE = -128;

        ShortCacheConstraints() {
        }
    }

    static class CharacterCacheConstraints {
        static final short MAX_CACHE_VALUE = 127;
        static final short MIN_CACHE_VALUE = 0;

        CharacterCacheConstraints() {
        }
    }
}

