/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.executors.CachedThreadPoolExecutorFactory;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.CachedThreadPoolConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.ScheduledThreadPoolConfiguration;
import org.infinispan.configuration.global.ThreadPoolBuilderAdapter;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.ThreadPoolConfigurationBuilder;
import org.infinispan.factories.threads.DefaultThreadFactory;

public class CachedThreadPoolConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<CachedThreadPoolConfiguration>,
ThreadPoolBuilderAdapter {
    private final AttributeSet attributes = CachedThreadPoolConfiguration.attributeDefinitionSet();

    CachedThreadPoolConfigurationBuilder(GlobalConfigurationBuilder globalConfig, String name) {
        super(globalConfig);
        this.attributes.attribute(CachedThreadPoolConfiguration.NAME).set(name);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public CachedThreadPoolConfigurationBuilder name(String name) {
        this.attributes.attribute(CachedThreadPoolConfiguration.NAME).set(name);
        return this;
    }

    public CachedThreadPoolConfigurationBuilder threadFactory(String threadFactory2) {
        this.attributes.attribute(CachedThreadPoolConfiguration.THREAD_FACTORY).set(threadFactory2);
        return this;
    }

    public String name() {
        return this.attributes.attribute(CachedThreadPoolConfiguration.NAME).get();
    }

    @Override
    public CachedThreadPoolConfiguration create() {
        return new CachedThreadPoolConfiguration(this.attributes.protect());
    }

    public CachedThreadPoolConfigurationBuilder read(CachedThreadPoolConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return "CachedThreadPoolConfigurationBuilder{attributes=" + this.attributes + '}';
    }

    @Override
    public ThreadPoolConfiguration asThreadPoolConfigurationBuilder() {
        ThreadPoolConfigurationBuilder builder = new ThreadPoolConfigurationBuilder(this.getGlobalConfig());
        builder.threadPoolFactory(CachedThreadPoolExecutorFactory.create());
        DefaultThreadFactory threadFactory2 = this.getGlobalConfig().threads().getThreadFactory(this.threadFactory()).create().getThreadFactory(false);
        builder.threadFactory(threadFactory2);
        builder.name(this.name());
        return builder.create();
    }

    public String threadFactory() {
        return this.attributes.attribute(ScheduledThreadPoolConfiguration.THREAD_FACTORY).get();
    }
}

