/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.JMXStatisticsConfigurationBuilder;
import org.infinispan.configuration.cache.StatisticsConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.util.logging.Log;

public class StatisticsConfigurationBuilder
extends JMXStatisticsConfigurationBuilder
implements Builder<StatisticsConfiguration> {
    private final AttributeSet attributes = StatisticsConfiguration.attributeDefinitionSet();

    StatisticsConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    @Override
    public StatisticsConfigurationBuilder enable() {
        this.attributes.attribute(StatisticsConfiguration.ENABLED).set(true);
        return this;
    }

    @Override
    public StatisticsConfigurationBuilder disable() {
        this.attributes.attribute(StatisticsConfiguration.ENABLED).set(false);
        return this;
    }

    @Override
    public StatisticsConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(StatisticsConfiguration.ENABLED).set(enabled);
        return this;
    }

    @Override
    @Deprecated
    public StatisticsConfigurationBuilder available(boolean available) {
        this.attributes.attribute(StatisticsConfiguration.AVAILABLE).set(available);
        return this;
    }

    @Override
    public void validate() {
        Attribute<Boolean> enabled = this.attributes.attribute(StatisticsConfiguration.ENABLED);
        Attribute<Boolean> available = this.attributes.attribute(StatisticsConfiguration.AVAILABLE);
        if (enabled.isModified() && available.isModified() && enabled.get().booleanValue() && !available.get().booleanValue()) {
            throw Log.CONFIG.statisticsEnabledNotAvailable();
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    @Override
    public StatisticsConfiguration create() {
        return new StatisticsConfiguration(this.attributes.protect());
    }

    public StatisticsConfigurationBuilder read(StatisticsConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return "StatisticsConfigurationBuilder [attributes=" + this.attributes + "]";
    }
}

