/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.SecurityActions;

public class LegacyKeySupportSystemProperties {
    private static final Log log = LogFactory.getLog(LegacyKeySupportSystemProperties.class);

    private static void warnLegacy(String oldKey, String newKey) {
        if (log.isInfoEnabled()) {
            log.infof("Could not find value for key %1$s, but did find value under deprecated key %2$s. Please use %1$s as support for %2$s will eventually be discontinued.", (Object)newKey, (Object)oldKey);
        }
    }

    public static String getProperty(String key, String legacyKey) {
        String val = SecurityActions.getProperty(key);
        if (val == null && (val = SecurityActions.getProperty(legacyKey)) != null) {
            LegacyKeySupportSystemProperties.warnLegacy(legacyKey, key);
        }
        return val;
    }

    public static String getProperty(String key, String legacyKey, String defaultValue) {
        String val = SecurityActions.getProperty(key);
        if (val == null) {
            val = SecurityActions.getProperty(legacyKey);
            if (val != null) {
                LegacyKeySupportSystemProperties.warnLegacy(legacyKey, key);
            } else {
                val = defaultValue;
            }
        }
        return val;
    }
}

