/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AbstractTypes {
    TYPE,
    ANY,
    NULL;


    public static AbstractTypes fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("Type".equals(codeString)) {
            return TYPE;
        }
        if ("Any".equals(codeString)) {
            return ANY;
        }
        throw new FHIRException("Unknown AbstractTypes code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case TYPE: {
                return "Type";
            }
            case ANY: {
                return "Any";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/abstract-types";
    }

    public String getDefinition() {
        switch (this) {
            case TYPE: {
                return "A place holder that means any kind of data type";
            }
            case ANY: {
                return "A place holder that means any kind of resource";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case TYPE: {
                return "Type";
            }
            case ANY: {
                return "Any";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

