/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionArbiter;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.processors.FlowableProcessor;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import io.reactivex.rxjava3.subscribers.SerializedSubscriber;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableRepeatWhen<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Function<? super Flowable<Object>, ? extends Publisher<?>> handler;

    public FlowableRepeatWhen(Flowable<T> source2, Function<? super Flowable<Object>, ? extends Publisher<?>> handler) {
        super(source2);
        this.handler = handler;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s2) {
        Publisher<?> when;
        SerializedSubscriber<? super T> z = new SerializedSubscriber<T>(s2);
        FlowableProcessor<Object> processor = UnicastProcessor.create(8).toSerialized();
        try {
            when = Objects.requireNonNull(this.handler.apply(processor), "handler returned a null Publisher");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            EmptySubscription.error(ex, s2);
            return;
        }
        WhenReceiver receiver = new WhenReceiver(this.source);
        RepeatWhenSubscriber subscriber = new RepeatWhenSubscriber(z, processor, (Subscription)receiver);
        receiver.subscriber = subscriber;
        s2.onSubscribe(subscriber);
        when.subscribe(receiver);
        receiver.onNext((Object)0);
    }

    static final class RepeatWhenSubscriber<T>
    extends WhenSourceSubscriber<T, Object> {
        private static final long serialVersionUID = -2680129890138081029L;

        RepeatWhenSubscriber(Subscriber<? super T> actual, FlowableProcessor<Object> processor, Subscription receiver) {
            super(actual, processor, receiver);
        }

        @Override
        public void onError(Throwable t) {
            this.receiver.cancel();
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            this.again(0);
        }
    }

    static abstract class WhenSourceSubscriber<T, U>
    extends SubscriptionArbiter
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = -5604623027276966720L;
        protected final Subscriber<? super T> downstream;
        protected final FlowableProcessor<U> processor;
        protected final Subscription receiver;
        private long produced;

        WhenSourceSubscriber(Subscriber<? super T> actual, FlowableProcessor<U> processor, Subscription receiver) {
            super(false);
            this.downstream = actual;
            this.processor = processor;
            this.receiver = receiver;
        }

        @Override
        public final void onSubscribe(Subscription s2) {
            this.setSubscription(s2);
        }

        @Override
        public final void onNext(T t) {
            ++this.produced;
            this.downstream.onNext(t);
        }

        protected final void again(U signal) {
            this.setSubscription(EmptySubscription.INSTANCE);
            long p = this.produced;
            if (p != 0L) {
                this.produced = 0L;
                this.produced(p);
            }
            this.receiver.request(1L);
            this.processor.onNext(signal);
        }

        @Override
        public final void cancel() {
            super.cancel();
            this.receiver.cancel();
        }
    }

    static final class WhenReceiver<T, U>
    extends AtomicInteger
    implements FlowableSubscriber<Object>,
    Subscription {
        private static final long serialVersionUID = 2827772011130406689L;
        final Publisher<T> source;
        final AtomicReference<Subscription> upstream;
        final AtomicLong requested;
        WhenSourceSubscriber<T, U> subscriber;

        WhenReceiver(Publisher<T> source2) {
            this.source = source2;
            this.upstream = new AtomicReference();
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(Subscription s2) {
            SubscriptionHelper.deferredSetOnce(this.upstream, this.requested, s2);
        }

        @Override
        public void onNext(Object t) {
            block2: {
                if (this.getAndIncrement() != 0) break block2;
                do {
                    if (this.upstream.get() == SubscriptionHelper.CANCELLED) {
                        return;
                    }
                    this.source.subscribe(this.subscriber);
                } while (this.decrementAndGet() != 0);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.subscriber.cancel();
            this.subscriber.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            this.subscriber.cancel();
            this.subscriber.downstream.onComplete();
        }

        @Override
        public void request(long n) {
            SubscriptionHelper.deferredRequest(this.upstream, this.requested, n);
        }

        @Override
        public void cancel() {
            SubscriptionHelper.cancel(this.upstream);
        }
    }
}

