/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.exceptions;

import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;

public class MethodNotAllowedException
extends BaseServerResponseException {
    private static final long serialVersionUID = 1L;
    public static final int STATUS_CODE = 405;
    private Set<RequestTypeEnum> myAllowedMethods;

    public MethodNotAllowedException(String theMessage, IBaseOperationOutcome theOperationOutcome, RequestTypeEnum ... theAllowedMethods) {
        super(405, theMessage, theOperationOutcome);
        this.setAllowedMethods(theAllowedMethods);
    }

    public MethodNotAllowedException(String theMessage, RequestTypeEnum ... theAllowedMethods) {
        super(405, theMessage);
        this.setAllowedMethods(theAllowedMethods);
    }

    public MethodNotAllowedException(String theMessage, IBaseOperationOutcome theOperationOutcome) {
        super(405, theMessage, theOperationOutcome);
    }

    public MethodNotAllowedException(String theMessage) {
        super(405, theMessage);
    }

    public Set<RequestTypeEnum> getAllowedMethods() {
        return this.myAllowedMethods;
    }

    public void setAllowedMethods(RequestTypeEnum ... theAllowedMethods) {
        if (theAllowedMethods == null || theAllowedMethods.length == 0) {
            this.myAllowedMethods = null;
        } else {
            this.myAllowedMethods = new LinkedHashSet<RequestTypeEnum>();
            for (RequestTypeEnum next : theAllowedMethods) {
                this.myAllowedMethods.add(next);
            }
        }
        this.updateAllowHeader();
    }

    public void setAllowedMethods(Set<RequestTypeEnum> theAllowedMethods) {
        this.myAllowedMethods = theAllowedMethods;
        this.updateAllowHeader();
    }

    private void updateAllowHeader() {
        this.getResponseHeaders().remove("Allow");
        StringBuilder b = new StringBuilder();
        for (RequestTypeEnum next : this.myAllowedMethods) {
            if (b.length() > 0) {
                b.append(',');
            }
            b.append(next.name());
        }
        this.addResponseHeader("Allow", b.toString());
    }
}

