/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.terminology.caching;

import au.csiro.pathling.config.HttpClientCachingConfiguration;
import au.csiro.pathling.fhir.TerminologyClient;
import au.csiro.pathling.terminology.caching.CachingTerminologyService;
import java.io.Closeable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;

public class InMemoryCachingTerminologyService
extends CachingTerminologyService {
    public InMemoryCachingTerminologyService(@Nonnull TerminologyClient terminologyClient, @Nullable Closeable toClose, @Nonnull HttpClientCachingConfiguration configuration) {
        super(terminologyClient, toClose, configuration);
    }

    @Override
    protected EmbeddedCacheManager buildCacheManager() {
        return new DefaultCacheManager();
    }

    @Override
    protected Cache<Integer, ?> buildCache(@Nonnull EmbeddedCacheManager cacheManager, @Nonnull String cacheName) {
        Configuration cacheConfig = new ConfigurationBuilder().memory().maxCount(this.configuration.getMaxEntries()).whenFull(EvictionStrategy.REMOVE).build();
        cacheManager.defineConfiguration(cacheName, cacheConfig);
        return cacheManager.getCache(cacheName);
    }
}

