/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.sql.udf;

import au.csiro.pathling.sql.udf.SqlFunction;
import au.csiro.pathling.sql.udf.SqlFunction2;
import au.csiro.pathling.sql.udf.TerminologyUdfHelpers;
import au.csiro.pathling.terminology.TerminologyService;
import au.csiro.pathling.terminology.TerminologyServiceFactory;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.hl7.fhir.r4.model.Coding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemberOfUdf
implements SqlFunction,
SqlFunction2<Object, String, Boolean> {
    private static final Logger log = LoggerFactory.getLogger(MemberOfUdf.class);
    private static final long serialVersionUID = 7605853352299165569L;
    public static final String FUNCTION_NAME = "member_of";
    @Nonnull
    private final TerminologyServiceFactory terminologyServiceFactory;

    MemberOfUdf(@Nonnull TerminologyServiceFactory terminologyServiceFactory) {
        this.terminologyServiceFactory = terminologyServiceFactory;
    }

    @Override
    public DataType getReturnType() {
        return DataTypes.BooleanType;
    }

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Nullable
    public Boolean call(@Nullable Object codingRowOrArray, @Nullable String url) {
        return this.doCall(TerminologyUdfHelpers.decodeOneOrMany(codingRowOrArray), url);
    }

    @Nullable
    protected Boolean doCall(@Nullable Stream<Coding> codings, @Nullable String url) {
        if (url == null || codings == null) {
            return null;
        }
        TerminologyService terminologyService = this.terminologyServiceFactory.build();
        return TerminologyUdfHelpers.validCodings(codings).anyMatch(coding -> terminologyService.validateCode(url, (Coding)coding));
    }
}

