#!/usr/bin/env python
from setuptools import setup
setup(
  name = 'cs.mailutils',
  author = 'Cameron Simpson',
  author_email = 'cs@cskk.id.au',
  version = '20210306',
  url = 'https://bitbucket.org/cameron_simpson/css/commits/all',
  description =
    'functions and classes to work with email',
  long_description =
    ('Convenience functions and classes to work with email.\n'    
 '      - Cameron Simpson <cs@cskk.id.au>\n'    
 '#\n'    
 '\n'    
 '*Latest release 20210306*:\n'    
 'New RFC5322_DATE_TIME with format for datetime.strptime to emit an RFC5322 '    
 'date-time token.\n'    
 '\n'    
 '## Function `ismaildir(path)`\n'    
 '\n'    
 'Test if `path` points at a Maildir directory.\n'    
 '\n'    
 '## Function `ismbox(path)`\n'    
 '\n'    
 'Open path and check that its first line begins with "From ".\n'    
 '\n'    
 '## Function `ismhdir(path)`\n'    
 '\n'    
 'Test if `path` points at an MH directory.\n'    
 '\n'    
 '## Class `Maildir(mailbox.Maildir,mailbox.Mailbox)`\n'    
 '\n'    
 'A faster Maildir interface.\n'    
 "Trust os.listdir, don't fsync, etc.\n"    
 '\n'    
 '### Method `Maildir.__getitem__(self, key)`\n'    
 '\n'    
 'Return a mailbox.Message loaded from the message with key `key`.\n'    
 "The Message's .pathname property contains .keypath(key),\n"    
 'the pathname to the message file.\n'    
 '\n'    
 '### Method `Maildir.add(self, message, key=None)`\n'    
 '\n'    
 'Add a message to the Maildir.\n'    
 '`message` may be an email.message.Message instance or a path to a file.\n'    
 '\n'    
 '### Method `Maildir.as_mbox(self, fp, keys=None)`\n'    
 '\n'    
 'Transcribe the contents of this maildir in UNIX mbox format to the\n'    
 'file `fp`.\n'    
 'The optional iterable `keys` designates the messages to transcribe.\n'    
 'The default is to transcribe all messages.\n'    
 '\n'    
 '### Method `Maildir.flush(self)`\n'    
 '\n'    
 'Forget state.\n'    
 '\n'    
 '### Method `Maildir.get_headers(self, key)`\n'    
 '\n'    
 'Return the headers of the specified message as\n'    
 '\n'    
 '### Method `Maildir.get_message(self, key)`\n'    
 '\n'    
 'Return a mailbox.Message loaded from the message with key `key`.\n'    
 "The Message's .pathname property contains .keypath(key),\n"    
 'the pathname to the message file.\n'    
 '\n'    
 '### Method `Maildir.iterheaders(self)`\n'    
 '\n'    
 'Yield (key, headers) from the Maildir.\n'    
 '\n'    
 '### Method `Maildir.keypath(self, key)`\n'    
 '\n'    
 'Return the path to the message with maildir key `key`.\n'    
 '\n'    
 '### Property `Maildir.msgmap`\n'    
 '\n'    
 'Scan the maildir, return key->message-info mapping.\n'    
 '\n'    
 '### Method `Maildir.newkey(self)`\n'    
 '\n'    
 'Allocate a new key.\n'    
 '\n'    
 "### Method `Maildir.open(self, key, mode='r')`\n"    
 '\n'    
 'Open the file storing the message specified by `key`.\n'    
 '\n'    
 "### Method `Maildir.save_file(self, fp, key=None, flags='')`\n"    
 '\n'    
 'Save the contents of the file-like object `fp` into the Maildir.\n'    
 'Return the key for the saved message.\n'    
 '\n'    
 '### Method `Maildir.save_filepath(self, filepath, key=None, nolink=False, '    
 "flags='')`\n"    
 '\n'    
 'Save the file specified by `filepath` into the Maildir.\n'    
 'By default a hardlink is attempted unless `nolink` is supplied true.\n'    
 'The optional `flags` is a string consisting of flag letters listed at:\n'    
 '  http://cr.yp.to/proto/maildir.html\n'    
 'Return the key for the saved message.\n'    
 '\n'    
 "### Method `Maildir.save_message(self, M, key=None, flags='')`\n"    
 '\n'    
 'Save the contents of the Message `M` into the Maildir.\n'    
 'Return the key for the saved message.\n'    
 '\n'    
 '## Function `make_maildir(path)`\n'    
 '\n'    
 'Create a new maildir at `path`.\n'    
 'The path must not already exist.\n'    
 '\n'    
 '## Function `Message(msgfile, headersonly=False)`\n'    
 '\n'    
 'Factory function to accept a file or filename and return an '    
 'email.message.Message.\n'    
 '\n'    
 '## Function `message_addresses(M, header_names)`\n'    
 '\n'    
 'Yield (realname, address) pairs from all the named headers.\n'    
 '\n'    
 '## Function `modify_header(M, hdr, new_values, always=False)`\n'    
 '\n'    
 'Modify a Message `M` to change the value of the named header `hdr` to the '    
 'new value `new_values` (a string or an interable of strings).\n'    
 'If `new_values` is a string subclass, convert to a single element list.\n'    
 'If `new_values` differs from the existing value or if `always`\n'    
 'is true, save the old value as X-Old-`hdr`.\n'    
 'Return a Boolean indicating whether the headers were modified.\n'    
 '\n'    
 '# Release Log\n'    
 '\n'    
 '\n'    
 '\n'    
 '*Release 20210306*:\n'    
 'New RFC5322_DATE_TIME with format for datetime.strptime to emit an RFC5322 '    
 'date-time token.\n'    
 '\n'    
 '*Release 20171231.1*:\n'    
 'DISTINFO fix. No semantic changes.\n'    
 '\n'    
 '*Release 20171231*:\n'    
 'Update imports, clean some lint. No semantic changes.\n'    
 '\n'    
 '*Release 20160828*:\n'    
 '* Use "install_requires" instead of "requires" in DISTINFO.\n'    
 '* modify_header: accept multiple header values.\n'    
 '* Message factory function: open message files with errors="replace" because '    
 'messages might have any arbitrary guff in them; accept the mangling that may '    
 'occur.\n'    
 '* Add new_message_id() and need_message_id().\n'    
 '* Add message_references() to return related Message-IDs from Reply-To: and '    
 'References: headers.\n'    
 '* Python 2/3 portability fixes.\n'    
 '* Assorted bugfixes and improvements.\n'    
 '\n'    
 '*Release 20150116.2*:\n'    
 'Update PyPI metadata.\n'    
 '\n'    
 '*Release 20150116*:\n'    
 'Initial PyPI release.'),
  classifiers = ['Programming Language :: Python', 'Programming Language :: Python :: 2', 'Programming Language :: Python :: 3', 'Development Status :: 4 - Beta', 'Intended Audience :: Developers', 'Operating System :: OS Independent', 'Topic :: Software Development :: Libraries :: Python Modules', 'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)'],
  install_requires = ['cs.fileutils', 'cs.logutils', 'cs.pfx', 'cs.py3', 'cs.seq', 'cs.threads'],
  keywords = ['python2', 'python3'],
  license = 'GNU General Public License v3 or later (GPLv3+)',
  long_description_content_type = 'text/markdown',
  package_dir = {'': 'lib/python'},
  py_modules = ['cs.mailutils'],
)
