import datetime
from typing import Any, Dict, Optional

import requests

from ...client import AuthenticatedClient
from ...models.exploits_api_v1_report_date_retrieve_response_200 import (
    ExploitsApiV1ReportDateRetrieveResponse200,
)
from ...types import UNSET, Response, Unset


def _get_kwargs(
    date: datetime.date,
    *,
    client: AuthenticatedClient,
) -> Dict[str, Any]:
    url = "{}/exploits/api/v1/report/date/{date}".format(
        client.base_url,
        date=date,
    )

    headers: Dict[str, Any] = client.get_headers()

    return {
        "url": url,
        "headers": headers,
    }


def _parse_response(
    *, response: requests.Response
) -> Optional[ExploitsApiV1ReportDateRetrieveResponse200]:
    if response.status_code == 200:
        _response_200 = response.json()
        response_200: ExploitsApiV1ReportDateRetrieveResponse200
        if isinstance(_response_200, Unset):
            response_200 = UNSET
        else:
            response_200 = ExploitsApiV1ReportDateRetrieveResponse200.from_dict(
                _response_200
            )

        return response_200
    return None


def _build_response(
    *, response: requests.Response
) -> Response[ExploitsApiV1ReportDateRetrieveResponse200]:
    return Response(
        status_code=response.status_code,
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(response=response),
    )


def sync_detailed(
    date: datetime.date,
    *,
    client: AuthenticatedClient,
) -> Response[ExploitsApiV1ReportDateRetrieveResponse200]:
    kwargs = _get_kwargs(
        date=date,
        client=client,
    )

    response = requests.get(
        verify=client.verify_ssl,
        auth=client.auth,
        timeout=client.timeout,
        **kwargs,
    )
    response.raise_for_status()

    return _build_response(response=response)


def sync(
    date: datetime.date,
    *,
    client: AuthenticatedClient,
) -> Optional[ExploitsApiV1ReportDateRetrieveResponse200]:
    """API endpoint for getting date based report for Incident Response.

    Format of results:
    ```
    {
      \"cutoff_date\": <Date>,
      \"evaluated_cves\": <Number of new CVEs with exploits>,
      \"action_required\": [<List of affects requiring action>],
      \"no_action\": [<List of CVEs not requiring action with reason>],
      \"not_relevant\": [<List of CVEs which are not in the database with reason>],
    }
    ```

    **NOTE:** No pagination is performed on this endpoint as data is limited by date and is expected
              to be fairly small. Also, because data is broken into three categories it is not
              exactly obvious how to create pages."""

    return sync_detailed(
        date=date,
        client=client,
    ).parsed
