#### Introduction

To mimic the py\_mob package (https://pypi.org/project/py-mob) for binary outcomes, the freq\_mob is a collection of python functions that would generate the monotonic binning and perform the variable transformation for frequency outcomes such that the Pearson correlation between the transformed X and Ln(Y) is equal to 1. 

#### Core Functions

```
freq_mob
  |-- qtl_bin()  : An iterative discretization based on quantiles of X.  
  |-- cnt_bin()  : A revised iterative discretization for records with Y > 0.
  |-- iso_bin()  : A discretization algorthm driven by the isotonic regression between X and Y. 
  |-- rng_bin()  : A revised iterative discretization based on the range of X values.  
  |-- kmn_bin()  : A discretization algorthm based on the kmeans clustering of X.  
  |-- gbm_bin()  : A discretization algorthm based on the gradient boosting machine.  
  |-- view_bin() : Displays the binning outcome in a tabular form. 
  `-- cal_newx() : Applies the variable transformation to a numeric vector based on the binning outcome.
```

###  Authors

[WenSui Liu](mailto:liuwensui@gmail.com) is a seasoned data scientist with 15-year experience in the financial service industry. 
[Joyce Liu](mailto:jcl4482@my.utexas.edu) is a college student major in Mathematics. 
