import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::DevOpsGuru::NotificationChannel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-notificationchannel.html
 * @external
 */
export interface CfnNotificationChannelProps {
    /**
     * `AWS::DevOpsGuru::NotificationChannel.Config`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-notificationchannel.html#cfn-devopsguru-notificationchannel-config
     * @external
     */
    readonly config: CfnNotificationChannel.NotificationChannelConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::DevOpsGuru::NotificationChannel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-notificationchannel.html
 * @external
 * @cloudformationResource AWS::DevOpsGuru::NotificationChannel
 */
export declare class CfnNotificationChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DevOpsGuru::NotificationChannel";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnNotificationChannel;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::DevOpsGuru::NotificationChannel.Config`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-notificationchannel.html#cfn-devopsguru-notificationchannel-config
     * @external
     */
    config: CfnNotificationChannel.NotificationChannelConfigProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::DevOpsGuru::NotificationChannel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNotificationChannelProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::DevOpsGuru::NotificationChannel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-notificationchannel.html
 * @external
 * @cloudformationResource AWS::DevOpsGuru::NotificationChannel
 */
export declare namespace CfnNotificationChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-notificationchannel-notificationchannelconfig.html
     * @external
     */
    interface NotificationChannelConfigProperty {
        /**
         * `CfnNotificationChannel.NotificationChannelConfigProperty.Sns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-notificationchannel-notificationchannelconfig.html#cfn-devopsguru-notificationchannel-notificationchannelconfig-sns
         * @external
         */
        readonly sns?: CfnNotificationChannel.SnsChannelConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::DevOpsGuru::NotificationChannel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-notificationchannel.html
 * @external
 * @cloudformationResource AWS::DevOpsGuru::NotificationChannel
 */
export declare namespace CfnNotificationChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-notificationchannel-snschannelconfig.html
     * @external
     */
    interface SnsChannelConfigProperty {
        /**
         * `CfnNotificationChannel.SnsChannelConfigProperty.TopicArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-notificationchannel-snschannelconfig.html#cfn-devopsguru-notificationchannel-snschannelconfig-topicarn
         * @external
         */
        readonly topicArn?: string;
    }
}
/**
 * Properties for defining a `AWS::DevOpsGuru::ResourceCollection`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-resourcecollection.html
 * @external
 */
export interface CfnResourceCollectionProps {
    /**
     * `AWS::DevOpsGuru::ResourceCollection.ResourceCollectionFilter`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-resourcecollection.html#cfn-devopsguru-resourcecollection-resourcecollectionfilter
     * @external
     */
    readonly resourceCollectionFilter: CfnResourceCollection.ResourceCollectionFilterProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::DevOpsGuru::ResourceCollection`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-resourcecollection.html
 * @external
 * @cloudformationResource AWS::DevOpsGuru::ResourceCollection
 */
export declare class CfnResourceCollection extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DevOpsGuru::ResourceCollection";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnResourceCollection;
    /**
     * @external
     * @cloudformationAttribute ResourceCollectionType
     */
    readonly attrResourceCollectionType: string;
    /**
     * `AWS::DevOpsGuru::ResourceCollection.ResourceCollectionFilter`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-resourcecollection.html#cfn-devopsguru-resourcecollection-resourcecollectionfilter
     * @external
     */
    resourceCollectionFilter: CfnResourceCollection.ResourceCollectionFilterProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::DevOpsGuru::ResourceCollection`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnResourceCollectionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::DevOpsGuru::ResourceCollection`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-resourcecollection.html
 * @external
 * @cloudformationResource AWS::DevOpsGuru::ResourceCollection
 */
export declare namespace CfnResourceCollection {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-resourcecollection-cloudformationcollectionfilter.html
     * @external
     */
    interface CloudFormationCollectionFilterProperty {
        /**
         * `CfnResourceCollection.CloudFormationCollectionFilterProperty.StackNames`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-resourcecollection-cloudformationcollectionfilter.html#cfn-devopsguru-resourcecollection-cloudformationcollectionfilter-stacknames
         * @external
         */
        readonly stackNames?: string[];
    }
}
/**
 * A CloudFormation `AWS::DevOpsGuru::ResourceCollection`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-devopsguru-resourcecollection.html
 * @external
 * @cloudformationResource AWS::DevOpsGuru::ResourceCollection
 */
export declare namespace CfnResourceCollection {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-resourcecollection-resourcecollectionfilter.html
     * @external
     */
    interface ResourceCollectionFilterProperty {
        /**
         * `CfnResourceCollection.ResourceCollectionFilterProperty.CloudFormation`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-devopsguru-resourcecollection-resourcecollectionfilter.html#cfn-devopsguru-resourcecollection-resourcecollectionfilter-cloudformation
         * @external
         */
        readonly cloudFormation?: CfnResourceCollection.CloudFormationCollectionFilterProperty | cdk.IResolvable;
    }
}
