# Generated by Django 3.1.13 on 2021-09-06 14:47

import django.core.serializers.json
from django.db import migrations, models
import django.db.models.deletion
import enumfields.fields
import security.enums


class Migration(migrations.Migration):
    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='CeleryTaskInvocationLog',
            fields=[
                ('id', models.UUIDField(primary_key=True, serialize=False)),
                ('extra_data',
                 models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True)),
                ('slug', models.CharField(blank=True, db_index=True, max_length=255, null=True)),
                ('start', models.DateTimeField(editable=False)),
                ('stop', models.DateTimeField(blank=True, editable=False, null=True)),
                ('time', models.FloatField(blank=True, null=True)),
                ('celery_task_id', models.UUIDField(blank=True, db_index=True, null=True)),
                ('name', models.CharField(db_index=True, max_length=250)),
                ('queue_name', models.CharField(blank=True, max_length=250, null=True)),
                ('applied_at', models.DateTimeField()),
                ('triggered_at', models.DateTimeField(blank=True, null=True)),
                ('is_unique', models.BooleanField()),
                ('is_async', models.BooleanField()),
                ('is_duplicate', models.BooleanField(blank=True, null=True)),
                ('is_on_commit', models.BooleanField()),
                ('input', models.TextField(blank=True, editable=False, null=True)),
                ('task_args',
                 models.JSONField(blank=True, editable=False, encoder=django.core.serializers.json.DjangoJSONEncoder,
                                  null=True)),
                ('task_kwargs',
                 models.JSONField(blank=True, editable=False, encoder=django.core.serializers.json.DjangoJSONEncoder,
                                  null=True)),
                ('estimated_time_of_first_arrival',
                 models.DateTimeField(blank=True, null=True)),
                ('expires_at', models.DateTimeField(blank=True, null=True)),
                ('stale_at', models.DateTimeField(blank=True, null=True)),
                ('state', enumfields.fields.NumEnumField(db_index=True, default=1,
                                                         enum=security.enums.CeleryTaskInvocationLogState)),
            ],
            options={
                'ordering': ('-created_at',),
            },
        ),
        migrations.CreateModel(
            name='CeleryTaskRunLog',
            fields=[
                ('id', models.UUIDField(primary_key=True, serialize=False)),
                ('extra_data',
                 models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True)),
                ('slug', models.CharField(blank=True, db_index=True, max_length=255, null=True)),
                ('start', models.DateTimeField(editable=False)),
                ('stop', models.DateTimeField(blank=True, editable=False, null=True)),
                ('time', models.FloatField(blank=True, null=True)),
                ('celery_task_id', models.UUIDField(blank=True, db_index=True, null=True)),
                ('name', models.CharField(db_index=True, max_length=250)),
                ('queue_name', models.CharField(blank=True, max_length=250, null=True)),
                ('input', models.TextField(blank=True, editable=False, null=True)),
                ('task_args',
                 models.JSONField(blank=True, editable=False, encoder=django.core.serializers.json.DjangoJSONEncoder,
                                  null=True)),
                ('task_kwargs',
                 models.JSONField(blank=True, editable=False, encoder=django.core.serializers.json.DjangoJSONEncoder,
                                  null=True)),
                ('state',
                 enumfields.fields.NumEnumField(db_index=True, default=1, enum=security.enums.CeleryTaskRunLogState)),
                ('result',
                 models.JSONField(blank=True, editable=False, encoder=django.core.serializers.json.DjangoJSONEncoder,
                                  null=True)),
                ('error_message', models.TextField(blank=True, null=True)),
                ('output', models.TextField(blank=True, editable=False, null=True)),
                ('retries', models.PositiveSmallIntegerField(default=0)),
                ('estimated_time_of_next_retry',
                 models.DateTimeField(blank=True, null=True)),
            ],
            options={
                'ordering': ('created_at',),
            },
        ),
        migrations.CreateModel(
            name='CommandLog',
            fields=[
                ('id', models.UUIDField(primary_key=True, serialize=False)),
                ('extra_data',
                 models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True)),
                ('slug', models.CharField(blank=True, db_index=True, max_length=255, null=True)),
                ('start', models.DateTimeField(editable=False)),
                ('stop', models.DateTimeField(blank=True, editable=False, null=True)),
                ('time', models.FloatField(blank=True, null=True)),
                ('name', models.CharField(db_index=True, editable=False, max_length=250)),
                ('input', models.TextField(editable=False)),
                ('is_executed_from_command_line',
                 models.BooleanField(default=False, editable=False)),
                ('output', models.TextField(blank=True, editable=False, null=True)),
                ('state', enumfields.fields.NumEnumField(db_index=True, default=1, enum=security.enums.CommandState)),
                ('error_message', models.TextField(blank=True, editable=False, null=True)),
            ],
            options={
                'ordering': ('-created_at',),
            },
        ),
        migrations.CreateModel(
            name='InputRequestLog',
            fields=[
                ('id', models.UUIDField(primary_key=True, serialize=False)),
                ('extra_data',
                 models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True)),
                ('slug', models.CharField(blank=True, db_index=True, max_length=255, null=True)),
                ('start', models.DateTimeField(editable=False)),
                ('stop', models.DateTimeField(blank=True, editable=False, null=True)),
                ('time', models.FloatField(blank=True, null=True)),
                ('host', models.CharField(db_index=True, max_length=255)),
                ('method', models.SlugField(max_length=7)),
                ('path', models.CharField(blank=True, db_index=True, max_length=2000)),
                ('queries',
                 models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True)),
                ('is_secure', models.BooleanField(default=False)),
                ('request_headers',
                 models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True)),
                ('request_body', models.TextField(null=True, blank=True)),
                ('response_code', models.PositiveSmallIntegerField(blank=True, null=True)),
                ('response_headers',
                 models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True)),
                ('response_body', models.TextField(blank=True, null=True)),
                ('state',
                 enumfields.fields.NumEnumField(default=0, enum=security.enums.RequestLogState)),
                ('error_message', models.TextField(blank=True, null=True)),
                ('user_id', models.TextField(blank=True, db_index=True, null=True)),
                ('ip', models.GenericIPAddressField(db_index=True)),
                ('view_slug',
                 models.CharField(blank=True, db_index=True, max_length=255, null=True)),
            ],
            options={
                'ordering': ('-created_at',),
            },
        ),
        migrations.CreateModel(
            name='OutputRequestLog',
            fields=[
                ('id', models.UUIDField(primary_key=True, serialize=False)),
                ('extra_data',
                 models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True)),
                ('slug', models.CharField(blank=True, db_index=True, max_length=255, null=True)),
                ('start', models.DateTimeField(editable=False)),
                ('stop', models.DateTimeField(blank=True, editable=False, null=True)),
                ('time', models.FloatField(blank=True, null=True)),
                ('host', models.CharField(db_index=True, max_length=255)),
                ('method', models.SlugField(max_length=7)),
                ('path', models.CharField(blank=True, db_index=True, max_length=2000)),
                ('queries',
                 models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True)),
                ('is_secure', models.BooleanField(default=False)),
                ('request_headers',
                 models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True)),
                ('request_body', models.TextField(null=True, blank=True)),
                ('response_code', models.PositiveSmallIntegerField(blank=True, null=True)),
                ('response_headers',
                 models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True)),
                ('response_body', models.TextField(blank=True, null=True)),
                ('state',
                 enumfields.fields.NumEnumField(default=0, enum=security.enums.RequestLogState)),
                ('error_message', models.TextField(blank=True, null=True)),
            ],
            options={
                'ordering': ('-created_at',),
            },
        ),
        migrations.CreateModel(
            name='OutputRequestLogGenericManyToManyRelation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True)),
                ('object_ct_id',
                 models.PositiveSmallIntegerField(db_index=True)),
                ('object_id', models.TextField(db_index=True)),
                ('output_request_log',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='_related_objects',
                                   related_query_name='related_objects', to='security_backends_sql.outputrequestlog')),
            ],
            options={
                'db_tablespace': '',
                'unique_together': {('output_request_log', 'object_ct_id', 'object_id')},
            },
        ),
        migrations.CreateModel(
            name='InputRequestLogGenericManyToManyRelation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True)),
                ('object_ct_id',
                 models.PositiveSmallIntegerField(db_index=True)),
                ('object_id', models.TextField(db_index=True)),
                ('input_request_log',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='_related_objects',
                                   related_query_name='related_objects', to='security_backends_sql.inputrequestlog')),
            ],
            options={
                'db_tablespace': '',
                'unique_together': {('input_request_log', 'object_ct_id', 'object_id')},
            },
        ),
        migrations.CreateModel(
            name='CommandLogGenericManyToManyRelation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True)),
                ('object_ct_id',
                 models.PositiveSmallIntegerField(db_index=True)),
                ('object_id', models.TextField(db_index=True)),
                ('command_log',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='_related_objects',
                                   related_query_name='related_objects', to='security_backends_sql.commandlog')),
            ],
            options={
                'db_tablespace': '',
                'unique_together': {('command_log', 'object_ct_id', 'object_id')},
            },
        ),
        migrations.CreateModel(
            name='CeleryTaskRunLogGenericManyToManyRelation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True)),
                ('object_ct_id',
                 models.PositiveSmallIntegerField(db_index=True)),
                ('object_id', models.TextField(db_index=True)),
                ('celery_task_run_log',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='_related_objects',
                                   related_query_name='related_objects', to='security_backends_sql.celerytaskrunlog')),
            ],
            options={
                'db_tablespace': '',
                'unique_together': {('celery_task_run_log', 'object_ct_id', 'object_id')},
            },
        ),
        migrations.CreateModel(
            name='CeleryTaskInvocationLogGenericManyToManyRelation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True)),
                ('object_ct_id',
                 models.PositiveSmallIntegerField(db_index=True)),
                ('object_id', models.TextField(db_index=True)),
                ('celery_task_invocation_log',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='_related_objects',
                                   related_query_name='related_objects',
                                   to='security_backends_sql.celerytaskinvocationlog')),
            ],
            options={
                'db_tablespace': '',
                'unique_together': {('celery_task_invocation_log', 'object_ct_id', 'object_id')},
            },
        ),
    ]
