from mypy.nodes import (
    AssertStmt,
    AssertTypeExpr,
    AssignmentExpr,
    AssignmentStmt,
    AwaitExpr,
    BackquoteExpr,
    Block,
    BreakStmt,
    BytesExpr,
    CallExpr,
    CastExpr,
    ClassDef,
    ComparisonExpr,
    ComplexExpr,
    ConditionalExpr,
    ContinueStmt,
    Decorator,
    DelStmt,
    DictExpr,
    DictionaryComprehension,
    EllipsisExpr,
    EnumCallExpr,
    ExecStmt,
    ExpressionStmt,
    FloatExpr,
    ForStmt,
    FuncDef,
    FuncItem,
    GeneratorExpr,
    GlobalDecl,
    IfStmt,
    Import,
    ImportAll,
    ImportFrom,
    IndexExpr,
    IntExpr,
    LambdaExpr,
    ListComprehension,
    ListExpr,
    MatchStmt,
    MemberExpr,
    MypyFile,
    NamedTupleExpr,
    NameExpr,
    NewTypeExpr,
    NonlocalDecl,
    OperatorAssignmentStmt,
    OpExpr,
    OverloadedFuncDef,
    ParamSpecExpr,
    PassStmt,
    PlaceholderNode,
    PrintStmt,
    PromoteExpr,
    RaiseStmt,
    ReturnStmt,
    RevealExpr,
    SetComprehension,
    SetExpr,
    SliceExpr,
    StarExpr,
    StrExpr,
    SuperExpr,
    TempNode,
    TryStmt,
    TupleExpr,
    TypeAlias,
    TypeAliasExpr,
    TypeApplication,
    TypedDictExpr,
    TypeVarExpr,
    TypeVarTupleExpr,
    UnaryExpr,
    UnicodeExpr,
    Var,
    WhileStmt,
    WithStmt,
    YieldExpr,
    YieldFromExpr,
)
from mypy.patterns import (
    AsPattern,
    ClassPattern,
    MappingPattern,
    OrPattern,
    SequencePattern,
    SingletonPattern,
    StarredPattern,
    ValuePattern,
)

# TODO: Dynamically generate this somehow instead of hardcoding it

MAPPINGS = {
    "visit_as_pattern": AsPattern,
    "visit_assert_stmt": AssertStmt,
    "visit_assert_type_expr": AssertTypeExpr,
    "visit_assignment_expr": AssignmentExpr,
    "visit_assignment_stmt": AssignmentStmt,
    "visit_await_expr": AwaitExpr,
    "visit_backquote_expr": BackquoteExpr,
    "visit_block": Block,
    "visit_break_stmt": BreakStmt,
    "visit_bytes_expr": BytesExpr,
    "visit_call_expr": CallExpr,
    "visit_cast_expr": CastExpr,
    "visit_class_def": ClassDef,
    "visit_class_pattern": ClassPattern,
    "visit_comparison_expr": ComparisonExpr,
    "visit_complex_expr": ComplexExpr,
    "visit_conditional_expr": ConditionalExpr,
    "visit_continue_stmt": ContinueStmt,
    "visit_decorator": Decorator,
    "visit_del_stmt": DelStmt,
    "visit_dict_expr": DictExpr,
    "visit_dictionary_comprehension": DictionaryComprehension,
    "visit_ellipsis": EllipsisExpr,
    "visit_enum_call_expr": EnumCallExpr,
    "visit_exec_stmt": ExecStmt,
    "visit_expression_stmt": ExpressionStmt,
    "visit_float_expr": FloatExpr,
    "visit_for_stmt": ForStmt,
    "visit_func_def": FuncDef,
    "visit_func": FuncItem,
    "visit_generator_expr": GeneratorExpr,
    "visit_global_decl": GlobalDecl,
    "visit_if_stmt": IfStmt,
    "visit_import_all": ImportAll,
    "visit_import_from": ImportFrom,
    "visit_import": Import,
    "visit_index_expr": IndexExpr,
    "visit_int_expr": IntExpr,
    "visit_lambda_expr": LambdaExpr,
    "visit_list_comprehension": ListComprehension,
    "visit_list_expr": ListExpr,
    "visit_mapping_pattern": MappingPattern,
    "visit_match_stmt": MatchStmt,
    "visit_member_expr": MemberExpr,
    "visit_mypy_file": MypyFile,
    "visit_namedtuple_expr": NamedTupleExpr,
    "visit_name_expr": NameExpr,
    "visit_newtype_expr": NewTypeExpr,
    "visit_nonlocal_decl": NonlocalDecl,
    "visit_operator_assignment_stmt": OperatorAssignmentStmt,
    "visit_op_expr": OpExpr,
    "visit_or_pattern": OrPattern,
    "visit_overloaded_func_def": OverloadedFuncDef,
    "visit_paramspec_expr": ParamSpecExpr,
    "visit_pass_stmt": PassStmt,
    "visit_placeholder_node": PlaceholderNode,
    "visit_print_stmt": PrintStmt,
    "visit__promote_expr": PromoteExpr,
    "visit_raise_stmt": RaiseStmt,
    "visit_return_stmt": ReturnStmt,
    "visit_reveal_expr": RevealExpr,
    "visit_sequence_pattern": SequencePattern,
    "visit_set_comprehension": SetComprehension,
    "visit_set_expr": SetExpr,
    "visit_singleton_pattern": SingletonPattern,
    "visit_slice_expr": SliceExpr,
    "visit_star_expr": StarExpr,
    "visit_starred_patten": StarredPattern,
    "visit_starred_pattern": StarredPattern,
    "visit_str_expr": StrExpr,
    "visit_super_expr": SuperExpr,
    "visit_temp_node": TempNode,
    "visit_try_stmt": TryStmt,
    "visit_tuple_expr": TupleExpr,
    "visit_type_alias_expr": TypeAliasExpr,
    "visit_type_alias": TypeAlias,
    "visit_type_application": TypeApplication,
    "visit_typeddict_expr": TypedDictExpr,
    "visit_type_var_expr": TypeVarExpr,
    "visit_type_var_tuple_expr": TypeVarTupleExpr,
    "visit_unary_expr": UnaryExpr,
    "visit_unicode_expr": UnicodeExpr,
    "visit_value_pattern": ValuePattern,
    "visit_var": Var,
    "visit_while_stmt": WhileStmt,
    "visit_with_stmt": WithStmt,
    "visit_yield_expr": YieldExpr,
    "visit_yield_from_expr": YieldFromExpr,
}
