import typing, abc
from TransformsAI.Animo.Data.Models import AgentData, CheckpointId, CheckpointData, LevelData
from TransformsAI.Animo.Data.Database import AnimoDatabase, ModificationType
from System import MulticastDelegate, IAsyncResult, AsyncCallback
from System.Reflection import MethodInfo
from System.Collections.Generic import IEnumerable_1, Dictionary_2

class AgentTable(Table_2[int, AgentData]):
    def __init__(self, database: AnimoDatabase) -> None: ...
    @property
    def Database(self) -> AnimoDatabase: ...
    def Delete(self, id: int) -> AgentData: ...
    def Get(self, id: typing.Optional[int]) -> AgentData: ...
    def ResetAgentCheckpoints(self, agentId: int) -> bool: ...
    def Validate(self, agentData: AgentData) -> None: ...


class CheckpointTable(Table_2[CheckpointId, CheckpointData]):
    def __init__(self, database: AnimoDatabase) -> None: ...
    @property
    def Database(self) -> AnimoDatabase: ...
    def Delete(self, checkpointId: CheckpointId) -> CheckpointData: ...
    def Update(self, cp: CheckpointData) -> CheckpointData: ...
    # Skipped Get due to it being static, abstract and generic.

    Get : Get_MethodGroup
    class Get_MethodGroup:
        @typing.overload
        def __call__(self, id: typing.Optional[CheckpointId]) -> CheckpointData:...
        @typing.overload
        def __call__(self, agentId: int, checkpointTimestamp: int) -> CheckpointData:...



class ITableItem_GenericClasses(abc.ABCMeta):
    Generic_ITableItem_GenericClasses_ITableItem_1_TKey = typing.TypeVar('Generic_ITableItem_GenericClasses_ITableItem_1_TKey')
    def __getitem__(self, types : typing.Type[Generic_ITableItem_GenericClasses_ITableItem_1_TKey]) -> typing.Type[ITableItem_1[Generic_ITableItem_GenericClasses_ITableItem_1_TKey]]: ...

class ITableItem(ITableItem_0, metaclass =ITableItem_GenericClasses): ...

class ITableItem_0(typing.Protocol):
    pass


ITableItem_1_TKey = typing.TypeVar('ITableItem_1_TKey', covariant=True)
class ITableItem_1(typing.Generic[ITableItem_1_TKey], ITableItem_0, typing.Protocol):
    @property
    def Id(self) -> ITableItem_1_TKey: ...


class LevelTable(Table_2[str, LevelData]):
    def __init__(self, database: AnimoDatabase) -> None: ...
    @property
    def Database(self) -> AnimoDatabase: ...
    def Validate(self, data: LevelData) -> None: ...


class ModificationSubscriber_GenericClasses(abc.ABCMeta):
    Generic_ModificationSubscriber_GenericClasses_ModificationSubscriber_1_T = typing.TypeVar('Generic_ModificationSubscriber_GenericClasses_ModificationSubscriber_1_T')
    def __getitem__(self, types : typing.Type[Generic_ModificationSubscriber_GenericClasses_ModificationSubscriber_1_T]) -> typing.Type[ModificationSubscriber_1[Generic_ModificationSubscriber_GenericClasses_ModificationSubscriber_1_T]]: ...

ModificationSubscriber : ModificationSubscriber_GenericClasses

ModificationSubscriber_1_T = typing.TypeVar('ModificationSubscriber_1_T', contravariant=True)
class ModificationSubscriber_1(typing.Generic[ModificationSubscriber_1_T], MulticastDelegate):
    def __init__(self, object: typing.Any, method: int) -> None: ...
    @property
    def Method(self) -> MethodInfo: ...
    @property
    def Target(self) -> typing.Any: ...
    def BeginInvoke(self, data: ModificationSubscriber_1_T, modificationType: ModificationType, callback: AsyncCallback, object: typing.Any) -> IAsyncResult: ...
    def EndInvoke(self, result: IAsyncResult) -> None: ...
    def Invoke(self, data: ModificationSubscriber_1_T, modificationType: ModificationType) -> None: ...


class Table_GenericClasses(abc.ABCMeta):
    Generic_Table_GenericClasses_Table_2_TKey = typing.TypeVar('Generic_Table_GenericClasses_Table_2_TKey')
    Generic_Table_GenericClasses_Table_2_TValue = typing.TypeVar('Generic_Table_GenericClasses_Table_2_TValue')
    def __getitem__(self, types : typing.Tuple[typing.Type[Generic_Table_GenericClasses_Table_2_TKey], typing.Type[Generic_Table_GenericClasses_Table_2_TValue]]) -> typing.Type[Table_2[Generic_Table_GenericClasses_Table_2_TKey, Generic_Table_GenericClasses_Table_2_TValue]]: ...

Table : Table_GenericClasses

Table_2_TKey = typing.TypeVar('Table_2_TKey')
Table_2_TValue = typing.TypeVar('Table_2_TValue')
class Table_2(typing.Generic[Table_2_TKey, Table_2_TValue], IEnumerable_1[Table_2_TValue], abc.ABC):
    @property
    def Database(self) -> AnimoDatabase: ...
    def Clear(self) -> None: ...
    def Delete(self, id: Table_2_TKey) -> Table_2_TValue: ...
    def Get(self, id: Table_2_TKey) -> Table_2_TValue: ...
    def GetEnumerator(self) -> Dictionary_2.ValueCollection_2.Enumerator_2[Table_2_TKey, Table_2_TValue]: ...
    def Update(self, newItem: Table_2_TValue) -> Table_2_TValue: ...
    def Validate(self, data: Table_2_TValue) -> None: ...

