import typing, abc
from System import IDisposable, IAsyncResult, Action, Action_1, AggregateException, Func_2, Func_3, Action_2, TimeSpan, Exception, Func_1, Array_1, IAsyncDisposable, OperationCanceledException, AsyncCallback, Func_4, Func_5, Func_6, EventArgs, IEquatable_1
from System.Threading import CancellationToken
from System.Runtime.CompilerServices import ConfiguredTaskAwaitable, TaskAwaiter, YieldAwaitable, ConfiguredTaskAwaitable_1, TaskAwaiter_1, ConfiguredCancelableAsyncEnumerable_1, ConfiguredAsyncDisposable, ConfiguredValueTaskAwaitable, ValueTaskAwaiter, ConfiguredValueTaskAwaitable_1, ValueTaskAwaiter_1
from System.Collections.Generic import IEnumerable_1, IAsyncEnumerable_1
from System.Collections import IDictionary
from System.Reflection import MethodBase
from System.Threading.Tasks.Sources import IValueTaskSource, IValueTaskSource_1

class ConcurrentExclusiveSchedulerPair:
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, taskScheduler: TaskScheduler) -> None: ...
    @typing.overload
    def __init__(self, taskScheduler: TaskScheduler, maxConcurrencyLevel: int) -> None: ...
    @typing.overload
    def __init__(self, taskScheduler: TaskScheduler, maxConcurrencyLevel: int, maxItemsPerTask: int) -> None: ...
    @property
    def Completion(self) -> Task: ...
    @property
    def ConcurrentScheduler(self) -> TaskScheduler: ...
    @property
    def ExclusiveScheduler(self) -> TaskScheduler: ...
    def Complete(self) -> None: ...


class Task_GenericClasses(abc.ABCMeta):
    Generic_Task_GenericClasses_Task_1_TResult = typing.TypeVar('Generic_Task_GenericClasses_Task_1_TResult')
    def __getitem__(self, types : typing.Type[Generic_Task_GenericClasses_Task_1_TResult]) -> typing.Type[Task_1[Generic_Task_GenericClasses_Task_1_TResult]]: ...

class Task(Task_0, metaclass =Task_GenericClasses): ...

class Task_0(IDisposable, IAsyncResult):
    @typing.overload
    def __init__(self, action: Action) -> None: ...
    @typing.overload
    def __init__(self, action: Action, cancellationToken: CancellationToken) -> None: ...
    @typing.overload
    def __init__(self, action: Action, cancellationToken: CancellationToken, creationOptions: TaskCreationOptions) -> None: ...
    @typing.overload
    def __init__(self, action: Action, creationOptions: TaskCreationOptions) -> None: ...
    @typing.overload
    def __init__(self, action: Action_1[typing.Any], state: typing.Any) -> None: ...
    @typing.overload
    def __init__(self, action: Action_1[typing.Any], state: typing.Any, cancellationToken: CancellationToken) -> None: ...
    @typing.overload
    def __init__(self, action: Action_1[typing.Any], state: typing.Any, cancellationToken: CancellationToken, creationOptions: TaskCreationOptions) -> None: ...
    @typing.overload
    def __init__(self, action: Action_1[typing.Any], state: typing.Any, creationOptions: TaskCreationOptions) -> None: ...
    @property
    def AsyncState(self) -> typing.Any: ...
    @classmethod
    @property
    def CompletedTask(cls) -> Task: ...
    @property
    def CreationOptions(self) -> TaskCreationOptions: ...
    @classmethod
    @property
    def CurrentId(cls) -> typing.Optional[int]: ...
    @property
    def Exception(self) -> AggregateException: ...
    @classmethod
    @property
    def Factory(cls) -> TaskFactory: ...
    @property
    def Id(self) -> int: ...
    @property
    def IsCanceled(self) -> bool: ...
    @property
    def IsCompleted(self) -> bool: ...
    @property
    def IsCompletedSuccessfully(self) -> bool: ...
    @property
    def IsFaulted(self) -> bool: ...
    @property
    def Status(self) -> TaskStatus: ...
    def ConfigureAwait(self, continueOnCapturedContext: bool) -> ConfiguredTaskAwaitable: ...
    def Dispose(self) -> None: ...
    def GetAwaiter(self) -> TaskAwaiter: ...
    @staticmethod
    def Yield() -> YieldAwaitable: ...
    # Skipped ContinueWith due to it being static, abstract and generic.

    ContinueWith : ContinueWith_MethodGroup
    class ContinueWith_MethodGroup:
        def __getitem__(self, t:typing.Type[ContinueWith_1_T1]) -> ContinueWith_1[ContinueWith_1_T1]: ...

        ContinueWith_1_T1 = typing.TypeVar('ContinueWith_1_T1')
        class ContinueWith_1(typing.Generic[ContinueWith_1_T1]):
            ContinueWith_1_TResult = Task_0.ContinueWith_MethodGroup.ContinueWith_1_T1
            @typing.overload
            def __call__(self, continuationFunction: Func_2[Task, ContinueWith_1_TResult]) -> Task_1[ContinueWith_1_TResult]:...
            @typing.overload
            def __call__(self, continuationFunction: Func_2[Task, ContinueWith_1_TResult], continuationOptions: TaskContinuationOptions) -> Task_1[ContinueWith_1_TResult]:...
            @typing.overload
            def __call__(self, continuationFunction: Func_2[Task, ContinueWith_1_TResult], cancellationToken: CancellationToken) -> Task_1[ContinueWith_1_TResult]:...
            @typing.overload
            def __call__(self, continuationFunction: Func_2[Task, ContinueWith_1_TResult], scheduler: TaskScheduler) -> Task_1[ContinueWith_1_TResult]:...
            @typing.overload
            def __call__(self, continuationFunction: Func_3[Task, typing.Any, ContinueWith_1_TResult], state: typing.Any) -> Task_1[ContinueWith_1_TResult]:...
            @typing.overload
            def __call__(self, continuationFunction: Func_3[Task, typing.Any, ContinueWith_1_TResult], state: typing.Any, continuationOptions: TaskContinuationOptions) -> Task_1[ContinueWith_1_TResult]:...
            @typing.overload
            def __call__(self, continuationFunction: Func_3[Task, typing.Any, ContinueWith_1_TResult], state: typing.Any, cancellationToken: CancellationToken) -> Task_1[ContinueWith_1_TResult]:...
            @typing.overload
            def __call__(self, continuationFunction: Func_3[Task, typing.Any, ContinueWith_1_TResult], state: typing.Any, scheduler: TaskScheduler) -> Task_1[ContinueWith_1_TResult]:...
            @typing.overload
            def __call__(self, continuationFunction: Func_2[Task, ContinueWith_1_TResult], cancellationToken: CancellationToken, continuationOptions: TaskContinuationOptions, scheduler: TaskScheduler) -> Task_1[ContinueWith_1_TResult]:...
            @typing.overload
            def __call__(self, continuationFunction: Func_3[Task, typing.Any, ContinueWith_1_TResult], state: typing.Any, cancellationToken: CancellationToken, continuationOptions: TaskContinuationOptions, scheduler: TaskScheduler) -> Task_1[ContinueWith_1_TResult]:...

        @typing.overload
        def __call__(self, continuationAction: Action_1[Task]) -> Task:...
        @typing.overload
        def __call__(self, continuationAction: Action_1[Task], continuationOptions: TaskContinuationOptions) -> Task:...
        @typing.overload
        def __call__(self, continuationAction: Action_1[Task], cancellationToken: CancellationToken) -> Task:...
        @typing.overload
        def __call__(self, continuationAction: Action_1[Task], scheduler: TaskScheduler) -> Task:...
        @typing.overload
        def __call__(self, continuationAction: Action_2[Task, typing.Any], state: typing.Any) -> Task:...
        @typing.overload
        def __call__(self, continuationAction: Action_2[Task, typing.Any], state: typing.Any, continuationOptions: TaskContinuationOptions) -> Task:...
        @typing.overload
        def __call__(self, continuationAction: Action_2[Task, typing.Any], state: typing.Any, cancellationToken: CancellationToken) -> Task:...
        @typing.overload
        def __call__(self, continuationAction: Action_2[Task, typing.Any], state: typing.Any, scheduler: TaskScheduler) -> Task:...
        @typing.overload
        def __call__(self, continuationAction: Action_1[Task], cancellationToken: CancellationToken, continuationOptions: TaskContinuationOptions, scheduler: TaskScheduler) -> Task:...
        @typing.overload
        def __call__(self, continuationAction: Action_2[Task, typing.Any], state: typing.Any, cancellationToken: CancellationToken, continuationOptions: TaskContinuationOptions, scheduler: TaskScheduler) -> Task:...

    # Skipped Delay due to it being static, abstract and generic.

    Delay : Delay_MethodGroup
    class Delay_MethodGroup:
        @typing.overload
        def __call__(self, millisecondsDelay: int) -> Task:...
        @typing.overload
        def __call__(self, delay: TimeSpan) -> Task:...
        @typing.overload
        def __call__(self, millisecondsDelay: int, cancellationToken: CancellationToken) -> Task:...
        @typing.overload
        def __call__(self, delay: TimeSpan, cancellationToken: CancellationToken) -> Task:...

    # Skipped FromCanceled due to it being static, abstract and generic.

    FromCanceled : FromCanceled_MethodGroup
    class FromCanceled_MethodGroup:
        def __getitem__(self, t:typing.Type[FromCanceled_1_T1]) -> FromCanceled_1[FromCanceled_1_T1]: ...

        FromCanceled_1_T1 = typing.TypeVar('FromCanceled_1_T1')
        class FromCanceled_1(typing.Generic[FromCanceled_1_T1]):
            FromCanceled_1_TResult = Task_0.FromCanceled_MethodGroup.FromCanceled_1_T1
            def __call__(self, cancellationToken: CancellationToken) -> Task_1[FromCanceled_1_TResult]:...

        def __call__(self, cancellationToken: CancellationToken) -> Task:...

    # Skipped FromException due to it being static, abstract and generic.

    FromException : FromException_MethodGroup
    class FromException_MethodGroup:
        def __getitem__(self, t:typing.Type[FromException_1_T1]) -> FromException_1[FromException_1_T1]: ...

        FromException_1_T1 = typing.TypeVar('FromException_1_T1')
        class FromException_1(typing.Generic[FromException_1_T1]):
            FromException_1_TResult = Task_0.FromException_MethodGroup.FromException_1_T1
            def __call__(self, exception: Exception) -> Task_1[FromException_1_TResult]:...

        def __call__(self, exception: Exception) -> Task:...

    # Skipped FromResult due to it being static, abstract and generic.

    FromResult : FromResult_MethodGroup
    class FromResult_MethodGroup:
        def __getitem__(self, t:typing.Type[FromResult_1_T1]) -> FromResult_1[FromResult_1_T1]: ...

        FromResult_1_T1 = typing.TypeVar('FromResult_1_T1')
        class FromResult_1(typing.Generic[FromResult_1_T1]):
            FromResult_1_TResult = Task_0.FromResult_MethodGroup.FromResult_1_T1
            def __call__(self, result: FromResult_1_TResult) -> Task_1[FromResult_1_TResult]:...


    # Skipped Run due to it being static, abstract and generic.

    Run : Run_MethodGroup
    class Run_MethodGroup:
        def __getitem__(self, t:typing.Type[Run_1_T1]) -> Run_1[Run_1_T1]: ...

        Run_1_T1 = typing.TypeVar('Run_1_T1')
        class Run_1(typing.Generic[Run_1_T1]):
            Run_1_TResult = Task_0.Run_MethodGroup.Run_1_T1
            @typing.overload
            def __call__(self, function: Func_1[Task_1[Run_1_TResult]]) -> Task_1[Run_1_TResult]:...
            @typing.overload
            def __call__(self, function: Func_1[Run_1_TResult]) -> Task_1[Run_1_TResult]:...
            @typing.overload
            def __call__(self, function: Func_1[Task_1[Run_1_TResult]], cancellationToken: CancellationToken) -> Task_1[Run_1_TResult]:...
            @typing.overload
            def __call__(self, function: Func_1[Run_1_TResult], cancellationToken: CancellationToken) -> Task_1[Run_1_TResult]:...

        @typing.overload
        def __call__(self, function: Func_1[Task]) -> Task:...
        @typing.overload
        def __call__(self, action: Action) -> Task:...
        @typing.overload
        def __call__(self, function: Func_1[Task], cancellationToken: CancellationToken) -> Task:...
        @typing.overload
        def __call__(self, action: Action, cancellationToken: CancellationToken) -> Task:...

    # Skipped RunSynchronously due to it being static, abstract and generic.

    RunSynchronously : RunSynchronously_MethodGroup
    class RunSynchronously_MethodGroup:
        @typing.overload
        def __call__(self) -> None:...
        @typing.overload
        def __call__(self, scheduler: TaskScheduler) -> None:...

    # Skipped Start due to it being static, abstract and generic.

    Start : Start_MethodGroup
    class Start_MethodGroup:
        @typing.overload
        def __call__(self) -> None:...
        @typing.overload
        def __call__(self, scheduler: TaskScheduler) -> None:...

    # Skipped Wait due to it being static, abstract and generic.

    Wait : Wait_MethodGroup
    class Wait_MethodGroup:
        @typing.overload
        def __call__(self) -> None:...
        @typing.overload
        def __call__(self, millisecondsTimeout: int) -> bool:...
        @typing.overload
        def __call__(self, timeout: TimeSpan) -> bool:...
        @typing.overload
        def __call__(self, cancellationToken: CancellationToken) -> None:...
        @typing.overload
        def __call__(self, millisecondsTimeout: int, cancellationToken: CancellationToken) -> bool:...

    # Skipped WaitAll due to it being static, abstract and generic.

    WaitAll : WaitAll_MethodGroup
    class WaitAll_MethodGroup:
        @typing.overload
        def __call__(self, tasks: Array_1[Task]) -> None:...
        @typing.overload
        def __call__(self, tasks: Array_1[Task], millisecondsTimeout: int) -> bool:...
        @typing.overload
        def __call__(self, tasks: Array_1[Task], timeout: TimeSpan) -> bool:...
        @typing.overload
        def __call__(self, tasks: Array_1[Task], cancellationToken: CancellationToken) -> None:...
        @typing.overload
        def __call__(self, tasks: Array_1[Task], millisecondsTimeout: int, cancellationToken: CancellationToken) -> bool:...

    # Skipped WaitAny due to it being static, abstract and generic.

    WaitAny : WaitAny_MethodGroup
    class WaitAny_MethodGroup:
        @typing.overload
        def __call__(self, tasks: Array_1[Task]) -> int:...
        @typing.overload
        def __call__(self, tasks: Array_1[Task], millisecondsTimeout: int) -> int:...
        @typing.overload
        def __call__(self, tasks: Array_1[Task], timeout: TimeSpan) -> int:...
        @typing.overload
        def __call__(self, tasks: Array_1[Task], cancellationToken: CancellationToken) -> int:...
        @typing.overload
        def __call__(self, tasks: Array_1[Task], millisecondsTimeout: int, cancellationToken: CancellationToken) -> int:...

    # Skipped WaitAsync due to it being static, abstract and generic.

    WaitAsync : WaitAsync_MethodGroup
    class WaitAsync_MethodGroup:
        @typing.overload
        def __call__(self, timeout: TimeSpan) -> Task:...
        @typing.overload
        def __call__(self, cancellationToken: CancellationToken) -> Task:...
        @typing.overload
        def __call__(self, timeout: TimeSpan, cancellationToken: CancellationToken) -> Task:...

    # Skipped WhenAll due to it being static, abstract and generic.

    WhenAll : WhenAll_MethodGroup
    class WhenAll_MethodGroup:
        def __getitem__(self, t:typing.Type[WhenAll_1_T1]) -> WhenAll_1[WhenAll_1_T1]: ...

        WhenAll_1_T1 = typing.TypeVar('WhenAll_1_T1')
        class WhenAll_1(typing.Generic[WhenAll_1_T1]):
            WhenAll_1_TResult = Task_0.WhenAll_MethodGroup.WhenAll_1_T1
            @typing.overload
            def __call__(self, tasks: Array_1[Task_1[WhenAll_1_TResult]]) -> Task_1[Array_1[WhenAll_1_TResult]]:...
            @typing.overload
            def __call__(self, tasks: IEnumerable_1[Task_1[WhenAll_1_TResult]]) -> Task_1[Array_1[WhenAll_1_TResult]]:...

        @typing.overload
        def __call__(self, tasks: Array_1[Task]) -> Task:...
        @typing.overload
        def __call__(self, tasks: IEnumerable_1[Task]) -> Task:...

    # Skipped WhenAny due to it being static, abstract and generic.

    WhenAny : WhenAny_MethodGroup
    class WhenAny_MethodGroup:
        def __getitem__(self, t:typing.Type[WhenAny_1_T1]) -> WhenAny_1[WhenAny_1_T1]: ...

        WhenAny_1_T1 = typing.TypeVar('WhenAny_1_T1')
        class WhenAny_1(typing.Generic[WhenAny_1_T1]):
            WhenAny_1_TResult = Task_0.WhenAny_MethodGroup.WhenAny_1_T1
            @typing.overload
            def __call__(self, tasks: Array_1[Task_1[WhenAny_1_TResult]]) -> Task_1[Task_1[WhenAny_1_TResult]]:...
            @typing.overload
            def __call__(self, tasks: IEnumerable_1[Task_1[WhenAny_1_TResult]]) -> Task_1[Task_1[WhenAny_1_TResult]]:...
            @typing.overload
            def __call__(self, task1: Task_1[WhenAny_1_TResult], task2: Task_1[WhenAny_1_TResult]) -> Task_1[Task_1[WhenAny_1_TResult]]:...

        @typing.overload
        def __call__(self, tasks: Array_1[Task]) -> Task_1[Task]:...
        @typing.overload
        def __call__(self, tasks: IEnumerable_1[Task]) -> Task_1[Task]:...
        @typing.overload
        def __call__(self, task1: Task, task2: Task) -> Task_1[Task]:...



Task_1_TResult = typing.TypeVar('Task_1_TResult')
class Task_1(typing.Generic[Task_1_TResult], Task_0):
    @typing.overload
    def __init__(self, function: Func_1[Task_1_TResult]) -> None: ...
    @typing.overload
    def __init__(self, function: Func_1[Task_1_TResult], cancellationToken: CancellationToken) -> None: ...
    @typing.overload
    def __init__(self, function: Func_1[Task_1_TResult], cancellationToken: CancellationToken, creationOptions: TaskCreationOptions) -> None: ...
    @typing.overload
    def __init__(self, function: Func_1[Task_1_TResult], creationOptions: TaskCreationOptions) -> None: ...
    @typing.overload
    def __init__(self, function: Func_2[typing.Any, Task_1_TResult], state: typing.Any) -> None: ...
    @typing.overload
    def __init__(self, function: Func_2[typing.Any, Task_1_TResult], state: typing.Any, cancellationToken: CancellationToken) -> None: ...
    @typing.overload
    def __init__(self, function: Func_2[typing.Any, Task_1_TResult], state: typing.Any, cancellationToken: CancellationToken, creationOptions: TaskCreationOptions) -> None: ...
    @typing.overload
    def __init__(self, function: Func_2[typing.Any, Task_1_TResult], state: typing.Any, creationOptions: TaskCreationOptions) -> None: ...
    @property
    def AsyncState(self) -> typing.Any: ...
    @property
    def CreationOptions(self) -> TaskCreationOptions: ...
    @property
    def Exception(self) -> AggregateException: ...
    @classmethod
    @property
    def Factory(cls) -> TaskFactory_1[Task_1_TResult]: ...
    @property
    def Id(self) -> int: ...
    @property
    def IsCanceled(self) -> bool: ...
    @property
    def IsCompleted(self) -> bool: ...
    @property
    def IsCompletedSuccessfully(self) -> bool: ...
    @property
    def IsFaulted(self) -> bool: ...
    @property
    def Result(self) -> Task_1_TResult: ...
    @property
    def Status(self) -> TaskStatus: ...
    def ConfigureAwait(self, continueOnCapturedContext: bool) -> ConfiguredTaskAwaitable_1[Task_1_TResult]: ...
    def GetAwaiter(self) -> TaskAwaiter_1[Task_1_TResult]: ...
    # Skipped ContinueWith due to it being static, abstract and generic.

    ContinueWith : ContinueWith_MethodGroup[Task_1_TResult]
    ContinueWith_MethodGroup_Task_1_TResult = typing.TypeVar('ContinueWith_MethodGroup_Task_1_TResult')
    class ContinueWith_MethodGroup(typing.Generic[ContinueWith_MethodGroup_Task_1_TResult]):
        ContinueWith_MethodGroup_Task_1_TResult = Task_1.ContinueWith_MethodGroup_Task_1_TResult
        def __getitem__(self, t:typing.Type[ContinueWith_1_T1]) -> ContinueWith_1[ContinueWith_MethodGroup_Task_1_TResult, ContinueWith_1_T1]: ...

        ContinueWith_1_Task_1_TResult = typing.TypeVar('ContinueWith_1_Task_1_TResult')
        ContinueWith_1_T1 = typing.TypeVar('ContinueWith_1_T1')
        class ContinueWith_1(typing.Generic[ContinueWith_1_Task_1_TResult, ContinueWith_1_T1]):
            ContinueWith_1_Task_1_TResult = Task_1.ContinueWith_MethodGroup.ContinueWith_1_Task_1_TResult
            ContinueWith_1_TNewResult = Task_1.ContinueWith_MethodGroup.ContinueWith_1_T1
            @typing.overload
            def __call__(self, continuationFunction: Func_2[Task_1[ContinueWith_1_Task_1_TResult], ContinueWith_1_TNewResult]) -> Task_1[ContinueWith_1_TNewResult]:...
            @typing.overload
            def __call__(self, continuationFunction: Func_2[Task_1[ContinueWith_1_Task_1_TResult], ContinueWith_1_TNewResult], continuationOptions: TaskContinuationOptions) -> Task_1[ContinueWith_1_TNewResult]:...
            @typing.overload
            def __call__(self, continuationFunction: Func_2[Task_1[ContinueWith_1_Task_1_TResult], ContinueWith_1_TNewResult], cancellationToken: CancellationToken) -> Task_1[ContinueWith_1_TNewResult]:...
            @typing.overload
            def __call__(self, continuationFunction: Func_2[Task_1[ContinueWith_1_Task_1_TResult], ContinueWith_1_TNewResult], scheduler: TaskScheduler) -> Task_1[ContinueWith_1_TNewResult]:...
            @typing.overload
            def __call__(self, continuationFunction: Func_3[Task_1[ContinueWith_1_Task_1_TResult], typing.Any, ContinueWith_1_TNewResult], state: typing.Any) -> Task_1[ContinueWith_1_TNewResult]:...
            @typing.overload
            def __call__(self, continuationFunction: Func_3[Task_1[ContinueWith_1_Task_1_TResult], typing.Any, ContinueWith_1_TNewResult], state: typing.Any, continuationOptions: TaskContinuationOptions) -> Task_1[ContinueWith_1_TNewResult]:...
            @typing.overload
            def __call__(self, continuationFunction: Func_3[Task_1[ContinueWith_1_Task_1_TResult], typing.Any, ContinueWith_1_TNewResult], state: typing.Any, cancellationToken: CancellationToken) -> Task_1[ContinueWith_1_TNewResult]:...
            @typing.overload
            def __call__(self, continuationFunction: Func_3[Task_1[ContinueWith_1_Task_1_TResult], typing.Any, ContinueWith_1_TNewResult], state: typing.Any, scheduler: TaskScheduler) -> Task_1[ContinueWith_1_TNewResult]:...
            @typing.overload
            def __call__(self, continuationFunction: Func_2[Task_1[ContinueWith_1_Task_1_TResult], ContinueWith_1_TNewResult], cancellationToken: CancellationToken, continuationOptions: TaskContinuationOptions, scheduler: TaskScheduler) -> Task_1[ContinueWith_1_TNewResult]:...
            @typing.overload
            def __call__(self, continuationFunction: Func_3[Task_1[ContinueWith_1_Task_1_TResult], typing.Any, ContinueWith_1_TNewResult], state: typing.Any, cancellationToken: CancellationToken, continuationOptions: TaskContinuationOptions, scheduler: TaskScheduler) -> Task_1[ContinueWith_1_TNewResult]:...

        @typing.overload
        def __call__(self, continuationAction: Action_1[Task_1[ContinueWith_MethodGroup_Task_1_TResult]]) -> Task:...
        @typing.overload
        def __call__(self, continuationAction: Action_1[Task_1[ContinueWith_MethodGroup_Task_1_TResult]], continuationOptions: TaskContinuationOptions) -> Task:...
        @typing.overload
        def __call__(self, continuationAction: Action_1[Task_1[ContinueWith_MethodGroup_Task_1_TResult]], cancellationToken: CancellationToken) -> Task:...
        @typing.overload
        def __call__(self, continuationAction: Action_1[Task_1[ContinueWith_MethodGroup_Task_1_TResult]], scheduler: TaskScheduler) -> Task:...
        @typing.overload
        def __call__(self, continuationAction: Action_2[Task_1[ContinueWith_MethodGroup_Task_1_TResult], typing.Any], state: typing.Any) -> Task:...
        @typing.overload
        def __call__(self, continuationAction: Action_2[Task_1[ContinueWith_MethodGroup_Task_1_TResult], typing.Any], state: typing.Any, continuationOptions: TaskContinuationOptions) -> Task:...
        @typing.overload
        def __call__(self, continuationAction: Action_2[Task_1[ContinueWith_MethodGroup_Task_1_TResult], typing.Any], state: typing.Any, cancellationToken: CancellationToken) -> Task:...
        @typing.overload
        def __call__(self, continuationAction: Action_2[Task_1[ContinueWith_MethodGroup_Task_1_TResult], typing.Any], state: typing.Any, scheduler: TaskScheduler) -> Task:...
        @typing.overload
        def __call__(self, continuationAction: Action_1[Task_1[ContinueWith_MethodGroup_Task_1_TResult]], cancellationToken: CancellationToken, continuationOptions: TaskContinuationOptions, scheduler: TaskScheduler) -> Task:...
        @typing.overload
        def __call__(self, continuationAction: Action_2[Task_1[ContinueWith_MethodGroup_Task_1_TResult], typing.Any], state: typing.Any, cancellationToken: CancellationToken, continuationOptions: TaskContinuationOptions, scheduler: TaskScheduler) -> Task:...

    # Skipped WaitAsync due to it being static, abstract and generic.

    WaitAsync : WaitAsync_MethodGroup[Task_1_TResult]
    WaitAsync_MethodGroup_Task_1_TResult = typing.TypeVar('WaitAsync_MethodGroup_Task_1_TResult')
    class WaitAsync_MethodGroup(typing.Generic[WaitAsync_MethodGroup_Task_1_TResult]):
        WaitAsync_MethodGroup_Task_1_TResult = Task_1.WaitAsync_MethodGroup_Task_1_TResult
        @typing.overload
        def __call__(self, timeout: TimeSpan) -> Task_1[WaitAsync_MethodGroup_Task_1_TResult]:...
        @typing.overload
        def __call__(self, cancellationToken: CancellationToken) -> Task_1[WaitAsync_MethodGroup_Task_1_TResult]:...
        @typing.overload
        def __call__(self, timeout: TimeSpan, cancellationToken: CancellationToken) -> Task_1[WaitAsync_MethodGroup_Task_1_TResult]:...



class TaskAsyncEnumerableExtensions(abc.ABC):
    # Skipped ConfigureAwait due to it being static, abstract and generic.

    ConfigureAwait : ConfigureAwait_MethodGroup
    class ConfigureAwait_MethodGroup:
        def __getitem__(self, t:typing.Type[ConfigureAwait_1_T1]) -> ConfigureAwait_1[ConfigureAwait_1_T1]: ...

        ConfigureAwait_1_T1 = typing.TypeVar('ConfigureAwait_1_T1')
        class ConfigureAwait_1(typing.Generic[ConfigureAwait_1_T1]):
            ConfigureAwait_1_T = TaskAsyncEnumerableExtensions.ConfigureAwait_MethodGroup.ConfigureAwait_1_T1
            def __call__(self, source: IAsyncEnumerable_1[ConfigureAwait_1_T], continueOnCapturedContext: bool) -> ConfiguredCancelableAsyncEnumerable_1[ConfigureAwait_1_T]:...

        def __call__(self, source: IAsyncDisposable, continueOnCapturedContext: bool) -> ConfiguredAsyncDisposable:...

    # Skipped WithCancellation due to it being static, abstract and generic.

    WithCancellation : WithCancellation_MethodGroup
    class WithCancellation_MethodGroup:
        def __getitem__(self, t:typing.Type[WithCancellation_1_T1]) -> WithCancellation_1[WithCancellation_1_T1]: ...

        WithCancellation_1_T1 = typing.TypeVar('WithCancellation_1_T1')
        class WithCancellation_1(typing.Generic[WithCancellation_1_T1]):
            WithCancellation_1_T = TaskAsyncEnumerableExtensions.WithCancellation_MethodGroup.WithCancellation_1_T1
            def __call__(self, source: IAsyncEnumerable_1[WithCancellation_1_T], cancellationToken: CancellationToken) -> ConfiguredCancelableAsyncEnumerable_1[WithCancellation_1_T]:...




class TaskCanceledException(OperationCanceledException):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, message: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, innerException: Exception) -> None: ...
    @typing.overload
    def __init__(self, message: str, innerException: Exception, token: CancellationToken) -> None: ...
    @typing.overload
    def __init__(self, task: Task) -> None: ...
    @property
    def CancellationToken(self) -> CancellationToken: ...
    @property
    def Data(self) -> IDictionary: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def Message(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...
    @property
    def Task(self) -> Task: ...


class TaskCompletionSource_GenericClasses(abc.ABCMeta):
    Generic_TaskCompletionSource_GenericClasses_TaskCompletionSource_1_TResult = typing.TypeVar('Generic_TaskCompletionSource_GenericClasses_TaskCompletionSource_1_TResult')
    def __getitem__(self, types : typing.Type[Generic_TaskCompletionSource_GenericClasses_TaskCompletionSource_1_TResult]) -> typing.Type[TaskCompletionSource_1[Generic_TaskCompletionSource_GenericClasses_TaskCompletionSource_1_TResult]]: ...

class TaskCompletionSource(TaskCompletionSource_0, metaclass =TaskCompletionSource_GenericClasses): ...

class TaskCompletionSource_0:
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, creationOptions: TaskCreationOptions) -> None: ...
    @typing.overload
    def __init__(self, state: typing.Any) -> None: ...
    @typing.overload
    def __init__(self, state: typing.Any, creationOptions: TaskCreationOptions) -> None: ...
    @property
    def Task(self) -> Task: ...
    def SetResult(self) -> None: ...
    def TrySetResult(self) -> bool: ...
    # Skipped SetCanceled due to it being static, abstract and generic.

    SetCanceled : SetCanceled_MethodGroup
    class SetCanceled_MethodGroup:
        @typing.overload
        def __call__(self) -> None:...
        @typing.overload
        def __call__(self, cancellationToken: CancellationToken) -> None:...

    # Skipped SetException due to it being static, abstract and generic.

    SetException : SetException_MethodGroup
    class SetException_MethodGroup:
        @typing.overload
        def __call__(self, exceptions: IEnumerable_1[Exception]) -> None:...
        @typing.overload
        def __call__(self, exception: Exception) -> None:...

    # Skipped TrySetCanceled due to it being static, abstract and generic.

    TrySetCanceled : TrySetCanceled_MethodGroup
    class TrySetCanceled_MethodGroup:
        @typing.overload
        def __call__(self) -> bool:...
        @typing.overload
        def __call__(self, cancellationToken: CancellationToken) -> bool:...

    # Skipped TrySetException due to it being static, abstract and generic.

    TrySetException : TrySetException_MethodGroup
    class TrySetException_MethodGroup:
        @typing.overload
        def __call__(self, exceptions: IEnumerable_1[Exception]) -> bool:...
        @typing.overload
        def __call__(self, exception: Exception) -> bool:...



TaskCompletionSource_1_TResult = typing.TypeVar('TaskCompletionSource_1_TResult')
class TaskCompletionSource_1(typing.Generic[TaskCompletionSource_1_TResult]):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, creationOptions: TaskCreationOptions) -> None: ...
    @typing.overload
    def __init__(self, state: typing.Any) -> None: ...
    @typing.overload
    def __init__(self, state: typing.Any, creationOptions: TaskCreationOptions) -> None: ...
    @property
    def Task(self) -> Task_1[TaskCompletionSource_1_TResult]: ...
    def SetResult(self, result: TaskCompletionSource_1_TResult) -> None: ...
    def TrySetResult(self, result: TaskCompletionSource_1_TResult) -> bool: ...
    # Skipped SetCanceled due to it being static, abstract and generic.

    SetCanceled : SetCanceled_MethodGroup[TaskCompletionSource_1_TResult]
    SetCanceled_MethodGroup_TaskCompletionSource_1_TResult = typing.TypeVar('SetCanceled_MethodGroup_TaskCompletionSource_1_TResult')
    class SetCanceled_MethodGroup(typing.Generic[SetCanceled_MethodGroup_TaskCompletionSource_1_TResult]):
        SetCanceled_MethodGroup_TaskCompletionSource_1_TResult = TaskCompletionSource_1.SetCanceled_MethodGroup_TaskCompletionSource_1_TResult
        @typing.overload
        def __call__(self) -> None:...
        @typing.overload
        def __call__(self, cancellationToken: CancellationToken) -> None:...

    # Skipped SetException due to it being static, abstract and generic.

    SetException : SetException_MethodGroup[TaskCompletionSource_1_TResult]
    SetException_MethodGroup_TaskCompletionSource_1_TResult = typing.TypeVar('SetException_MethodGroup_TaskCompletionSource_1_TResult')
    class SetException_MethodGroup(typing.Generic[SetException_MethodGroup_TaskCompletionSource_1_TResult]):
        SetException_MethodGroup_TaskCompletionSource_1_TResult = TaskCompletionSource_1.SetException_MethodGroup_TaskCompletionSource_1_TResult
        @typing.overload
        def __call__(self, exceptions: IEnumerable_1[Exception]) -> None:...
        @typing.overload
        def __call__(self, exception: Exception) -> None:...

    # Skipped TrySetCanceled due to it being static, abstract and generic.

    TrySetCanceled : TrySetCanceled_MethodGroup[TaskCompletionSource_1_TResult]
    TrySetCanceled_MethodGroup_TaskCompletionSource_1_TResult = typing.TypeVar('TrySetCanceled_MethodGroup_TaskCompletionSource_1_TResult')
    class TrySetCanceled_MethodGroup(typing.Generic[TrySetCanceled_MethodGroup_TaskCompletionSource_1_TResult]):
        TrySetCanceled_MethodGroup_TaskCompletionSource_1_TResult = TaskCompletionSource_1.TrySetCanceled_MethodGroup_TaskCompletionSource_1_TResult
        @typing.overload
        def __call__(self) -> bool:...
        @typing.overload
        def __call__(self, cancellationToken: CancellationToken) -> bool:...

    # Skipped TrySetException due to it being static, abstract and generic.

    TrySetException : TrySetException_MethodGroup[TaskCompletionSource_1_TResult]
    TrySetException_MethodGroup_TaskCompletionSource_1_TResult = typing.TypeVar('TrySetException_MethodGroup_TaskCompletionSource_1_TResult')
    class TrySetException_MethodGroup(typing.Generic[TrySetException_MethodGroup_TaskCompletionSource_1_TResult]):
        TrySetException_MethodGroup_TaskCompletionSource_1_TResult = TaskCompletionSource_1.TrySetException_MethodGroup_TaskCompletionSource_1_TResult
        @typing.overload
        def __call__(self, exceptions: IEnumerable_1[Exception]) -> bool:...
        @typing.overload
        def __call__(self, exception: Exception) -> bool:...



class TaskContinuationOptions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : TaskContinuationOptions # 0
    PreferFairness : TaskContinuationOptions # 1
    LongRunning : TaskContinuationOptions # 2
    AttachedToParent : TaskContinuationOptions # 4
    DenyChildAttach : TaskContinuationOptions # 8
    HideScheduler : TaskContinuationOptions # 16
    LazyCancellation : TaskContinuationOptions # 32
    RunContinuationsAsynchronously : TaskContinuationOptions # 64
    NotOnRanToCompletion : TaskContinuationOptions # 65536
    NotOnFaulted : TaskContinuationOptions # 131072
    OnlyOnCanceled : TaskContinuationOptions # 196608
    NotOnCanceled : TaskContinuationOptions # 262144
    OnlyOnFaulted : TaskContinuationOptions # 327680
    OnlyOnRanToCompletion : TaskContinuationOptions # 393216
    ExecuteSynchronously : TaskContinuationOptions # 524288


class TaskCreationOptions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : TaskCreationOptions # 0
    PreferFairness : TaskCreationOptions # 1
    LongRunning : TaskCreationOptions # 2
    AttachedToParent : TaskCreationOptions # 4
    DenyChildAttach : TaskCreationOptions # 8
    HideScheduler : TaskCreationOptions # 16
    RunContinuationsAsynchronously : TaskCreationOptions # 64


class TaskExtensions(abc.ABC):
    # Skipped Unwrap due to it being static, abstract and generic.

    Unwrap : Unwrap_MethodGroup
    class Unwrap_MethodGroup:
        def __getitem__(self, t:typing.Type[Unwrap_1_T1]) -> Unwrap_1[Unwrap_1_T1]: ...

        Unwrap_1_T1 = typing.TypeVar('Unwrap_1_T1')
        class Unwrap_1(typing.Generic[Unwrap_1_T1]):
            Unwrap_1_TResult = TaskExtensions.Unwrap_MethodGroup.Unwrap_1_T1
            def __call__(self, task: Task_1[Task_1[Unwrap_1_TResult]]) -> Task_1[Unwrap_1_TResult]:...

        def __call__(self, task: Task_1[Task]) -> Task:...



class TaskFactory_GenericClasses(abc.ABCMeta):
    Generic_TaskFactory_GenericClasses_TaskFactory_1_TResult = typing.TypeVar('Generic_TaskFactory_GenericClasses_TaskFactory_1_TResult')
    def __getitem__(self, types : typing.Type[Generic_TaskFactory_GenericClasses_TaskFactory_1_TResult]) -> typing.Type[TaskFactory_1[Generic_TaskFactory_GenericClasses_TaskFactory_1_TResult]]: ...

class TaskFactory(TaskFactory_0, metaclass =TaskFactory_GenericClasses): ...

class TaskFactory_0:
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, cancellationToken: CancellationToken) -> None: ...
    @typing.overload
    def __init__(self, cancellationToken: CancellationToken, creationOptions: TaskCreationOptions, continuationOptions: TaskContinuationOptions, scheduler: TaskScheduler) -> None: ...
    @typing.overload
    def __init__(self, creationOptions: TaskCreationOptions, continuationOptions: TaskContinuationOptions) -> None: ...
    @typing.overload
    def __init__(self, scheduler: TaskScheduler) -> None: ...
    @property
    def CancellationToken(self) -> CancellationToken: ...
    @property
    def ContinuationOptions(self) -> TaskContinuationOptions: ...
    @property
    def CreationOptions(self) -> TaskCreationOptions: ...
    @property
    def Scheduler(self) -> TaskScheduler: ...
    # Skipped ContinueWhenAll due to it being static, abstract and generic.

    ContinueWhenAll : ContinueWhenAll_MethodGroup
    class ContinueWhenAll_MethodGroup:
        @typing.overload
        def __getitem__(self, t:typing.Type[ContinueWhenAll_1_T1]) -> ContinueWhenAll_1[ContinueWhenAll_1_T1]: ...

        ContinueWhenAll_1_T1 = typing.TypeVar('ContinueWhenAll_1_T1')
        class ContinueWhenAll_1(typing.Generic[ContinueWhenAll_1_T1]):
            ContinueWhenAll_1_TAntecedentResult = TaskFactory_0.ContinueWhenAll_MethodGroup.ContinueWhenAll_1_T1
            ContinueWhenAll_1_TResult = TaskFactory_0.ContinueWhenAll_MethodGroup.ContinueWhenAll_1_T1
            @typing.overload
            def __call__(self, tasks: Array_1[Task_1[ContinueWhenAll_1_TAntecedentResult]], continuationAction: Action_1[Array_1[Task_1[ContinueWhenAll_1_TAntecedentResult]]]) -> Task:...
            @typing.overload
            def __call__(self, tasks: Array_1[Task], continuationFunction: Func_2[Array_1[Task], ContinueWhenAll_1_TResult]) -> Task_1[ContinueWhenAll_1_TResult]:...
            @typing.overload
            def __call__(self, tasks: Array_1[Task_1[ContinueWhenAll_1_TAntecedentResult]], continuationAction: Action_1[Array_1[Task_1[ContinueWhenAll_1_TAntecedentResult]]], continuationOptions: TaskContinuationOptions) -> Task:...
            @typing.overload
            def __call__(self, tasks: Array_1[Task_1[ContinueWhenAll_1_TAntecedentResult]], continuationAction: Action_1[Array_1[Task_1[ContinueWhenAll_1_TAntecedentResult]]], cancellationToken: CancellationToken) -> Task:...
            @typing.overload
            def __call__(self, tasks: Array_1[Task], continuationFunction: Func_2[Array_1[Task], ContinueWhenAll_1_TResult], continuationOptions: TaskContinuationOptions) -> Task_1[ContinueWhenAll_1_TResult]:...
            @typing.overload
            def __call__(self, tasks: Array_1[Task], continuationFunction: Func_2[Array_1[Task], ContinueWhenAll_1_TResult], cancellationToken: CancellationToken) -> Task_1[ContinueWhenAll_1_TResult]:...
            @typing.overload
            def __call__(self, tasks: Array_1[Task_1[ContinueWhenAll_1_TAntecedentResult]], continuationAction: Action_1[Array_1[Task_1[ContinueWhenAll_1_TAntecedentResult]]], cancellationToken: CancellationToken, continuationOptions: TaskContinuationOptions, scheduler: TaskScheduler) -> Task:...
            @typing.overload
            def __call__(self, tasks: Array_1[Task], continuationFunction: Func_2[Array_1[Task], ContinueWhenAll_1_TResult], cancellationToken: CancellationToken, continuationOptions: TaskContinuationOptions, scheduler: TaskScheduler) -> Task_1[ContinueWhenAll_1_TResult]:...

        @typing.overload
        def __getitem__(self, t:typing.Tuple[typing.Type[ContinueWhenAll_2_T1], typing.Type[ContinueWhenAll_2_T2]]) -> ContinueWhenAll_2[ContinueWhenAll_2_T1, ContinueWhenAll_2_T2]: ...

        ContinueWhenAll_2_T1 = typing.TypeVar('ContinueWhenAll_2_T1')
        ContinueWhenAll_2_T2 = typing.TypeVar('ContinueWhenAll_2_T2')
        class ContinueWhenAll_2(typing.Generic[ContinueWhenAll_2_T1, ContinueWhenAll_2_T2]):
            ContinueWhenAll_2_TAntecedentResult = TaskFactory_0.ContinueWhenAll_MethodGroup.ContinueWhenAll_2_T1
            ContinueWhenAll_2_TResult = TaskFactory_0.ContinueWhenAll_MethodGroup.ContinueWhenAll_2_T2
            @typing.overload
            def __call__(self, tasks: Array_1[Task_1[ContinueWhenAll_2_TAntecedentResult]], continuationFunction: Func_2[Array_1[Task_1[ContinueWhenAll_2_TAntecedentResult]], ContinueWhenAll_2_TResult]) -> Task_1[ContinueWhenAll_2_TResult]:...
            @typing.overload
            def __call__(self, tasks: Array_1[Task_1[ContinueWhenAll_2_TAntecedentResult]], continuationFunction: Func_2[Array_1[Task_1[ContinueWhenAll_2_TAntecedentResult]], ContinueWhenAll_2_TResult], continuationOptions: TaskContinuationOptions) -> Task_1[ContinueWhenAll_2_TResult]:...
            @typing.overload
            def __call__(self, tasks: Array_1[Task_1[ContinueWhenAll_2_TAntecedentResult]], continuationFunction: Func_2[Array_1[Task_1[ContinueWhenAll_2_TAntecedentResult]], ContinueWhenAll_2_TResult], cancellationToken: CancellationToken) -> Task_1[ContinueWhenAll_2_TResult]:...
            @typing.overload
            def __call__(self, tasks: Array_1[Task_1[ContinueWhenAll_2_TAntecedentResult]], continuationFunction: Func_2[Array_1[Task_1[ContinueWhenAll_2_TAntecedentResult]], ContinueWhenAll_2_TResult], cancellationToken: CancellationToken, continuationOptions: TaskContinuationOptions, scheduler: TaskScheduler) -> Task_1[ContinueWhenAll_2_TResult]:...

        @typing.overload
        def __call__(self, tasks: Array_1[Task], continuationAction: Action_1[Array_1[Task]]) -> Task:...
        @typing.overload
        def __call__(self, tasks: Array_1[Task], continuationAction: Action_1[Array_1[Task]], continuationOptions: TaskContinuationOptions) -> Task:...
        @typing.overload
        def __call__(self, tasks: Array_1[Task], continuationAction: Action_1[Array_1[Task]], cancellationToken: CancellationToken) -> Task:...
        @typing.overload
        def __call__(self, tasks: Array_1[Task], continuationAction: Action_1[Array_1[Task]], cancellationToken: CancellationToken, continuationOptions: TaskContinuationOptions, scheduler: TaskScheduler) -> Task:...

    # Skipped ContinueWhenAny due to it being static, abstract and generic.

    ContinueWhenAny : ContinueWhenAny_MethodGroup
    class ContinueWhenAny_MethodGroup:
        @typing.overload
        def __getitem__(self, t:typing.Type[ContinueWhenAny_1_T1]) -> ContinueWhenAny_1[ContinueWhenAny_1_T1]: ...

        ContinueWhenAny_1_T1 = typing.TypeVar('ContinueWhenAny_1_T1')
        class ContinueWhenAny_1(typing.Generic[ContinueWhenAny_1_T1]):
            ContinueWhenAny_1_TAntecedentResult = TaskFactory_0.ContinueWhenAny_MethodGroup.ContinueWhenAny_1_T1
            ContinueWhenAny_1_TResult = TaskFactory_0.ContinueWhenAny_MethodGroup.ContinueWhenAny_1_T1
            @typing.overload
            def __call__(self, tasks: Array_1[Task_1[ContinueWhenAny_1_TAntecedentResult]], continuationAction: Action_1[Task_1[ContinueWhenAny_1_TAntecedentResult]]) -> Task:...
            @typing.overload
            def __call__(self, tasks: Array_1[Task], continuationFunction: Func_2[Task, ContinueWhenAny_1_TResult]) -> Task_1[ContinueWhenAny_1_TResult]:...
            @typing.overload
            def __call__(self, tasks: Array_1[Task_1[ContinueWhenAny_1_TAntecedentResult]], continuationAction: Action_1[Task_1[ContinueWhenAny_1_TAntecedentResult]], continuationOptions: TaskContinuationOptions) -> Task:...
            @typing.overload
            def __call__(self, tasks: Array_1[Task_1[ContinueWhenAny_1_TAntecedentResult]], continuationAction: Action_1[Task_1[ContinueWhenAny_1_TAntecedentResult]], cancellationToken: CancellationToken) -> Task:...
            @typing.overload
            def __call__(self, tasks: Array_1[Task], continuationFunction: Func_2[Task, ContinueWhenAny_1_TResult], continuationOptions: TaskContinuationOptions) -> Task_1[ContinueWhenAny_1_TResult]:...
            @typing.overload
            def __call__(self, tasks: Array_1[Task], continuationFunction: Func_2[Task, ContinueWhenAny_1_TResult], cancellationToken: CancellationToken) -> Task_1[ContinueWhenAny_1_TResult]:...
            @typing.overload
            def __call__(self, tasks: Array_1[Task_1[ContinueWhenAny_1_TAntecedentResult]], continuationAction: Action_1[Task_1[ContinueWhenAny_1_TAntecedentResult]], cancellationToken: CancellationToken, continuationOptions: TaskContinuationOptions, scheduler: TaskScheduler) -> Task:...
            @typing.overload
            def __call__(self, tasks: Array_1[Task], continuationFunction: Func_2[Task, ContinueWhenAny_1_TResult], cancellationToken: CancellationToken, continuationOptions: TaskContinuationOptions, scheduler: TaskScheduler) -> Task_1[ContinueWhenAny_1_TResult]:...

        @typing.overload
        def __getitem__(self, t:typing.Tuple[typing.Type[ContinueWhenAny_2_T1], typing.Type[ContinueWhenAny_2_T2]]) -> ContinueWhenAny_2[ContinueWhenAny_2_T1, ContinueWhenAny_2_T2]: ...

        ContinueWhenAny_2_T1 = typing.TypeVar('ContinueWhenAny_2_T1')
        ContinueWhenAny_2_T2 = typing.TypeVar('ContinueWhenAny_2_T2')
        class ContinueWhenAny_2(typing.Generic[ContinueWhenAny_2_T1, ContinueWhenAny_2_T2]):
            ContinueWhenAny_2_TAntecedentResult = TaskFactory_0.ContinueWhenAny_MethodGroup.ContinueWhenAny_2_T1
            ContinueWhenAny_2_TResult = TaskFactory_0.ContinueWhenAny_MethodGroup.ContinueWhenAny_2_T2
            @typing.overload
            def __call__(self, tasks: Array_1[Task_1[ContinueWhenAny_2_TAntecedentResult]], continuationFunction: Func_2[Task_1[ContinueWhenAny_2_TAntecedentResult], ContinueWhenAny_2_TResult]) -> Task_1[ContinueWhenAny_2_TResult]:...
            @typing.overload
            def __call__(self, tasks: Array_1[Task_1[ContinueWhenAny_2_TAntecedentResult]], continuationFunction: Func_2[Task_1[ContinueWhenAny_2_TAntecedentResult], ContinueWhenAny_2_TResult], continuationOptions: TaskContinuationOptions) -> Task_1[ContinueWhenAny_2_TResult]:...
            @typing.overload
            def __call__(self, tasks: Array_1[Task_1[ContinueWhenAny_2_TAntecedentResult]], continuationFunction: Func_2[Task_1[ContinueWhenAny_2_TAntecedentResult], ContinueWhenAny_2_TResult], cancellationToken: CancellationToken) -> Task_1[ContinueWhenAny_2_TResult]:...
            @typing.overload
            def __call__(self, tasks: Array_1[Task_1[ContinueWhenAny_2_TAntecedentResult]], continuationFunction: Func_2[Task_1[ContinueWhenAny_2_TAntecedentResult], ContinueWhenAny_2_TResult], cancellationToken: CancellationToken, continuationOptions: TaskContinuationOptions, scheduler: TaskScheduler) -> Task_1[ContinueWhenAny_2_TResult]:...

        @typing.overload
        def __call__(self, tasks: Array_1[Task], continuationAction: Action_1[Task]) -> Task:...
        @typing.overload
        def __call__(self, tasks: Array_1[Task], continuationAction: Action_1[Task], continuationOptions: TaskContinuationOptions) -> Task:...
        @typing.overload
        def __call__(self, tasks: Array_1[Task], continuationAction: Action_1[Task], cancellationToken: CancellationToken) -> Task:...
        @typing.overload
        def __call__(self, tasks: Array_1[Task], continuationAction: Action_1[Task], cancellationToken: CancellationToken, continuationOptions: TaskContinuationOptions, scheduler: TaskScheduler) -> Task:...

    # Skipped FromAsync due to it being static, abstract and generic.

    FromAsync : FromAsync_MethodGroup
    class FromAsync_MethodGroup:
        @typing.overload
        def __getitem__(self, t:typing.Type[FromAsync_1_T1]) -> FromAsync_1[FromAsync_1_T1]: ...

        FromAsync_1_T1 = typing.TypeVar('FromAsync_1_T1')
        class FromAsync_1(typing.Generic[FromAsync_1_T1]):
            FromAsync_1_TResult = TaskFactory_0.FromAsync_MethodGroup.FromAsync_1_T1
            FromAsync_1_TArg1 = TaskFactory_0.FromAsync_MethodGroup.FromAsync_1_T1
            @typing.overload
            def __call__(self, asyncResult: IAsyncResult, endMethod: Func_2[IAsyncResult, FromAsync_1_TResult]) -> Task_1[FromAsync_1_TResult]:...
            @typing.overload
            def __call__(self, beginMethod: Func_3[AsyncCallback, typing.Any, IAsyncResult], endMethod: Func_2[IAsyncResult, FromAsync_1_TResult], state: typing.Any) -> Task_1[FromAsync_1_TResult]:...
            @typing.overload
            def __call__(self, asyncResult: IAsyncResult, endMethod: Func_2[IAsyncResult, FromAsync_1_TResult], creationOptions: TaskCreationOptions) -> Task_1[FromAsync_1_TResult]:...
            @typing.overload
            def __call__(self, beginMethod: Func_3[AsyncCallback, typing.Any, IAsyncResult], endMethod: Func_2[IAsyncResult, FromAsync_1_TResult], state: typing.Any, creationOptions: TaskCreationOptions) -> Task_1[FromAsync_1_TResult]:...
            @typing.overload
            def __call__(self, beginMethod: Func_4[FromAsync_1_TArg1, AsyncCallback, typing.Any, IAsyncResult], endMethod: Action_1[IAsyncResult], arg1: FromAsync_1_TArg1, state: typing.Any) -> Task:...
            @typing.overload
            def __call__(self, asyncResult: IAsyncResult, endMethod: Func_2[IAsyncResult, FromAsync_1_TResult], creationOptions: TaskCreationOptions, scheduler: TaskScheduler) -> Task_1[FromAsync_1_TResult]:...
            @typing.overload
            def __call__(self, beginMethod: Func_4[FromAsync_1_TArg1, AsyncCallback, typing.Any, IAsyncResult], endMethod: Action_1[IAsyncResult], arg1: FromAsync_1_TArg1, state: typing.Any, creationOptions: TaskCreationOptions) -> Task:...

        @typing.overload
        def __getitem__(self, t:typing.Tuple[typing.Type[FromAsync_2_T1], typing.Type[FromAsync_2_T2]]) -> FromAsync_2[FromAsync_2_T1, FromAsync_2_T2]: ...

        FromAsync_2_T1 = typing.TypeVar('FromAsync_2_T1')
        FromAsync_2_T2 = typing.TypeVar('FromAsync_2_T2')
        class FromAsync_2(typing.Generic[FromAsync_2_T1, FromAsync_2_T2]):
            FromAsync_2_TArg1 = TaskFactory_0.FromAsync_MethodGroup.FromAsync_2_T1
            FromAsync_2_TResult = TaskFactory_0.FromAsync_MethodGroup.FromAsync_2_T2
            FromAsync_2_TArg2 = TaskFactory_0.FromAsync_MethodGroup.FromAsync_2_T2
            @typing.overload
            def __call__(self, beginMethod: Func_4[FromAsync_2_TArg1, AsyncCallback, typing.Any, IAsyncResult], endMethod: Func_2[IAsyncResult, FromAsync_2_TResult], arg1: FromAsync_2_TArg1, state: typing.Any) -> Task_1[FromAsync_2_TResult]:...
            @typing.overload
            def __call__(self, beginMethod: Func_4[FromAsync_2_TArg1, AsyncCallback, typing.Any, IAsyncResult], endMethod: Func_2[IAsyncResult, FromAsync_2_TResult], arg1: FromAsync_2_TArg1, state: typing.Any, creationOptions: TaskCreationOptions) -> Task_1[FromAsync_2_TResult]:...
            @typing.overload
            def __call__(self, beginMethod: Func_5[FromAsync_2_TArg1, FromAsync_2_TArg2, AsyncCallback, typing.Any, IAsyncResult], endMethod: Action_1[IAsyncResult], arg1: FromAsync_2_TArg1, arg2: FromAsync_2_TArg2, state: typing.Any) -> Task:...
            @typing.overload
            def __call__(self, beginMethod: Func_5[FromAsync_2_TArg1, FromAsync_2_TArg2, AsyncCallback, typing.Any, IAsyncResult], endMethod: Action_1[IAsyncResult], arg1: FromAsync_2_TArg1, arg2: FromAsync_2_TArg2, state: typing.Any, creationOptions: TaskCreationOptions) -> Task:...

        @typing.overload
        def __getitem__(self, t:typing.Tuple[typing.Type[FromAsync_3_T1], typing.Type[FromAsync_3_T2], typing.Type[FromAsync_3_T3]]) -> FromAsync_3[FromAsync_3_T1, FromAsync_3_T2, FromAsync_3_T3]: ...

        FromAsync_3_T1 = typing.TypeVar('FromAsync_3_T1')
        FromAsync_3_T2 = typing.TypeVar('FromAsync_3_T2')
        FromAsync_3_T3 = typing.TypeVar('FromAsync_3_T3')
        class FromAsync_3(typing.Generic[FromAsync_3_T1, FromAsync_3_T2, FromAsync_3_T3]):
            FromAsync_3_TArg1 = TaskFactory_0.FromAsync_MethodGroup.FromAsync_3_T1
            FromAsync_3_TArg2 = TaskFactory_0.FromAsync_MethodGroup.FromAsync_3_T2
            FromAsync_3_TResult = TaskFactory_0.FromAsync_MethodGroup.FromAsync_3_T3
            FromAsync_3_TArg3 = TaskFactory_0.FromAsync_MethodGroup.FromAsync_3_T3
            @typing.overload
            def __call__(self, beginMethod: Func_5[FromAsync_3_TArg1, FromAsync_3_TArg2, AsyncCallback, typing.Any, IAsyncResult], endMethod: Func_2[IAsyncResult, FromAsync_3_TResult], arg1: FromAsync_3_TArg1, arg2: FromAsync_3_TArg2, state: typing.Any) -> Task_1[FromAsync_3_TResult]:...
            @typing.overload
            def __call__(self, beginMethod: Func_5[FromAsync_3_TArg1, FromAsync_3_TArg2, AsyncCallback, typing.Any, IAsyncResult], endMethod: Func_2[IAsyncResult, FromAsync_3_TResult], arg1: FromAsync_3_TArg1, arg2: FromAsync_3_TArg2, state: typing.Any, creationOptions: TaskCreationOptions) -> Task_1[FromAsync_3_TResult]:...
            @typing.overload
            def __call__(self, beginMethod: Func_6[FromAsync_3_TArg1, FromAsync_3_TArg2, FromAsync_3_TArg3, AsyncCallback, typing.Any, IAsyncResult], endMethod: Action_1[IAsyncResult], arg1: FromAsync_3_TArg1, arg2: FromAsync_3_TArg2, arg3: FromAsync_3_TArg3, state: typing.Any) -> Task:...
            @typing.overload
            def __call__(self, beginMethod: Func_6[FromAsync_3_TArg1, FromAsync_3_TArg2, FromAsync_3_TArg3, AsyncCallback, typing.Any, IAsyncResult], endMethod: Action_1[IAsyncResult], arg1: FromAsync_3_TArg1, arg2: FromAsync_3_TArg2, arg3: FromAsync_3_TArg3, state: typing.Any, creationOptions: TaskCreationOptions) -> Task:...

        @typing.overload
        def __getitem__(self, t:typing.Tuple[typing.Type[FromAsync_4_T1], typing.Type[FromAsync_4_T2], typing.Type[FromAsync_4_T3], typing.Type[FromAsync_4_T4]]) -> FromAsync_4[FromAsync_4_T1, FromAsync_4_T2, FromAsync_4_T3, FromAsync_4_T4]: ...

        FromAsync_4_T1 = typing.TypeVar('FromAsync_4_T1')
        FromAsync_4_T2 = typing.TypeVar('FromAsync_4_T2')
        FromAsync_4_T3 = typing.TypeVar('FromAsync_4_T3')
        FromAsync_4_T4 = typing.TypeVar('FromAsync_4_T4')
        class FromAsync_4(typing.Generic[FromAsync_4_T1, FromAsync_4_T2, FromAsync_4_T3, FromAsync_4_T4]):
            FromAsync_4_TArg1 = TaskFactory_0.FromAsync_MethodGroup.FromAsync_4_T1
            FromAsync_4_TArg2 = TaskFactory_0.FromAsync_MethodGroup.FromAsync_4_T2
            FromAsync_4_TArg3 = TaskFactory_0.FromAsync_MethodGroup.FromAsync_4_T3
            FromAsync_4_TResult = TaskFactory_0.FromAsync_MethodGroup.FromAsync_4_T4
            @typing.overload
            def __call__(self, beginMethod: Func_6[FromAsync_4_TArg1, FromAsync_4_TArg2, FromAsync_4_TArg3, AsyncCallback, typing.Any, IAsyncResult], endMethod: Func_2[IAsyncResult, FromAsync_4_TResult], arg1: FromAsync_4_TArg1, arg2: FromAsync_4_TArg2, arg3: FromAsync_4_TArg3, state: typing.Any) -> Task_1[FromAsync_4_TResult]:...
            @typing.overload
            def __call__(self, beginMethod: Func_6[FromAsync_4_TArg1, FromAsync_4_TArg2, FromAsync_4_TArg3, AsyncCallback, typing.Any, IAsyncResult], endMethod: Func_2[IAsyncResult, FromAsync_4_TResult], arg1: FromAsync_4_TArg1, arg2: FromAsync_4_TArg2, arg3: FromAsync_4_TArg3, state: typing.Any, creationOptions: TaskCreationOptions) -> Task_1[FromAsync_4_TResult]:...

        @typing.overload
        def __call__(self, asyncResult: IAsyncResult, endMethod: Action_1[IAsyncResult]) -> Task:...
        @typing.overload
        def __call__(self, beginMethod: Func_3[AsyncCallback, typing.Any, IAsyncResult], endMethod: Action_1[IAsyncResult], state: typing.Any) -> Task:...
        @typing.overload
        def __call__(self, asyncResult: IAsyncResult, endMethod: Action_1[IAsyncResult], creationOptions: TaskCreationOptions) -> Task:...
        @typing.overload
        def __call__(self, beginMethod: Func_3[AsyncCallback, typing.Any, IAsyncResult], endMethod: Action_1[IAsyncResult], state: typing.Any, creationOptions: TaskCreationOptions) -> Task:...
        @typing.overload
        def __call__(self, asyncResult: IAsyncResult, endMethod: Action_1[IAsyncResult], creationOptions: TaskCreationOptions, scheduler: TaskScheduler) -> Task:...

    # Skipped StartNew due to it being static, abstract and generic.

    StartNew : StartNew_MethodGroup
    class StartNew_MethodGroup:
        def __getitem__(self, t:typing.Type[StartNew_1_T1]) -> StartNew_1[StartNew_1_T1]: ...

        StartNew_1_T1 = typing.TypeVar('StartNew_1_T1')
        class StartNew_1(typing.Generic[StartNew_1_T1]):
            StartNew_1_TResult = TaskFactory_0.StartNew_MethodGroup.StartNew_1_T1
            @typing.overload
            def __call__(self, function: Func_1[StartNew_1_TResult]) -> Task_1[StartNew_1_TResult]:...
            @typing.overload
            def __call__(self, function: Func_1[StartNew_1_TResult], creationOptions: TaskCreationOptions) -> Task_1[StartNew_1_TResult]:...
            @typing.overload
            def __call__(self, function: Func_1[StartNew_1_TResult], cancellationToken: CancellationToken) -> Task_1[StartNew_1_TResult]:...
            @typing.overload
            def __call__(self, function: Func_2[typing.Any, StartNew_1_TResult], state: typing.Any) -> Task_1[StartNew_1_TResult]:...
            @typing.overload
            def __call__(self, function: Func_2[typing.Any, StartNew_1_TResult], state: typing.Any, creationOptions: TaskCreationOptions) -> Task_1[StartNew_1_TResult]:...
            @typing.overload
            def __call__(self, function: Func_2[typing.Any, StartNew_1_TResult], state: typing.Any, cancellationToken: CancellationToken) -> Task_1[StartNew_1_TResult]:...
            @typing.overload
            def __call__(self, function: Func_1[StartNew_1_TResult], cancellationToken: CancellationToken, creationOptions: TaskCreationOptions, scheduler: TaskScheduler) -> Task_1[StartNew_1_TResult]:...
            @typing.overload
            def __call__(self, function: Func_2[typing.Any, StartNew_1_TResult], state: typing.Any, cancellationToken: CancellationToken, creationOptions: TaskCreationOptions, scheduler: TaskScheduler) -> Task_1[StartNew_1_TResult]:...

        @typing.overload
        def __call__(self, action: Action) -> Task:...
        @typing.overload
        def __call__(self, action: Action_1[typing.Any], state: typing.Any) -> Task:...
        @typing.overload
        def __call__(self, action: Action, creationOptions: TaskCreationOptions) -> Task:...
        @typing.overload
        def __call__(self, action: Action, cancellationToken: CancellationToken) -> Task:...
        @typing.overload
        def __call__(self, action: Action_1[typing.Any], state: typing.Any, creationOptions: TaskCreationOptions) -> Task:...
        @typing.overload
        def __call__(self, action: Action_1[typing.Any], state: typing.Any, cancellationToken: CancellationToken) -> Task:...
        @typing.overload
        def __call__(self, action: Action, cancellationToken: CancellationToken, creationOptions: TaskCreationOptions, scheduler: TaskScheduler) -> Task:...
        @typing.overload
        def __call__(self, action: Action_1[typing.Any], state: typing.Any, cancellationToken: CancellationToken, creationOptions: TaskCreationOptions, scheduler: TaskScheduler) -> Task:...



TaskFactory_1_TResult = typing.TypeVar('TaskFactory_1_TResult')
class TaskFactory_1(typing.Generic[TaskFactory_1_TResult]):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, cancellationToken: CancellationToken) -> None: ...
    @typing.overload
    def __init__(self, cancellationToken: CancellationToken, creationOptions: TaskCreationOptions, continuationOptions: TaskContinuationOptions, scheduler: TaskScheduler) -> None: ...
    @typing.overload
    def __init__(self, creationOptions: TaskCreationOptions, continuationOptions: TaskContinuationOptions) -> None: ...
    @typing.overload
    def __init__(self, scheduler: TaskScheduler) -> None: ...
    @property
    def CancellationToken(self) -> CancellationToken: ...
    @property
    def ContinuationOptions(self) -> TaskContinuationOptions: ...
    @property
    def CreationOptions(self) -> TaskCreationOptions: ...
    @property
    def Scheduler(self) -> TaskScheduler: ...
    # Skipped ContinueWhenAll due to it being static, abstract and generic.

    ContinueWhenAll : ContinueWhenAll_MethodGroup[TaskFactory_1_TResult]
    ContinueWhenAll_MethodGroup_TaskFactory_1_TResult = typing.TypeVar('ContinueWhenAll_MethodGroup_TaskFactory_1_TResult')
    class ContinueWhenAll_MethodGroup(typing.Generic[ContinueWhenAll_MethodGroup_TaskFactory_1_TResult]):
        ContinueWhenAll_MethodGroup_TaskFactory_1_TResult = TaskFactory_1.ContinueWhenAll_MethodGroup_TaskFactory_1_TResult
        def __getitem__(self, t:typing.Type[ContinueWhenAll_1_T1]) -> ContinueWhenAll_1[ContinueWhenAll_MethodGroup_TaskFactory_1_TResult, ContinueWhenAll_1_T1]: ...

        ContinueWhenAll_1_TaskFactory_1_TResult = typing.TypeVar('ContinueWhenAll_1_TaskFactory_1_TResult')
        ContinueWhenAll_1_T1 = typing.TypeVar('ContinueWhenAll_1_T1')
        class ContinueWhenAll_1(typing.Generic[ContinueWhenAll_1_TaskFactory_1_TResult, ContinueWhenAll_1_T1]):
            ContinueWhenAll_1_TaskFactory_1_TResult = TaskFactory_1.ContinueWhenAll_MethodGroup.ContinueWhenAll_1_TaskFactory_1_TResult
            ContinueWhenAll_1_TAntecedentResult = TaskFactory_1.ContinueWhenAll_MethodGroup.ContinueWhenAll_1_T1
            @typing.overload
            def __call__(self, tasks: Array_1[Task_1[ContinueWhenAll_1_TAntecedentResult]], continuationFunction: Func_2[Array_1[Task_1[ContinueWhenAll_1_TAntecedentResult]], ContinueWhenAll_1_TaskFactory_1_TResult]) -> Task_1[ContinueWhenAll_1_TaskFactory_1_TResult]:...
            @typing.overload
            def __call__(self, tasks: Array_1[Task_1[ContinueWhenAll_1_TAntecedentResult]], continuationFunction: Func_2[Array_1[Task_1[ContinueWhenAll_1_TAntecedentResult]], ContinueWhenAll_1_TaskFactory_1_TResult], continuationOptions: TaskContinuationOptions) -> Task_1[ContinueWhenAll_1_TaskFactory_1_TResult]:...
            @typing.overload
            def __call__(self, tasks: Array_1[Task_1[ContinueWhenAll_1_TAntecedentResult]], continuationFunction: Func_2[Array_1[Task_1[ContinueWhenAll_1_TAntecedentResult]], ContinueWhenAll_1_TaskFactory_1_TResult], cancellationToken: CancellationToken) -> Task_1[ContinueWhenAll_1_TaskFactory_1_TResult]:...
            @typing.overload
            def __call__(self, tasks: Array_1[Task_1[ContinueWhenAll_1_TAntecedentResult]], continuationFunction: Func_2[Array_1[Task_1[ContinueWhenAll_1_TAntecedentResult]], ContinueWhenAll_1_TaskFactory_1_TResult], cancellationToken: CancellationToken, continuationOptions: TaskContinuationOptions, scheduler: TaskScheduler) -> Task_1[ContinueWhenAll_1_TaskFactory_1_TResult]:...

        @typing.overload
        def __call__(self, tasks: Array_1[Task], continuationFunction: Func_2[Array_1[Task], ContinueWhenAll_MethodGroup_TaskFactory_1_TResult]) -> Task_1[ContinueWhenAll_MethodGroup_TaskFactory_1_TResult]:...
        @typing.overload
        def __call__(self, tasks: Array_1[Task], continuationFunction: Func_2[Array_1[Task], ContinueWhenAll_MethodGroup_TaskFactory_1_TResult], continuationOptions: TaskContinuationOptions) -> Task_1[ContinueWhenAll_MethodGroup_TaskFactory_1_TResult]:...
        @typing.overload
        def __call__(self, tasks: Array_1[Task], continuationFunction: Func_2[Array_1[Task], ContinueWhenAll_MethodGroup_TaskFactory_1_TResult], cancellationToken: CancellationToken) -> Task_1[ContinueWhenAll_MethodGroup_TaskFactory_1_TResult]:...
        @typing.overload
        def __call__(self, tasks: Array_1[Task], continuationFunction: Func_2[Array_1[Task], ContinueWhenAll_MethodGroup_TaskFactory_1_TResult], cancellationToken: CancellationToken, continuationOptions: TaskContinuationOptions, scheduler: TaskScheduler) -> Task_1[ContinueWhenAll_MethodGroup_TaskFactory_1_TResult]:...

    # Skipped ContinueWhenAny due to it being static, abstract and generic.

    ContinueWhenAny : ContinueWhenAny_MethodGroup[TaskFactory_1_TResult]
    ContinueWhenAny_MethodGroup_TaskFactory_1_TResult = typing.TypeVar('ContinueWhenAny_MethodGroup_TaskFactory_1_TResult')
    class ContinueWhenAny_MethodGroup(typing.Generic[ContinueWhenAny_MethodGroup_TaskFactory_1_TResult]):
        ContinueWhenAny_MethodGroup_TaskFactory_1_TResult = TaskFactory_1.ContinueWhenAny_MethodGroup_TaskFactory_1_TResult
        def __getitem__(self, t:typing.Type[ContinueWhenAny_1_T1]) -> ContinueWhenAny_1[ContinueWhenAny_MethodGroup_TaskFactory_1_TResult, ContinueWhenAny_1_T1]: ...

        ContinueWhenAny_1_TaskFactory_1_TResult = typing.TypeVar('ContinueWhenAny_1_TaskFactory_1_TResult')
        ContinueWhenAny_1_T1 = typing.TypeVar('ContinueWhenAny_1_T1')
        class ContinueWhenAny_1(typing.Generic[ContinueWhenAny_1_TaskFactory_1_TResult, ContinueWhenAny_1_T1]):
            ContinueWhenAny_1_TaskFactory_1_TResult = TaskFactory_1.ContinueWhenAny_MethodGroup.ContinueWhenAny_1_TaskFactory_1_TResult
            ContinueWhenAny_1_TAntecedentResult = TaskFactory_1.ContinueWhenAny_MethodGroup.ContinueWhenAny_1_T1
            @typing.overload
            def __call__(self, tasks: Array_1[Task_1[ContinueWhenAny_1_TAntecedentResult]], continuationFunction: Func_2[Task_1[ContinueWhenAny_1_TAntecedentResult], ContinueWhenAny_1_TaskFactory_1_TResult]) -> Task_1[ContinueWhenAny_1_TaskFactory_1_TResult]:...
            @typing.overload
            def __call__(self, tasks: Array_1[Task_1[ContinueWhenAny_1_TAntecedentResult]], continuationFunction: Func_2[Task_1[ContinueWhenAny_1_TAntecedentResult], ContinueWhenAny_1_TaskFactory_1_TResult], continuationOptions: TaskContinuationOptions) -> Task_1[ContinueWhenAny_1_TaskFactory_1_TResult]:...
            @typing.overload
            def __call__(self, tasks: Array_1[Task_1[ContinueWhenAny_1_TAntecedentResult]], continuationFunction: Func_2[Task_1[ContinueWhenAny_1_TAntecedentResult], ContinueWhenAny_1_TaskFactory_1_TResult], cancellationToken: CancellationToken) -> Task_1[ContinueWhenAny_1_TaskFactory_1_TResult]:...
            @typing.overload
            def __call__(self, tasks: Array_1[Task_1[ContinueWhenAny_1_TAntecedentResult]], continuationFunction: Func_2[Task_1[ContinueWhenAny_1_TAntecedentResult], ContinueWhenAny_1_TaskFactory_1_TResult], cancellationToken: CancellationToken, continuationOptions: TaskContinuationOptions, scheduler: TaskScheduler) -> Task_1[ContinueWhenAny_1_TaskFactory_1_TResult]:...

        @typing.overload
        def __call__(self, tasks: Array_1[Task], continuationFunction: Func_2[Task, ContinueWhenAny_MethodGroup_TaskFactory_1_TResult]) -> Task_1[ContinueWhenAny_MethodGroup_TaskFactory_1_TResult]:...
        @typing.overload
        def __call__(self, tasks: Array_1[Task], continuationFunction: Func_2[Task, ContinueWhenAny_MethodGroup_TaskFactory_1_TResult], continuationOptions: TaskContinuationOptions) -> Task_1[ContinueWhenAny_MethodGroup_TaskFactory_1_TResult]:...
        @typing.overload
        def __call__(self, tasks: Array_1[Task], continuationFunction: Func_2[Task, ContinueWhenAny_MethodGroup_TaskFactory_1_TResult], cancellationToken: CancellationToken) -> Task_1[ContinueWhenAny_MethodGroup_TaskFactory_1_TResult]:...
        @typing.overload
        def __call__(self, tasks: Array_1[Task], continuationFunction: Func_2[Task, ContinueWhenAny_MethodGroup_TaskFactory_1_TResult], cancellationToken: CancellationToken, continuationOptions: TaskContinuationOptions, scheduler: TaskScheduler) -> Task_1[ContinueWhenAny_MethodGroup_TaskFactory_1_TResult]:...

    # Skipped FromAsync due to it being static, abstract and generic.

    FromAsync : FromAsync_MethodGroup[TaskFactory_1_TResult]
    FromAsync_MethodGroup_TaskFactory_1_TResult = typing.TypeVar('FromAsync_MethodGroup_TaskFactory_1_TResult')
    class FromAsync_MethodGroup(typing.Generic[FromAsync_MethodGroup_TaskFactory_1_TResult]):
        FromAsync_MethodGroup_TaskFactory_1_TResult = TaskFactory_1.FromAsync_MethodGroup_TaskFactory_1_TResult
        @typing.overload
        def __getitem__(self, t:typing.Type[FromAsync_1_T1]) -> FromAsync_1[FromAsync_MethodGroup_TaskFactory_1_TResult, FromAsync_1_T1]: ...

        FromAsync_1_TaskFactory_1_TResult = typing.TypeVar('FromAsync_1_TaskFactory_1_TResult')
        FromAsync_1_T1 = typing.TypeVar('FromAsync_1_T1')
        class FromAsync_1(typing.Generic[FromAsync_1_TaskFactory_1_TResult, FromAsync_1_T1]):
            FromAsync_1_TaskFactory_1_TResult = TaskFactory_1.FromAsync_MethodGroup.FromAsync_1_TaskFactory_1_TResult
            FromAsync_1_TArg1 = TaskFactory_1.FromAsync_MethodGroup.FromAsync_1_T1
            @typing.overload
            def __call__(self, beginMethod: Func_4[FromAsync_1_TArg1, AsyncCallback, typing.Any, IAsyncResult], endMethod: Func_2[IAsyncResult, FromAsync_1_TaskFactory_1_TResult], arg1: FromAsync_1_TArg1, state: typing.Any) -> Task_1[FromAsync_1_TaskFactory_1_TResult]:...
            @typing.overload
            def __call__(self, beginMethod: Func_4[FromAsync_1_TArg1, AsyncCallback, typing.Any, IAsyncResult], endMethod: Func_2[IAsyncResult, FromAsync_1_TaskFactory_1_TResult], arg1: FromAsync_1_TArg1, state: typing.Any, creationOptions: TaskCreationOptions) -> Task_1[FromAsync_1_TaskFactory_1_TResult]:...

        @typing.overload
        def __getitem__(self, t:typing.Tuple[typing.Type[FromAsync_2_T1], typing.Type[FromAsync_2_T2]]) -> FromAsync_2[FromAsync_MethodGroup_TaskFactory_1_TResult, FromAsync_2_T1, FromAsync_2_T2]: ...

        FromAsync_2_TaskFactory_1_TResult = typing.TypeVar('FromAsync_2_TaskFactory_1_TResult')
        FromAsync_2_T1 = typing.TypeVar('FromAsync_2_T1')
        FromAsync_2_T2 = typing.TypeVar('FromAsync_2_T2')
        class FromAsync_2(typing.Generic[FromAsync_2_TaskFactory_1_TResult, FromAsync_2_T1, FromAsync_2_T2]):
            FromAsync_2_TaskFactory_1_TResult = TaskFactory_1.FromAsync_MethodGroup.FromAsync_2_TaskFactory_1_TResult
            FromAsync_2_TArg1 = TaskFactory_1.FromAsync_MethodGroup.FromAsync_2_T1
            FromAsync_2_TArg2 = TaskFactory_1.FromAsync_MethodGroup.FromAsync_2_T2
            @typing.overload
            def __call__(self, beginMethod: Func_5[FromAsync_2_TArg1, FromAsync_2_TArg2, AsyncCallback, typing.Any, IAsyncResult], endMethod: Func_2[IAsyncResult, FromAsync_2_TaskFactory_1_TResult], arg1: FromAsync_2_TArg1, arg2: FromAsync_2_TArg2, state: typing.Any) -> Task_1[FromAsync_2_TaskFactory_1_TResult]:...
            @typing.overload
            def __call__(self, beginMethod: Func_5[FromAsync_2_TArg1, FromAsync_2_TArg2, AsyncCallback, typing.Any, IAsyncResult], endMethod: Func_2[IAsyncResult, FromAsync_2_TaskFactory_1_TResult], arg1: FromAsync_2_TArg1, arg2: FromAsync_2_TArg2, state: typing.Any, creationOptions: TaskCreationOptions) -> Task_1[FromAsync_2_TaskFactory_1_TResult]:...

        @typing.overload
        def __getitem__(self, t:typing.Tuple[typing.Type[FromAsync_3_T1], typing.Type[FromAsync_3_T2], typing.Type[FromAsync_3_T3]]) -> FromAsync_3[FromAsync_MethodGroup_TaskFactory_1_TResult, FromAsync_3_T1, FromAsync_3_T2, FromAsync_3_T3]: ...

        FromAsync_3_TaskFactory_1_TResult = typing.TypeVar('FromAsync_3_TaskFactory_1_TResult')
        FromAsync_3_T1 = typing.TypeVar('FromAsync_3_T1')
        FromAsync_3_T2 = typing.TypeVar('FromAsync_3_T2')
        FromAsync_3_T3 = typing.TypeVar('FromAsync_3_T3')
        class FromAsync_3(typing.Generic[FromAsync_3_TaskFactory_1_TResult, FromAsync_3_T1, FromAsync_3_T2, FromAsync_3_T3]):
            FromAsync_3_TaskFactory_1_TResult = TaskFactory_1.FromAsync_MethodGroup.FromAsync_3_TaskFactory_1_TResult
            FromAsync_3_TArg1 = TaskFactory_1.FromAsync_MethodGroup.FromAsync_3_T1
            FromAsync_3_TArg2 = TaskFactory_1.FromAsync_MethodGroup.FromAsync_3_T2
            FromAsync_3_TArg3 = TaskFactory_1.FromAsync_MethodGroup.FromAsync_3_T3
            @typing.overload
            def __call__(self, beginMethod: Func_6[FromAsync_3_TArg1, FromAsync_3_TArg2, FromAsync_3_TArg3, AsyncCallback, typing.Any, IAsyncResult], endMethod: Func_2[IAsyncResult, FromAsync_3_TaskFactory_1_TResult], arg1: FromAsync_3_TArg1, arg2: FromAsync_3_TArg2, arg3: FromAsync_3_TArg3, state: typing.Any) -> Task_1[FromAsync_3_TaskFactory_1_TResult]:...
            @typing.overload
            def __call__(self, beginMethod: Func_6[FromAsync_3_TArg1, FromAsync_3_TArg2, FromAsync_3_TArg3, AsyncCallback, typing.Any, IAsyncResult], endMethod: Func_2[IAsyncResult, FromAsync_3_TaskFactory_1_TResult], arg1: FromAsync_3_TArg1, arg2: FromAsync_3_TArg2, arg3: FromAsync_3_TArg3, state: typing.Any, creationOptions: TaskCreationOptions) -> Task_1[FromAsync_3_TaskFactory_1_TResult]:...

        @typing.overload
        def __call__(self, asyncResult: IAsyncResult, endMethod: Func_2[IAsyncResult, FromAsync_MethodGroup_TaskFactory_1_TResult]) -> Task_1[FromAsync_MethodGroup_TaskFactory_1_TResult]:...
        @typing.overload
        def __call__(self, beginMethod: Func_3[AsyncCallback, typing.Any, IAsyncResult], endMethod: Func_2[IAsyncResult, FromAsync_MethodGroup_TaskFactory_1_TResult], state: typing.Any) -> Task_1[FromAsync_MethodGroup_TaskFactory_1_TResult]:...
        @typing.overload
        def __call__(self, asyncResult: IAsyncResult, endMethod: Func_2[IAsyncResult, FromAsync_MethodGroup_TaskFactory_1_TResult], creationOptions: TaskCreationOptions) -> Task_1[FromAsync_MethodGroup_TaskFactory_1_TResult]:...
        @typing.overload
        def __call__(self, beginMethod: Func_3[AsyncCallback, typing.Any, IAsyncResult], endMethod: Func_2[IAsyncResult, FromAsync_MethodGroup_TaskFactory_1_TResult], state: typing.Any, creationOptions: TaskCreationOptions) -> Task_1[FromAsync_MethodGroup_TaskFactory_1_TResult]:...
        @typing.overload
        def __call__(self, asyncResult: IAsyncResult, endMethod: Func_2[IAsyncResult, FromAsync_MethodGroup_TaskFactory_1_TResult], creationOptions: TaskCreationOptions, scheduler: TaskScheduler) -> Task_1[FromAsync_MethodGroup_TaskFactory_1_TResult]:...

    # Skipped StartNew due to it being static, abstract and generic.

    StartNew : StartNew_MethodGroup[TaskFactory_1_TResult]
    StartNew_MethodGroup_TaskFactory_1_TResult = typing.TypeVar('StartNew_MethodGroup_TaskFactory_1_TResult')
    class StartNew_MethodGroup(typing.Generic[StartNew_MethodGroup_TaskFactory_1_TResult]):
        StartNew_MethodGroup_TaskFactory_1_TResult = TaskFactory_1.StartNew_MethodGroup_TaskFactory_1_TResult
        @typing.overload
        def __call__(self, function: Func_1[StartNew_MethodGroup_TaskFactory_1_TResult]) -> Task_1[StartNew_MethodGroup_TaskFactory_1_TResult]:...
        @typing.overload
        def __call__(self, function: Func_1[StartNew_MethodGroup_TaskFactory_1_TResult], creationOptions: TaskCreationOptions) -> Task_1[StartNew_MethodGroup_TaskFactory_1_TResult]:...
        @typing.overload
        def __call__(self, function: Func_1[StartNew_MethodGroup_TaskFactory_1_TResult], cancellationToken: CancellationToken) -> Task_1[StartNew_MethodGroup_TaskFactory_1_TResult]:...
        @typing.overload
        def __call__(self, function: Func_2[typing.Any, StartNew_MethodGroup_TaskFactory_1_TResult], state: typing.Any) -> Task_1[StartNew_MethodGroup_TaskFactory_1_TResult]:...
        @typing.overload
        def __call__(self, function: Func_2[typing.Any, StartNew_MethodGroup_TaskFactory_1_TResult], state: typing.Any, creationOptions: TaskCreationOptions) -> Task_1[StartNew_MethodGroup_TaskFactory_1_TResult]:...
        @typing.overload
        def __call__(self, function: Func_2[typing.Any, StartNew_MethodGroup_TaskFactory_1_TResult], state: typing.Any, cancellationToken: CancellationToken) -> Task_1[StartNew_MethodGroup_TaskFactory_1_TResult]:...
        @typing.overload
        def __call__(self, function: Func_1[StartNew_MethodGroup_TaskFactory_1_TResult], cancellationToken: CancellationToken, creationOptions: TaskCreationOptions, scheduler: TaskScheduler) -> Task_1[StartNew_MethodGroup_TaskFactory_1_TResult]:...
        @typing.overload
        def __call__(self, function: Func_2[typing.Any, StartNew_MethodGroup_TaskFactory_1_TResult], state: typing.Any, cancellationToken: CancellationToken, creationOptions: TaskCreationOptions, scheduler: TaskScheduler) -> Task_1[StartNew_MethodGroup_TaskFactory_1_TResult]:...



class TaskScheduler(abc.ABC):
    @classmethod
    @property
    def Current(cls) -> TaskScheduler: ...
    @classmethod
    @property
    def Default(cls) -> TaskScheduler: ...
    @property
    def Id(self) -> int: ...
    @property
    def MaximumConcurrencyLevel(self) -> int: ...
    @staticmethod
    def FromCurrentSynchronizationContext() -> TaskScheduler: ...


class TaskSchedulerException(Exception):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, innerException: Exception) -> None: ...
    @typing.overload
    def __init__(self, message: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, innerException: Exception) -> None: ...
    @property
    def Data(self) -> IDictionary: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def Message(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...


class TaskStatus(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Created : TaskStatus # 0
    WaitingForActivation : TaskStatus # 1
    WaitingToRun : TaskStatus # 2
    Running : TaskStatus # 3
    WaitingForChildrenToComplete : TaskStatus # 4
    RanToCompletion : TaskStatus # 5
    Canceled : TaskStatus # 6
    Faulted : TaskStatus # 7


class UnobservedTaskExceptionEventArgs(EventArgs):
    def __init__(self, exception: AggregateException) -> None: ...
    @property
    def Exception(self) -> AggregateException: ...
    @property
    def Observed(self) -> bool: ...
    def SetObserved(self) -> None: ...


class ValueTask_GenericClasses(abc.ABCMeta):
    Generic_ValueTask_GenericClasses_ValueTask_1_TResult = typing.TypeVar('Generic_ValueTask_GenericClasses_ValueTask_1_TResult')
    def __getitem__(self, types : typing.Type[Generic_ValueTask_GenericClasses_ValueTask_1_TResult]) -> typing.Type[ValueTask_1[Generic_ValueTask_GenericClasses_ValueTask_1_TResult]]: ...

class ValueTask(ValueTask_0, metaclass =ValueTask_GenericClasses): ...

class ValueTask_0(IEquatable_1[ValueTask]):
    @typing.overload
    def __init__(self, source: IValueTaskSource, token: int) -> None: ...
    @typing.overload
    def __init__(self, task: Task) -> None: ...
    @classmethod
    @property
    def CompletedTask(cls) -> ValueTask: ...
    @property
    def IsCanceled(self) -> bool: ...
    @property
    def IsCompleted(self) -> bool: ...
    @property
    def IsCompletedSuccessfully(self) -> bool: ...
    @property
    def IsFaulted(self) -> bool: ...
    def AsTask(self) -> Task: ...
    def ConfigureAwait(self, continueOnCapturedContext: bool) -> ConfiguredValueTaskAwaitable: ...
    def GetAwaiter(self) -> ValueTaskAwaiter: ...
    def GetHashCode(self) -> int: ...
    def __eq__(self, left: ValueTask, right: ValueTask) -> bool: ...
    def __ne__(self, left: ValueTask, right: ValueTask) -> bool: ...
    def Preserve(self) -> ValueTask: ...
    # Skipped Equals due to it being static, abstract and generic.

    Equals : Equals_MethodGroup
    class Equals_MethodGroup:
        @typing.overload
        def __call__(self, other: ValueTask) -> bool:...
        @typing.overload
        def __call__(self, obj: typing.Any) -> bool:...

    # Skipped FromCanceled due to it being static, abstract and generic.

    FromCanceled : FromCanceled_MethodGroup
    class FromCanceled_MethodGroup:
        def __getitem__(self, t:typing.Type[FromCanceled_1_T1]) -> FromCanceled_1[FromCanceled_1_T1]: ...

        FromCanceled_1_T1 = typing.TypeVar('FromCanceled_1_T1')
        class FromCanceled_1(typing.Generic[FromCanceled_1_T1]):
            FromCanceled_1_TResult = ValueTask_0.FromCanceled_MethodGroup.FromCanceled_1_T1
            def __call__(self, cancellationToken: CancellationToken) -> ValueTask_1[FromCanceled_1_TResult]:...

        def __call__(self, cancellationToken: CancellationToken) -> ValueTask:...

    # Skipped FromException due to it being static, abstract and generic.

    FromException : FromException_MethodGroup
    class FromException_MethodGroup:
        def __getitem__(self, t:typing.Type[FromException_1_T1]) -> FromException_1[FromException_1_T1]: ...

        FromException_1_T1 = typing.TypeVar('FromException_1_T1')
        class FromException_1(typing.Generic[FromException_1_T1]):
            FromException_1_TResult = ValueTask_0.FromException_MethodGroup.FromException_1_T1
            def __call__(self, exception: Exception) -> ValueTask_1[FromException_1_TResult]:...

        def __call__(self, exception: Exception) -> ValueTask:...

    # Skipped FromResult due to it being static, abstract and generic.

    FromResult : FromResult_MethodGroup
    class FromResult_MethodGroup:
        def __getitem__(self, t:typing.Type[FromResult_1_T1]) -> FromResult_1[FromResult_1_T1]: ...

        FromResult_1_T1 = typing.TypeVar('FromResult_1_T1')
        class FromResult_1(typing.Generic[FromResult_1_T1]):
            FromResult_1_TResult = ValueTask_0.FromResult_MethodGroup.FromResult_1_T1
            def __call__(self, result: FromResult_1_TResult) -> ValueTask_1[FromResult_1_TResult]:...




ValueTask_1_TResult = typing.TypeVar('ValueTask_1_TResult')
class ValueTask_1(typing.Generic[ValueTask_1_TResult], IEquatable_1[ValueTask_1[ValueTask_1_TResult]]):
    @typing.overload
    def __init__(self, result: ValueTask_1_TResult) -> None: ...
    @typing.overload
    def __init__(self, source: IValueTaskSource_1[ValueTask_1_TResult], token: int) -> None: ...
    @typing.overload
    def __init__(self, task: Task_1[ValueTask_1_TResult]) -> None: ...
    @property
    def IsCanceled(self) -> bool: ...
    @property
    def IsCompleted(self) -> bool: ...
    @property
    def IsCompletedSuccessfully(self) -> bool: ...
    @property
    def IsFaulted(self) -> bool: ...
    @property
    def Result(self) -> ValueTask_1_TResult: ...
    def AsTask(self) -> Task_1[ValueTask_1_TResult]: ...
    def ConfigureAwait(self, continueOnCapturedContext: bool) -> ConfiguredValueTaskAwaitable_1[ValueTask_1_TResult]: ...
    def GetAwaiter(self) -> ValueTaskAwaiter_1[ValueTask_1_TResult]: ...
    def GetHashCode(self) -> int: ...
    def __eq__(self, left: ValueTask_1[ValueTask_1_TResult], right: ValueTask_1[ValueTask_1_TResult]) -> bool: ...
    def __ne__(self, left: ValueTask_1[ValueTask_1_TResult], right: ValueTask_1[ValueTask_1_TResult]) -> bool: ...
    def Preserve(self) -> ValueTask_1[ValueTask_1_TResult]: ...
    def ToString(self) -> str: ...
    # Skipped Equals due to it being static, abstract and generic.

    Equals : Equals_MethodGroup[ValueTask_1_TResult]
    Equals_MethodGroup_ValueTask_1_TResult = typing.TypeVar('Equals_MethodGroup_ValueTask_1_TResult')
    class Equals_MethodGroup(typing.Generic[Equals_MethodGroup_ValueTask_1_TResult]):
        Equals_MethodGroup_ValueTask_1_TResult = ValueTask_1.Equals_MethodGroup_ValueTask_1_TResult
        @typing.overload
        def __call__(self, other: ValueTask_1[Equals_MethodGroup_ValueTask_1_TResult]) -> bool:...
        @typing.overload
        def __call__(self, obj: typing.Any) -> bool:...


