import typing, clr, abc
from System import IDisposable, Attribute, EventArgs, Array_1, Exception, Guid, DateTime, TimeSpan, Func_1
from System.Collections.Generic import IDictionary_2, IEnumerable_1
from System.Collections import IDictionary
from System.Reflection import MethodBase
from System.Collections.ObjectModel import ReadOnlyCollection_1

class DiagnosticCounter(IDisposable, abc.ABC):
    @property
    def DisplayName(self) -> str: ...
    @DisplayName.setter
    def DisplayName(self, value: str) -> str: ...
    @property
    def DisplayUnits(self) -> str: ...
    @DisplayUnits.setter
    def DisplayUnits(self, value: str) -> str: ...
    @property
    def EventSource(self) -> EventSource: ...
    @property
    def Name(self) -> str: ...
    def AddMetadata(self, key: str, value: str) -> None: ...
    def Dispose(self) -> None: ...


class EventActivityOptions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : EventActivityOptions # 0
    Disable : EventActivityOptions # 2
    Recursive : EventActivityOptions # 4
    Detachable : EventActivityOptions # 8


class EventAttribute(Attribute):
    def __init__(self, eventId: int) -> None: ...
    @property
    def ActivityOptions(self) -> EventActivityOptions: ...
    @ActivityOptions.setter
    def ActivityOptions(self, value: EventActivityOptions) -> EventActivityOptions: ...
    @property
    def Channel(self) -> EventChannel: ...
    @Channel.setter
    def Channel(self, value: EventChannel) -> EventChannel: ...
    @property
    def EventId(self) -> int: ...
    @EventId.setter
    def EventId(self, value: int) -> int: ...
    @property
    def Keywords(self) -> EventKeywords: ...
    @Keywords.setter
    def Keywords(self, value: EventKeywords) -> EventKeywords: ...
    @property
    def Level(self) -> EventLevel: ...
    @Level.setter
    def Level(self, value: EventLevel) -> EventLevel: ...
    @property
    def Message(self) -> str: ...
    @Message.setter
    def Message(self, value: str) -> str: ...
    @property
    def Opcode(self) -> EventOpcode: ...
    @Opcode.setter
    def Opcode(self, value: EventOpcode) -> EventOpcode: ...
    @property
    def Tags(self) -> EventTags: ...
    @Tags.setter
    def Tags(self, value: EventTags) -> EventTags: ...
    @property
    def Task(self) -> EventTask: ...
    @Task.setter
    def Task(self, value: EventTask) -> EventTask: ...
    @property
    def TypeId(self) -> typing.Any: ...
    @property
    def Version(self) -> int: ...
    @Version.setter
    def Version(self, value: int) -> int: ...


class EventChannel(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : EventChannel # 0
    Admin : EventChannel # 16
    Operational : EventChannel # 17
    Analytic : EventChannel # 18
    Debug : EventChannel # 19


class EventCommand(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Update : EventCommand # 0
    Disable : EventCommand # -3
    Enable : EventCommand # -2
    SendManifest : EventCommand # -1


class EventCommandEventArgs(EventArgs):
    @property
    def Arguments(self) -> IDictionary_2[str, str]: ...
    @Arguments.setter
    def Arguments(self, value: IDictionary_2[str, str]) -> IDictionary_2[str, str]: ...
    @property
    def Command(self) -> EventCommand: ...
    @Command.setter
    def Command(self, value: EventCommand) -> EventCommand: ...
    def DisableEvent(self, eventId: int) -> bool: ...
    def EnableEvent(self, eventId: int) -> bool: ...


class EventCounter(DiagnosticCounter):
    def __init__(self, name: str, eventSource: EventSource) -> None: ...
    @property
    def DisplayName(self) -> str: ...
    @DisplayName.setter
    def DisplayName(self, value: str) -> str: ...
    @property
    def DisplayUnits(self) -> str: ...
    @DisplayUnits.setter
    def DisplayUnits(self, value: str) -> str: ...
    @property
    def EventSource(self) -> EventSource: ...
    @property
    def Name(self) -> str: ...
    def ToString(self) -> str: ...
    # Skipped WriteMetric due to it being static, abstract and generic.

    WriteMetric : WriteMetric_MethodGroup
    class WriteMetric_MethodGroup:
        def __call__(self, value: float) -> None:...
        # Method WriteMetric(value : Double) was skipped since it collides with above method



class EventDataAttribute(Attribute):
    def __init__(self) -> None: ...
    @property
    def Name(self) -> str: ...
    @Name.setter
    def Name(self, value: str) -> str: ...
    @property
    def TypeId(self) -> typing.Any: ...


class EventFieldAttribute(Attribute):
    def __init__(self) -> None: ...
    @property
    def Format(self) -> EventFieldFormat: ...
    @Format.setter
    def Format(self, value: EventFieldFormat) -> EventFieldFormat: ...
    @property
    def Tags(self) -> EventFieldTags: ...
    @Tags.setter
    def Tags(self, value: EventFieldTags) -> EventFieldTags: ...
    @property
    def TypeId(self) -> typing.Any: ...


class EventFieldFormat(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Default : EventFieldFormat # 0
    String : EventFieldFormat # 2
    Boolean : EventFieldFormat # 3
    Hexadecimal : EventFieldFormat # 4
    Xml : EventFieldFormat # 11
    Json : EventFieldFormat # 12
    HResult : EventFieldFormat # 15


class EventFieldTags(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : EventFieldTags # 0


class EventIgnoreAttribute(Attribute):
    def __init__(self) -> None: ...
    @property
    def TypeId(self) -> typing.Any: ...


class EventKeywords(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : EventKeywords # 0
    MicrosoftTelemetry : EventKeywords # 562949953421312
    WdiContext : EventKeywords # 562949953421312
    WdiDiagnostic : EventKeywords # 1125899906842624
    Sqm : EventKeywords # 2251799813685248
    AuditFailure : EventKeywords # 4503599627370496
    CorrelationHint : EventKeywords # 4503599627370496
    AuditSuccess : EventKeywords # 9007199254740992
    EventLogClassic : EventKeywords # 36028797018963968
    All : EventKeywords # -1


class EventLevel(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    LogAlways : EventLevel # 0
    Critical : EventLevel # 1
    Error : EventLevel # 2
    Warning : EventLevel # 3
    Informational : EventLevel # 4
    Verbose : EventLevel # 5


class EventListener(IDisposable):
    def __init__(self) -> None: ...
    def DisableEvents(self, eventSource: EventSource) -> None: ...
    def Dispose(self) -> None: ...
    @staticmethod
    def EventSourceIndex(eventSource: EventSource) -> int: ...
    # Skipped EnableEvents due to it being static, abstract and generic.

    EnableEvents : EnableEvents_MethodGroup
    class EnableEvents_MethodGroup:
        @typing.overload
        def __call__(self, eventSource: EventSource, level: EventLevel) -> None:...
        @typing.overload
        def __call__(self, eventSource: EventSource, level: EventLevel, matchAnyKeyword: EventKeywords) -> None:...
        @typing.overload
        def __call__(self, eventSource: EventSource, level: EventLevel, matchAnyKeyword: EventKeywords, arguments: IDictionary_2[str, str]) -> None:...



class EventManifestOptions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : EventManifestOptions # 0
    Strict : EventManifestOptions # 1
    AllCultures : EventManifestOptions # 2
    OnlyIfNeededForRegistration : EventManifestOptions # 4
    AllowEventSourceOverride : EventManifestOptions # 8


class EventOpcode(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Info : EventOpcode # 0
    Start : EventOpcode # 1
    Stop : EventOpcode # 2
    DataCollectionStart : EventOpcode # 3
    DataCollectionStop : EventOpcode # 4
    Extension : EventOpcode # 5
    Reply : EventOpcode # 6
    Resume : EventOpcode # 7
    Suspend : EventOpcode # 8
    Send : EventOpcode # 9
    Receive : EventOpcode # 240


class EventSource(IDisposable):
    @typing.overload
    def __init__(self, eventSourceName: str) -> None: ...
    @typing.overload
    def __init__(self, eventSourceName: str, config: EventSourceSettings) -> None: ...
    @typing.overload
    def __init__(self, eventSourceName: str, config: EventSourceSettings, traits: Array_1[str]) -> None: ...
    @property
    def ConstructionException(self) -> Exception: ...
    @classmethod
    @property
    def CurrentThreadActivityId(cls) -> Guid: ...
    @property
    def Guid(self) -> Guid: ...
    @property
    def Name(self) -> str: ...
    @property
    def Settings(self) -> EventSourceSettings: ...
    def Dispose(self) -> None: ...
    @staticmethod
    def GetGuid(eventSourceType: typing.Type[typing.Any]) -> Guid: ...
    @staticmethod
    def GetName(eventSourceType: typing.Type[typing.Any]) -> str: ...
    @staticmethod
    def GetSources() -> IEnumerable_1[EventSource]: ...
    def GetTrait(self, key: str) -> str: ...
    @staticmethod
    def SendCommand(eventSource: EventSource, command: EventCommand, commandArguments: IDictionary_2[str, str]) -> None: ...
    def ToString(self) -> str: ...
    # Skipped GenerateManifest due to it being static, abstract and generic.

    GenerateManifest : GenerateManifest_MethodGroup
    class GenerateManifest_MethodGroup:
        @typing.overload
        def __call__(self, eventSourceType: typing.Type[typing.Any], assemblyPathToIncludeInManifest: str) -> str:...
        @typing.overload
        def __call__(self, eventSourceType: typing.Type[typing.Any], assemblyPathToIncludeInManifest: str, flags: EventManifestOptions) -> str:...

    # Skipped IsEnabled due to it being static, abstract and generic.

    IsEnabled : IsEnabled_MethodGroup
    class IsEnabled_MethodGroup:
        @typing.overload
        def __call__(self) -> bool:...
        @typing.overload
        def __call__(self, level: EventLevel, keywords: EventKeywords) -> bool:...
        @typing.overload
        def __call__(self, level: EventLevel, keywords: EventKeywords, channel: EventChannel) -> bool:...

    # Skipped SetCurrentThreadActivityId due to it being static, abstract and generic.

    SetCurrentThreadActivityId : SetCurrentThreadActivityId_MethodGroup
    class SetCurrentThreadActivityId_MethodGroup:
        @typing.overload
        def __call__(self, activityId: Guid) -> None:...
        @typing.overload
        def __call__(self, activityId: Guid, oldActivityThatWillContinue: clr.Reference[Guid]) -> None:...

    # Skipped Write due to it being static, abstract and generic.

    Write : Write_MethodGroup
    class Write_MethodGroup:
        def __getitem__(self, t:typing.Type[Write_1_T1]) -> Write_1[Write_1_T1]: ...

        Write_1_T1 = typing.TypeVar('Write_1_T1')
        class Write_1(typing.Generic[Write_1_T1]):
            Write_1_T = EventSource.Write_MethodGroup.Write_1_T1
            @typing.overload
            def __call__(self, eventName: str, data: Write_1_T) -> None:...
            @typing.overload
            def __call__(self, eventName: str, options: EventSourceOptions, data: Write_1_T) -> None:...
            @typing.overload
            def __call__(self, eventName: str, options: clr.Reference[EventSourceOptions], data: clr.Reference[Write_1_T]) -> None:...
            @typing.overload
            def __call__(self, eventName: str, options: clr.Reference[EventSourceOptions], activityId: clr.Reference[Guid], relatedActivityId: clr.Reference[Guid], data: clr.Reference[Write_1_T]) -> None:...

        @typing.overload
        def __call__(self, eventName: str) -> None:...
        @typing.overload
        def __call__(self, eventName: str, options: EventSourceOptions) -> None:...



class EventSourceAttribute(Attribute):
    def __init__(self) -> None: ...
    @property
    def Guid(self) -> str: ...
    @Guid.setter
    def Guid(self, value: str) -> str: ...
    @property
    def LocalizationResources(self) -> str: ...
    @LocalizationResources.setter
    def LocalizationResources(self, value: str) -> str: ...
    @property
    def Name(self) -> str: ...
    @Name.setter
    def Name(self, value: str) -> str: ...
    @property
    def TypeId(self) -> typing.Any: ...


class EventSourceCreatedEventArgs(EventArgs):
    def __init__(self) -> None: ...
    @property
    def EventSource(self) -> EventSource: ...
    @EventSource.setter
    def EventSource(self, value: EventSource) -> EventSource: ...


class EventSourceException(Exception):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, message: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, innerException: Exception) -> None: ...
    @property
    def Data(self) -> IDictionary: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def Message(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...


class EventSourceOptions:
    @property
    def ActivityOptions(self) -> EventActivityOptions: ...
    @ActivityOptions.setter
    def ActivityOptions(self, value: EventActivityOptions) -> EventActivityOptions: ...
    @property
    def Keywords(self) -> EventKeywords: ...
    @Keywords.setter
    def Keywords(self, value: EventKeywords) -> EventKeywords: ...
    @property
    def Level(self) -> EventLevel: ...
    @Level.setter
    def Level(self, value: EventLevel) -> EventLevel: ...
    @property
    def Opcode(self) -> EventOpcode: ...
    @Opcode.setter
    def Opcode(self, value: EventOpcode) -> EventOpcode: ...
    @property
    def Tags(self) -> EventTags: ...
    @Tags.setter
    def Tags(self, value: EventTags) -> EventTags: ...


class EventSourceSettings(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Default : EventSourceSettings # 0
    ThrowOnEventWriteErrors : EventSourceSettings # 1
    EtwManifestEventFormat : EventSourceSettings # 4
    EtwSelfDescribingEventFormat : EventSourceSettings # 8


class EventTags(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : EventTags # 0


class EventTask(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : EventTask # 0


class EventWrittenEventArgs(EventArgs):
    @property
    def ActivityId(self) -> Guid: ...
    @property
    def Channel(self) -> EventChannel: ...
    @property
    def EventId(self) -> int: ...
    @property
    def EventName(self) -> str: ...
    @EventName.setter
    def EventName(self, value: str) -> str: ...
    @property
    def EventSource(self) -> EventSource: ...
    @property
    def Keywords(self) -> EventKeywords: ...
    @Keywords.setter
    def Keywords(self, value: EventKeywords) -> EventKeywords: ...
    @property
    def Level(self) -> EventLevel: ...
    @Level.setter
    def Level(self, value: EventLevel) -> EventLevel: ...
    @property
    def Message(self) -> str: ...
    @Message.setter
    def Message(self, value: str) -> str: ...
    @property
    def Opcode(self) -> EventOpcode: ...
    @Opcode.setter
    def Opcode(self, value: EventOpcode) -> EventOpcode: ...
    @property
    def OSThreadId(self) -> int: ...
    @OSThreadId.setter
    def OSThreadId(self, value: int) -> int: ...
    @property
    def Payload(self) -> ReadOnlyCollection_1[typing.Any]: ...
    @Payload.setter
    def Payload(self, value: ReadOnlyCollection_1[typing.Any]) -> ReadOnlyCollection_1[typing.Any]: ...
    @property
    def PayloadNames(self) -> ReadOnlyCollection_1[str]: ...
    @PayloadNames.setter
    def PayloadNames(self, value: ReadOnlyCollection_1[str]) -> ReadOnlyCollection_1[str]: ...
    @property
    def RelatedActivityId(self) -> Guid: ...
    @property
    def Tags(self) -> EventTags: ...
    @Tags.setter
    def Tags(self, value: EventTags) -> EventTags: ...
    @property
    def Task(self) -> EventTask: ...
    @property
    def TimeStamp(self) -> DateTime: ...
    @TimeStamp.setter
    def TimeStamp(self, value: DateTime) -> DateTime: ...
    @property
    def Version(self) -> int: ...


class IncrementingEventCounter(DiagnosticCounter):
    def __init__(self, name: str, eventSource: EventSource) -> None: ...
    @property
    def DisplayName(self) -> str: ...
    @DisplayName.setter
    def DisplayName(self, value: str) -> str: ...
    @property
    def DisplayRateTimeScale(self) -> TimeSpan: ...
    @DisplayRateTimeScale.setter
    def DisplayRateTimeScale(self, value: TimeSpan) -> TimeSpan: ...
    @property
    def DisplayUnits(self) -> str: ...
    @DisplayUnits.setter
    def DisplayUnits(self, value: str) -> str: ...
    @property
    def EventSource(self) -> EventSource: ...
    @property
    def Name(self) -> str: ...
    def Increment(self, increment: float = ...) -> None: ...
    def ToString(self) -> str: ...


class IncrementingPollingCounter(DiagnosticCounter):
    def __init__(self, name: str, eventSource: EventSource, totalValueProvider: Func_1[float]) -> None: ...
    @property
    def DisplayName(self) -> str: ...
    @DisplayName.setter
    def DisplayName(self, value: str) -> str: ...
    @property
    def DisplayRateTimeScale(self) -> TimeSpan: ...
    @DisplayRateTimeScale.setter
    def DisplayRateTimeScale(self, value: TimeSpan) -> TimeSpan: ...
    @property
    def DisplayUnits(self) -> str: ...
    @DisplayUnits.setter
    def DisplayUnits(self, value: str) -> str: ...
    @property
    def EventSource(self) -> EventSource: ...
    @property
    def Name(self) -> str: ...
    def ToString(self) -> str: ...


class NonEventAttribute(Attribute):
    def __init__(self) -> None: ...
    @property
    def TypeId(self) -> typing.Any: ...


class PollingCounter(DiagnosticCounter):
    def __init__(self, name: str, eventSource: EventSource, metricProvider: Func_1[float]) -> None: ...
    @property
    def DisplayName(self) -> str: ...
    @DisplayName.setter
    def DisplayName(self, value: str) -> str: ...
    @property
    def DisplayUnits(self) -> str: ...
    @DisplayUnits.setter
    def DisplayUnits(self, value: str) -> str: ...
    @property
    def EventSource(self) -> EventSource: ...
    @property
    def Name(self) -> str: ...
    def ToString(self) -> str: ...


class TraceLoggingEventTypes:
    pass

