/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.ints;

import ch.javasoft.util.IntArray;
import ch.javasoft.util.ints.AbstractIntCollection;
import ch.javasoft.util.ints.AbstractIntIntMap;
import ch.javasoft.util.ints.AbstractIntIterator;
import ch.javasoft.util.ints.DefaultIntSet;
import ch.javasoft.util.ints.IntCollection;
import ch.javasoft.util.ints.IntIntMap;
import ch.javasoft.util.ints.IntIterator;
import ch.javasoft.util.ints.IntMap;
import ch.javasoft.util.ints.IntSet;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIntIntMap
extends AbstractIntIntMap
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -2304981943154788232L;
    private final IntArray keys;
    private final IntArray vals;

    public DefaultIntIntMap() {
        this(7);
    }

    public DefaultIntIntMap(int capacity) {
        this.keys = new IntArray(capacity);
        this.vals = new IntArray(capacity);
    }

    public DefaultIntIntMap(DefaultIntIntMap copy) {
        this.keys = copy.keys.clone();
        this.vals = copy.vals.clone();
    }

    public DefaultIntIntMap(Map<Integer, Integer> map) {
        if (map instanceof DefaultIntIntMap) {
            this.keys = ((DefaultIntIntMap)map).keys.clone();
            this.vals = ((DefaultIntIntMap)map).vals.clone();
        } else {
            int[][] keyvals = DefaultIntIntMap.toSortedKeyValArray(map);
            this.keys = new IntArray(keyvals.length);
            this.vals = new IntArray(keyvals.length);
            int i = 0;
            while (i < keyvals.length) {
                this.keys.add(keyvals[i][0]);
                this.vals.add(keyvals[i][1]);
                ++i;
            }
        }
    }

    private static int[][] toSortedKeyValArray(Map<Integer, Integer> map) {
        int[][] keyvals = new int[map.size()][2];
        Iterator<Integer> it = map.keySet().iterator();
        int index = 0;
        while (it.hasNext()) {
            int key;
            int n = key = it instanceof IntIterator ? ((IntIterator)it).nextInt() : it.next().intValue();
            int val = map instanceof IntIntMap ? ((IntIntMap)map).getInt(key) : (map instanceof IntMap ? ((Integer)((IntMap)map).get(key)).intValue() : map.get(key).intValue());
            keyvals[index][0] = key;
            keyvals[index][1] = val;
            ++index;
        }
        Arrays.sort(keyvals, new Comparator<int[]>(){

            @Override
            public int compare(int[] o1, int[] o2) {
                return o1[0] - o2[0];
            }
        });
        return keyvals;
    }

    @Override
    public int getInt(int key) {
        int index = this.keys.binarySearch(key);
        if (index >= 0) {
            return this.vals.get(index);
        }
        throw new NoSuchElementException("no such key: " + key);
    }

    @Override
    public boolean containsKey(int key) {
        return this.keys.binarySearch(key) >= 0;
    }

    @Override
    public boolean containsValue(int value) {
        return this.vals.indexOf(value) >= 0;
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    @Override
    public int size() {
        return this.keys.length();
    }

    @Override
    public IntSet keySet() {
        return new DefaultIntSet(this.keys.toArray()){
            private static final long serialVersionUID = -1944925467921640704L;

            @Override
            public boolean removeInt(int value) {
                int index = DefaultIntIntMap.this.keys.binarySearch(value);
                if (index < 0) {
                    return false;
                }
                super.removeInt(value);
                DefaultIntIntMap.this.vals.remove(index);
                return true;
            }

            @Override
            public void clear() {
                super.clear();
                DefaultIntIntMap.this.vals.clear();
            }

            @Override
            public boolean addInt(int value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean add(Integer o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Integer> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(int ... values) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(IntCollection coll) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Set<IntIntMap.IntIntEntry> intIntEntrySet() {
        return new AbstractSet<IntIntMap.IntIntEntry>(){

            @Override
            public Iterator<IntIntMap.IntIntEntry> iterator() {
                return new Iterator<IntIntMap.IntIntEntry>(){
                    int indexToRemove = -1;
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < this.size();
                    }

                    @Override
                    public IntIntMap.IntIntEntry next() {
                        int cur;
                        if (this.index >= this.size()) {
                            throw new NoSuchElementException();
                        }
                        this.indexToRemove = cur = this.index++;
                        return new AbstractIntIntMap.SimpleIntIntEntry(DefaultIntIntMap.this.keys.get(cur), DefaultIntIntMap.this.vals.get(cur));
                    }

                    @Override
                    public void remove() {
                        if (this.indexToRemove < 0) {
                            throw new IllegalStateException("value already removed, or next() not called yet");
                        }
                        DefaultIntIntMap.this.keys.remove(this.indexToRemove);
                        DefaultIntIntMap.this.vals.remove(this.indexToRemove);
                        --this.index;
                        this.indexToRemove = -1;
                    }
                };
            }

            @Override
            public boolean remove(Object o) {
                if (o instanceof Map.Entry) {
                    int ikey;
                    Map.Entry entry = (Map.Entry)o;
                    Object key = entry.getKey();
                    Object val = entry.getValue();
                    if (key instanceof Integer && val instanceof Integer && DefaultIntIntMap.this.getInt(ikey = ((Integer)key).intValue()) == ((Integer)val).intValue()) {
                        DefaultIntIntMap.this.remove(ikey);
                        return true;
                    }
                }
                return false;
            }

            @Override
            public void clear() {
                DefaultIntIntMap.this.clear();
            }

            @Override
            public int size() {
                return DefaultIntIntMap.this.keys.length();
            }

            @Override
            public boolean isEmpty() {
                return DefaultIntIntMap.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)o;
                    Object key = entry.getKey();
                    Object val = entry.getValue();
                    if (key instanceof Integer && val instanceof Integer) {
                        int ikey = (Integer)key;
                        return DefaultIntIntMap.this.getInt(ikey) == ((Integer)val).intValue();
                    }
                }
                return false;
            }
        };
    }

    @Override
    public IntCollection values() {
        return new AbstractIntCollection(){

            @Override
            public IntIterator iterator() {
                return new AbstractIntIterator(){
                    int indexToRemove = -1;
                    int index = 0;

                    public boolean hasNext() {
                        return this.index < this.size();
                    }

                    public int nextInt() {
                        int cur;
                        if (this.index >= this.size()) {
                            throw new NoSuchElementException();
                        }
                        this.indexToRemove = cur = this.index++;
                        return DefaultIntIntMap.this.vals.get(cur);
                    }

                    public void remove() {
                        if (this.indexToRemove < 0) {
                            throw new IllegalStateException("value already removed, or next() not called yet");
                        }
                        DefaultIntIntMap.this.keys.remove(this.indexToRemove);
                        DefaultIntIntMap.this.vals.remove(this.indexToRemove);
                        --this.index;
                        this.indexToRemove = -1;
                    }
                };
            }

            @Override
            public boolean removeInt(int value) {
                int index = DefaultIntIntMap.this.vals.binarySearch(value);
                if (index >= 0) {
                    DefaultIntIntMap.this.keys.remove(index);
                    DefaultIntIntMap.this.vals.remove(index);
                    return true;
                }
                return false;
            }

            @Override
            public void clear() {
                DefaultIntIntMap.this.clear();
            }

            @Override
            public int size() {
                return DefaultIntIntMap.this.keys.length();
            }

            @Override
            public boolean isEmpty() {
                return DefaultIntIntMap.this.isEmpty();
            }

            @Override
            public boolean containsInt(int value) {
                return DefaultIntIntMap.this.vals.indexOf(value) >= 0;
            }

            @Override
            public boolean addInt(int value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean add(Integer o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Integer> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(int ... values) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(IntCollection coll) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int[] toKeyArray() {
        return this.keys.toArray();
    }

    public int[] toValueArray() {
        return this.vals.toArray();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof DefaultIntIntMap) {
            DefaultIntIntMap other = (DefaultIntIntMap)o;
            return this.keys.equals(other.keys) && this.vals.equals(other.vals);
        }
        return super.equals(o);
    }

    @Override
    public Integer put(int key, int value) {
        int index = this.keys.binarySearch(key);
        if (index >= 0) {
            return this.vals.set(index, value);
        }
        index = -(index + 1);
        this.keys.add(index, key);
        this.vals.add(index, value);
        return null;
    }

    @Override
    public void putAll(IntIntMap map) {
        this.mergeWith(DefaultIntIntMap.toSortedKeyValArray(map));
    }

    private void mergeWith(int[][] sortedKeyVals) {
        int curlen = this.size();
        int addlen = sortedKeyVals.length;
        if (addlen <= 2) {
            int i = 0;
            while (i < addlen) {
                int index = this.keys.addToSorted(sortedKeyVals[i][0]);
                this.vals.addToSorted(sortedKeyVals[index][0]);
                ++i;
            }
            return;
        }
        int[] newkey = new int[curlen + addlen];
        int[] newval = new int[curlen + addlen];
        int curind = 0;
        int addind = 0;
        int newind = 0;
        while (curind < curlen && addind < addlen) {
            int addval;
            int curval = this.keys.get(curind);
            if (curval <= (addval = sortedKeyVals[addind][0])) {
                newkey[newind] = curval;
                newval[newind] = this.vals.get(curind);
                ++newind;
                ++curind;
                if (curval != addval) continue;
                ++addind;
                continue;
            }
            newkey[newind] = addval;
            newval[newind] = sortedKeyVals[addind][1];
            ++newind;
            ++addind;
        }
        while (curind < curlen) {
            newkey[newind] = this.keys.get(curind);
            newval[newind] = this.vals.get(curind);
            ++newind;
            ++curind;
        }
        while (addind < addlen) {
            newkey[newind] = sortedKeyVals[addind][0];
            newval[newind] = sortedKeyVals[addind][1];
            ++newind;
            ++addind;
        }
        this.keys.clear();
        this.vals.clear();
        int i = 0;
        while (i < newind) {
            this.keys.add(newkey[i]);
            this.vals.add(newval[i]);
            ++i;
        }
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.vals.clear();
    }

    @Override
    public Integer remove(int key) {
        int index = this.keys.binarySearch(key);
        if (index < 0) {
            return null;
        }
        this.keys.remove(index);
        return this.vals.remove(index);
    }

    @Override
    public DefaultIntIntMap clone() {
        return new DefaultIntIntMap(this);
    }
}

