/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.ints;

import ch.javasoft.util.ints.AbstractIntIterator;
import ch.javasoft.util.ints.AbstractSortedIntSet;
import ch.javasoft.util.ints.IntIterator;
import ch.javasoft.util.ints.IntSet;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.BitSet;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitSetIntSet
extends AbstractSortedIntSet
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1418206509682222060L;
    private BitSet set;

    public BitSetIntSet() {
        this.set = new BitSet();
    }

    public BitSetIntSet(IntSet set) {
        this();
        this.addAll(set);
    }

    public BitSetIntSet(BitSet bitSet) {
        this.set = (BitSet)bitSet.clone();
    }

    public BitSetIntSet(int[] values) {
        this();
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int val = nArray[n2];
            this.addInt(values[val]);
            ++n2;
        }
    }

    public BitSet toBitSet() {
        return (BitSet)this.set.clone();
    }

    @Override
    public int size() {
        return this.set.cardinality();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean containsInt(int o) {
        return this.set.get(o);
    }

    @Override
    protected <T> T[] toArrayInternal(T[] arr, boolean checkSize) {
        int size;
        if (checkSize && arr.length < (size = this.size())) {
            arr = (Object[])Array.newInstance(arr.getClass().getComponentType(), size);
        }
        int index = 0;
        int i = this.set.nextSetBit(0);
        while (i >= 0) {
            arr[index++] = i;
            i = this.set.nextSetBit(i + 1);
        }
        return arr;
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public boolean addInt(int value) {
        if (this.set.get(value)) {
            return true;
        }
        this.set.set(value);
        ++this.mod;
        return false;
    }

    @Override
    public boolean removeInt(int value) {
        if (this.set.get(value)) {
            this.set.clear(value);
            ++this.mod;
            return true;
        }
        return false;
    }

    @Override
    public IntIterator iterator() {
        return new AbstractIntIterator(){
            int ref;
            int next;
            int rem;
            {
                this.ref = BitSetIntSet.this.mod;
                this.next = BitSetIntSet.this.set.nextSetBit(0);
                this.rem = -1;
            }

            public boolean hasNext() {
                return this.next >= 0;
            }

            public int nextInt() {
                if (this.next < 0) {
                    throw new NoSuchElementException();
                }
                this.checkMod();
                int cur = this.next;
                this.next = BitSetIntSet.this.set.nextSetBit(cur + 1);
                this.rem = cur;
                return cur;
            }

            public void remove() {
                if (this.rem == -1) {
                    throw new IllegalStateException("next has not yet been called, or remove has already been performed.");
                }
                BitSetIntSet.this.removeInt(this.rem);
                this.ref = BitSetIntSet.this.mod;
                this.rem = -1;
            }

            private void checkMod() {
                if (BitSetIntSet.this.mod != this.ref) {
                    throw new ConcurrentModificationException();
                }
            }
        };
    }

    @Override
    protected int[] toIntArrayInternal(int[] arr, boolean checkSize) {
        int size;
        if (checkSize && arr.length < (size = this.size())) {
            arr = new int[size];
        }
        int index = 0;
        int i = this.set.nextSetBit(0);
        while (i >= 0) {
            arr[index++] = i;
            i = this.set.nextSetBit(i + 1);
        }
        return arr;
    }

    @Override
    public Comparator<? super Integer> comparator() {
        return null;
    }

    @Override
    public int firstInt() {
        int val = this.set.nextSetBit(0);
        if (val < 0) {
            throw new NoSuchElementException();
        }
        return val;
    }

    @Override
    public int lastInt() {
        int val = this.set.length() - 1;
        if (val < 0) {
            throw new NoSuchElementException();
        }
        return val;
    }

    @Override
    public BitSetIntSet subSet(int fromElement, int toElement) {
        if (fromElement > toElement) {
            throw new IllegalArgumentException("fromElement > toElement: " + fromElement + " > " + toElement);
        }
        return new BitSetIntSet(this.set.get(fromElement, toElement));
    }

    @Override
    public BitSetIntSet clone() {
        BitSetIntSet clone = (BitSetIntSet)super.clone();
        clone.set = (BitSet)this.set.clone();
        clone.mod = 0;
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BitSetIntSet) {
            return this.set.equals(((BitSetIntSet)obj).set);
        }
        return super.equals(obj);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.set.toString());
        sb.setCharAt(0, '[');
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }
}

