/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco.impl;

import ch.javasoft.math.array.ArrayOperations;
import ch.javasoft.math.array.NumberArrayOperations;
import ch.javasoft.math.array.NumberOperators;
import ch.javasoft.math.linalg.LinAlgOperations;
import ch.javasoft.math.operator.UnaryOperator;
import ch.javasoft.polco.PolyhedralCone;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPolyhedralCone<Num extends Number, Arr>
implements PolyhedralCone<Num, Arr> {
    protected final LinAlgOperations<Num, Arr> linAlgOps;
    protected final ArrayOperations<Arr> arrayOps;
    protected final NumberArrayOperations<Num, Arr> numberArrayOps;
    protected final NumberOperators<Num, Arr> numberOps;

    public AbstractPolyhedralCone(LinAlgOperations<Num, Arr> linAlgOps) {
        this.linAlgOps = linAlgOps;
        this.arrayOps = linAlgOps.getArrayOperations();
        this.numberArrayOps = linAlgOps.getNumberArrayOperations();
        this.numberOps = linAlgOps.getNumberOperators();
    }

    @Override
    public LinAlgOperations<Num, Arr> getLinAlgOperations() {
        return this.linAlgOps;
    }

    @Override
    public int hashCode() {
        int code = 0;
        int dims = this.getDimensions();
        int rowsA = this.getRowCountA();
        int rowsB = this.getRowCountB();
        int c = 0;
        while (c < dims) {
            int r = 0;
            while (r < rowsA) {
                code ^= this.getA(r, c).hashCode();
                ++r;
            }
            r = 0;
            while (r < rowsB) {
                code ^= this.getB(r, c).hashCode();
                ++r;
            }
            ++c;
        }
        return code;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PolyhedralCone) {
            PolyhedralCone other = (PolyhedralCone)obj;
            int dims = this.getDimensions();
            int rowsA = this.getRowCountA();
            int rowsB = this.getRowCountB();
            if (dims != other.getDimensions()) {
                return false;
            }
            if (rowsA != other.getRowCountA()) {
                return false;
            }
            if (rowsB != other.getRowCountB()) {
                return false;
            }
            int c = 0;
            while (c < dims) {
                int r = 0;
                while (r < rowsA) {
                    if (!this.getA(r, c).equals(other.getA(r, c))) {
                        return false;
                    }
                    ++r;
                }
                r = 0;
                while (r < rowsB) {
                    if (!this.getB(r, c).equals(other.getB(r, c))) {
                        return false;
                    }
                    ++r;
                }
                ++c;
            }
            return true;
        }
        return false;
    }

    protected Arr normalize(Arr vec) {
        LinAlgOperations<Num, Arr> lops = this.getLinAlgOperations();
        ArrayOperations<Arr> aops = lops.getArrayOperations();
        NumberOperators nops = lops.getNumberOperators();
        UnaryOperator norm = nops.unary(UnaryOperator.Id.normalize);
        int size = aops.getLength(vec);
        int i = 0;
        while (i < size) {
            norm.operate(vec, i, vec, i);
            ++i;
        }
        return vec;
    }

    protected Arr[] normalize(Arr[] mx) {
        int r = 0;
        while (r < mx.length) {
            this.normalize(mx[r]);
            ++r;
        }
        return mx;
    }

    protected String getMatrixDimensionString(boolean matrixA) {
        int dims = this.getDimensions();
        return matrixA ? "A:" + this.getRowCountA() + "x" + dims : "B:" + this.getRowCountB() + "x" + dims;
    }

    protected void appendMatrixString(boolean matrixA, PrintWriter pw) {
        int dims = this.getDimensions();
        if (matrixA) {
            int rows = this.getRowCountA();
            pw.println("A = " + rows + "x" + dims + " {");
            int r = 0;
            while (r < rows) {
                int c = 0;
                while (c < dims) {
                    pw.print(c == 0 ? "  [ " : " , ");
                    pw.print(this.getA(r, c));
                    ++c;
                }
                pw.println(" ]");
                ++r;
            }
        } else {
            int rows = this.getRowCountB();
            pw.println("B = " + rows + "x" + dims + " {");
            int r = 0;
            while (r < rows) {
                int c = 0;
                while (c < dims) {
                    pw.print(c == 0 ? "  [ " : " , ");
                    pw.print(this.getB(r, c));
                    ++c;
                }
                pw.println(" ]");
                ++r;
            }
        }
        pw.println("}");
    }

    @Override
    public String toMultilineString() {
        StringWriter sw = new StringWriter();
        this.writeToMultiline(sw);
        return sw.toString();
    }

    @Override
    public void writeToMultiline(Writer writer) {
        PrintWriter pw = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        pw.println("P = { A x = 0 , B x >= 0 }");
        this.appendMatrixString(true, pw);
        this.appendMatrixString(false, pw);
        pw.flush();
    }

    @Override
    public String toString() {
        return "P = { A x = 0 , B x >= 0 , " + this.getMatrixDimensionString(true) + " , " + this.getMatrixDimensionString(false) + " }";
    }
}

