/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.tree.search;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.memory.PartId;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.model.AdjEnumModel;
import ch.javasoft.metabolic.efm.tree.BitPatternTree;
import ch.javasoft.metabolic.efm.tree.InterNode;
import ch.javasoft.metabolic.efm.tree.LeafNode;
import ch.javasoft.metabolic.efm.tree.impl.AbstractTreeTraverser;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuperSetSearch<T>
extends AbstractTreeTraverser<T> {
    private final IBitSet intersectionSet;
    private final int ignoreColumn;
    private volatile PartId memoryPartId;
    private volatile boolean superSetFound;

    public SuperSetSearch(IBitSet intersectionSet) {
        this(intersectionSet, -1);
    }

    public SuperSetSearch(IBitSet intersectionSet, int ignoreColumn) {
        this.intersectionSet = intersectionSet;
        this.ignoreColumn = ignoreColumn;
    }

    public boolean hasSuperSetFound() {
        return this.superSetFound;
    }

    @Override
    public <Col extends Column, N extends Number> void traverse(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> iterationModel, T token, BitPatternTree tree) throws IOException {
        this.memoryPartId = tree.kind().toPartId();
        super.traverse(columnHome, iterationModel, token, tree);
    }

    @Override
    public <Col extends Column, N extends Number> boolean traverseI(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> iterationModel, T token, InterNode node) throws IOException {
        if (this.intersectionSet.isSubSetOf(node.unionPattern())) {
            return super.traverseI(columnHome, iterationModel, token, node);
        }
        return true;
    }

    @Override
    public <Col extends Column, N extends Number> boolean traverseL(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> iterationModel, T token, LeafNode node) throws IOException {
        if (this.intersectionSet.isSubSetOf(node.unionPattern())) {
            int start = node.getLeafColumnStart();
            int end = node.getLeafColumnEnd();
            SortableMemory<Col> mem = iterationModel.getMemory(this.memoryPartId);
            int i = start;
            while (i < end) {
                IBitSet superCandidate;
                if (i != this.ignoreColumn && this.intersectionSet.isSubSetOf(superCandidate = mem.getColumn(i).bitValues())) {
                    this.superSetFound = true;
                    return false;
                }
                ++i;
            }
        }
        return true;
    }
}

