/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.tree.outcore;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.jbase.FixedWidthMarshaller;
import ch.javasoft.metabolic.efm.tree.outcore.PersistentNodeEntity;
import ch.javasoft.metabolic.efm.util.BitSetUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentNodeEntityMarshaller
implements FixedWidthMarshaller<PersistentNodeEntity> {
    private final int bitSetSize;

    public PersistentNodeEntityMarshaller(int bitSetSize) {
        this.bitSetSize = bitSetSize;
    }

    @Override
    public int getByteWidth() {
        return BitSetUtil.byteSize(this.bitSetSize) + 8;
    }

    @Override
    public PersistentNodeEntity readFrom(DataInput in) throws IOException {
        IBitSet unionPattern = BitSetUtil.readFrom(in, this.bitSetSize);
        int intA = in.readInt();
        int intB = in.readInt();
        return new PersistentNodeEntity(unionPattern, intA, intB);
    }

    @Override
    public void writeTo(PersistentNodeEntity entity, DataOutput out) throws IOException {
        BitSetUtil.writeTo(entity.unionPattern, this.bitSetSize, out);
        out.writeInt(entity.valueA);
        out.writeInt(entity.valueB);
    }
}

