/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.output.text;

import ch.javasoft.metabolic.efm.output.EfmOutputCallback;
import ch.javasoft.metabolic.efm.output.EfmOutputEvent;
import ch.javasoft.metabolic.efm.output.EfmOutputFormatter;
import java.io.PrintWriter;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTextOutputFormatter
implements EfmOutputFormatter<PrintWriter> {
    protected final boolean headerLine;
    protected final boolean modeIndex;

    public AbstractTextOutputFormatter(boolean headerLine, boolean modeIndex) {
        this.headerLine = headerLine;
        this.modeIndex = modeIndex;
    }

    @Override
    public void formatHeader(EfmOutputCallback cb, PrintWriter writer, EfmOutputEvent evt) {
        if (this.headerLine) {
            writer.println("efm-output[" + evt.getEfmCount() + " modes, " + this.getClass().getSimpleName() + ", " + new Date() + "]");
        }
    }

    @Override
    public void formatEfmHeader(EfmOutputCallback cb, PrintWriter writer, EfmOutputEvent evt, long efmIndex) {
        if (this.modeIndex) {
            writer.print(String.valueOf(efmIndex) + "\t");
        }
    }

    @Override
    public abstract void formatEfmValue(EfmOutputCallback var1, PrintWriter var2, EfmOutputEvent var3, long var4, int var6, Number var7);

    @Override
    public void formatEfmFooter(EfmOutputCallback cb, PrintWriter writer, EfmOutputEvent evt, long efmIndex) {
        writer.println();
    }

    @Override
    public void formatFooter(EfmOutputCallback cb, PrintWriter writer, EfmOutputEvent evt, long countEfms) {
    }

    @Override
    public boolean isEfmValueIterationNeeded(EfmOutputCallback cb) {
        return true;
    }
}

