/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.main;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.efm.ElementaryFluxModes;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.config.XmlAttribute;
import ch.javasoft.metabolic.efm.config.XmlElement;
import ch.javasoft.metabolic.efm.output.CountOutputCallback;
import ch.javasoft.metabolic.efm.output.EfmOutputCallback;
import ch.javasoft.metabolic.efm.output.NullOutputCallback;
import ch.javasoft.metabolic.efm.output.OutputMode;
import ch.javasoft.metabolic.efm.output.RandomAccessFileOutputCallback;
import ch.javasoft.metabolic.efm.output.mat.MatFileOutputCallback;
import ch.javasoft.metabolic.parse.ConfiguredParser;
import ch.javasoft.util.logging.LogPrintStream;
import ch.javasoft.util.logging.Loggers;
import ch.javasoft.util.logging.SystemProperties;
import ch.javasoft.util.logging.matlab.LogConfiguration;
import ch.javasoft.util.logging.matlab.LogConfigurationReader;
import ch.javasoft.xml.config.FileConfigParser;
import ch.javasoft.xml.config.MissingReferableException;
import ch.javasoft.xml.config.StreamConfigParser;
import ch.javasoft.xml.config.XmlArgException;
import ch.javasoft.xml.config.XmlConfig;
import ch.javasoft.xml.config.XmlConfigException;
import ch.javasoft.xml.config.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dom4j.Element;
import org.dom4j.Node;

public class CalculateFluxModes {
    public static final int EXIT_VAL_OK = 0;
    public static final int EXIT_VAL_HELP_VERSION_ARG = -1;
    public static final int EXIT_VAL_CONFIG_ARG = -2;
    public static final int EXIT_VAL_CONFIG_REF = -3;
    public static final int EXIT_VAL_EXCEPTION = -4;
    public static final int EXIT_VAL_UNKNOWN = -5;

    public static void main(String[] args) {
        CalculateFluxModes.start(args, false);
    }

    public static long matlab(String[] args) {
        return CalculateFluxModes.start(args, true);
    }

    private static long start(String[] args, boolean noExit) {
        try {
            XmlConfig xmlConfig;
            if (args.length >= 1) {
                boolean err;
                xmlConfig = Config.parseXmlConfig(args);
                boolean bl = err = args.length > 1;
                if ("--help".equals(args[0]) || "-?".equals(args[0]) || "?".equals(args[0])) {
                    Config.printHelp(err ? System.err : System.out, xmlConfig);
                    return CalculateFluxModes.exit(noExit, err ? -1 : 0);
                }
                if ("--version".equals(args[0]) || "-v".equals(args[0])) {
                    Config.printVersion(err ? System.err : System.out, xmlConfig);
                    return CalculateFluxModes.exit(noExit, err ? -1 : 0);
                }
            }
            try {
                xmlConfig = Config.resolveXmlConfig(args);
                if (noExit) {
                    CalculateFluxModes.initLoggingConfigurationForMatlab(xmlConfig);
                } else {
                    Loggers.initLogManagerConfiguration(xmlConfig.getLoggingProperties());
                }
                Logger logger = Loggers.getRootLogger();
                LogPrintStream logStream = new LogPrintStream(logger, Level.INFO);
                Config.printVersion(logStream, xmlConfig);
                logStream.flush();
                long val = CalculateFluxModes.start(xmlConfig);
                if (val >= 0L) {
                    return CalculateFluxModes.exit(noExit, val);
                }
            }
            catch (XmlArgException ex) {
                return CalculateFluxModes.exit(noExit, -2L);
            }
            catch (MissingReferableException ex) {
                return CalculateFluxModes.exit(noExit, -3L);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Config.traceArgs(System.err, String.valueOf(CalculateFluxModes.class.getName()) + " with following arguments: ", args);
            return CalculateFluxModes.exit(noExit, -4L);
        }
        return CalculateFluxModes.exit(noExit, 0L);
    }

    private static long exit(boolean noExit, long exitVal) {
        if (noExit) {
            return exitVal;
        }
        System.exit((int)exitVal);
        return -5L;
    }

    private static void initLoggingConfigurationForMatlab(XmlConfig config) throws XmlConfigException, IOException {
        Properties logProps = config.getLoggingProperties();
        LogConfiguration logConfig = logProps == null ? new LogConfiguration() : new LogConfiguration(logProps);
        System.setProperty(SystemProperties.LogManagerPropertiesClass.getPropertyName(), new LogConfigurationReader(logConfig).getClass().getName());
        Logger logger = Loggers.getRootLogger();
        logger.info("logger initialized");
    }

    private static long start(XmlConfig config) throws XmlConfigException, IOException {
        Element defConfig = config.getDefaultConfigElement();
        Element efmImplConfig = Config.getConfigEfmImpl(config);
        Element efmOutputConfig = Config.getConfigEfmOutput(config);
        ElementaryFluxModes.setImpl(Config.getEfmImpl(config, efmImplConfig));
        MetabolicNetwork net = ConfiguredParser.parseConfig(defConfig);
        EfmOutputCallback callback = CalculateFluxModes.getEfmOutCb(net, efmOutputConfig);
        ElementaryFluxModes.calculateCallback(net, callback);
        return callback instanceof CountOutputCallback ? ((CountOutputCallback)callback).getEfmCount() : -1L;
    }

    private static EfmOutputCallback getEfmOutCb(MetabolicNetwork net, Element efmOutputConfig) throws XmlConfigException {
        Element elCallback = XmlUtil.getRequiredSingleChildElement(efmOutputConfig, XmlElement.callback);
        String implClass = XmlUtil.getRequiredAttributeValue(elCallback, XmlAttribute.type);
        try {
            Class<?> clazz = Class.forName(implClass);
            if (!EfmOutputCallback.class.isAssignableFrom(clazz)) {
                throw new XmlConfigException("not an efm output callback class: " + implClass, (Node)elCallback);
            }
            if (clazz == CountOutputCallback.class) {
                Element elUncompress = XmlUtil.getRequiredSingleChildElement(elCallback, XmlElement.uncompress);
                Element elStream = XmlUtil.getRequiredSingleChildElement(elCallback, XmlElement.stream);
                boolean uncompress = Boolean.parseBoolean(XmlUtil.getRequiredAttributeValue(elUncompress, XmlAttribute.value));
                OutputStream out = StreamConfigParser.parseOutputStream(elStream);
                return new CountOutputCallback(out, uncompress);
            }
            if (clazz == NullOutputCallback.class) {
                return NullOutputCallback.INSTANCE;
            }
            if (clazz == MatFileOutputCallback.class) {
                int efmsPerFile;
                Element elFile = XmlUtil.getRequiredSingleChildElement(elCallback, XmlElement.file);
                File file = FileConfigParser.parseFile(elFile);
                File folder = file.getParentFile();
                String fileName = file.getName();
                String strEfmsPerFile = XmlUtil.getRequiredAttributeValue(elFile, XmlAttribute.efms_per_file);
                OutputMode mode = CalculateFluxModes.parseOutputMode(elCallback);
                try {
                    efmsPerFile = Integer.parseInt(strEfmsPerFile);
                }
                catch (NumberFormatException e) {
                    throw new XmlConfigException("unable to parse '" + XmlAttribute.efms_per_file.getXmlName() + "' attribute, e=" + e, (Node)elFile);
                }
                if (efmsPerFile > 0) {
                    return new MatFileOutputCallback(mode, net, folder, fileName, efmsPerFile);
                }
                return new MatFileOutputCallback(mode, net, folder, fileName);
            }
            if (clazz == RandomAccessFileOutputCallback.class) {
                Element elFile = XmlUtil.getRequiredSingleChildElement(elCallback, XmlElement.file);
                File file = FileConfigParser.parseFile(elFile);
                OutputMode mode = CalculateFluxModes.parseOutputMode(elCallback);
                return new RandomAccessFileOutputCallback(net, mode, file);
            }
            Element elStream = XmlUtil.getRequiredSingleChildElement(elCallback, XmlElement.stream);
            OutputStream out = StreamConfigParser.parseOutputStream(elStream);
            OutputMode mode = CalculateFluxModes.parseOutputMode(elCallback);
            Class[] signature = new Class[]{MetabolicNetwork.class, OutputMode.class, OutputStream.class};
            Constructor<?> cons = clazz.getConstructor(signature);
            return (EfmOutputCallback)cons.newInstance(new Object[]{net, mode, out});
        }
        catch (Exception ex) {
            throw new XmlConfigException("cannot instantiate callback class '" + implClass + "', e=" + ex, (Node)efmOutputConfig, (Throwable)ex);
        }
    }

    private static OutputMode parseOutputMode(Element elCallback) throws XmlConfigException {
        Element elMode = XmlUtil.getRequiredSingleChildElement(elCallback, XmlElement.mode);
        String strMode = XmlUtil.getRequiredAttributeValue(elMode, XmlAttribute.value);
        try {
            return OutputMode.valueOf(strMode);
        }
        catch (Exception ex) {
            throw new XmlConfigException("invalid output mode '" + strMode + "', e=" + ex, (Node)elMode, (Throwable)ex);
        }
    }

    private CalculateFluxModes() {
    }
}

