/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.dist.impl.adj;

import ch.javasoft.job.Executable;
import ch.javasoft.job.Job;
import ch.javasoft.job.JobMonitor;
import ch.javasoft.job.JobTerminationHandler;
import ch.javasoft.metabolic.efm.adj.AbstractAdjEnum;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.config.DistributedConfig;
import ch.javasoft.metabolic.efm.dist.DistributedAdjEnum;
import ch.javasoft.metabolic.efm.dist.impl.DistJobController;
import ch.javasoft.metabolic.efm.dist.impl.RunningJob;
import ch.javasoft.metabolic.efm.dist.impl.adj.LogPkg;
import ch.javasoft.metabolic.efm.dist.impl.adj.PseudoDistributingAdjEnum;
import ch.javasoft.metabolic.efm.dist.impl.file.FileBasedDistributableAdjEnum;
import ch.javasoft.metabolic.efm.model.AdjEnumModel;
import ch.javasoft.util.ExceptionUtil;
import ch.javasoft.util.logging.LogPrintStream;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDistributedAdjEnum
extends AbstractAdjEnum {
    public AbstractDistributedAdjEnum(String name) {
        super(name);
    }

    @Override
    public <Col extends Column, N extends Number> void adjacentPairs(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> itModel) throws IOException {
        long candidates = (long)itModel.getMemoryPos().getColumnCount() * (long)itModel.getMemoryNeg().getColumnCount();
        if (candidates == 0L) {
            return;
        }
        DistributedConfig distConfig = this.getConfig().getDistributedConfig();
        DistributedAdjEnum delegate = this.getConfig().getAdjMethodFactory().createDistributedAdjEnumFromConfig();
        if (candidates < distConfig.getCandidateThreashold()) {
            LogPkg.LOGGER.fine("candidate count below threshold, not parallelizing: " + candidates + " < " + distConfig.getCandidateThreashold());
            PseudoDistributingAdjEnum adjEnum = new PseudoDistributingAdjEnum(delegate);
            adjEnum.initialize(columnHome, this.getConfig(), this.getEfmModel());
            adjEnum.adjacentPairs(columnHome, itModel);
            return;
        }
        final ConcurrentHashMap<Executable<Void>, JobMonitor<Void>> runningJobs = new ConcurrentHashMap<Executable<Void>, JobMonitor<Void>>();
        final AtomicReference exception = new AtomicReference();
        final Thread mainThread = Thread.currentThread();
        JobTerminationHandler<Void> terminationHandler = new JobTerminationHandler<Void>(){

            @Override
            public void terminated(Job job, Void result) {
                runningJobs.remove(job);
            }

            @Override
            public void terminatedByException(Job job, Throwable t) {
                exception.compareAndSet(null, t);
                runningJobs.remove(job);
                mainThread.interrupt();
            }
        };
        int nodeCnt = Math.min(distConfig.getNodeNames().size(), distConfig.getPartition());
        FileBasedDistributableAdjEnum denum = new FileBasedDistributableAdjEnum();
        DistJobController controller = denum.initialize(columnHome, this.getConfig(), this.getEfmModel(), itModel, nodeCnt);
        Thread jobKiller = new Thread(){

            public void run() {
                while (!runningJobs.isEmpty()) {
                    for (Executable job : runningJobs.keySet()) {
                        JobMonitor mtr = (JobMonitor)runningJobs.remove(job);
                        if (mtr == null) continue;
                        mtr.interrupt();
                    }
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(jobKiller);
        try {
            try {
                int nodeIndex = 0;
                while (nodeIndex < nodeCnt) {
                    RunningJob job = this.execJob(controller, terminationHandler, nodeIndex);
                    runningJobs.put(job.getExecutable(), job.getMonitor());
                    if (exception.get() != null) {
                        throw (Throwable)exception.get();
                    }
                    ++nodeIndex;
                }
                controller.awaitCompletion();
            }
            catch (Throwable th) {
                LogPkg.LOGGER.warning("server caught exception, e=" + th);
                if (exception.get() != null) {
                    th = (Throwable)exception.get();
                    LogPkg.LOGGER.warning("server detected probable causing exception, e=" + th);
                }
                try {
                    controller.abort();
                }
                catch (Exception ex) {
                    LogPkg.LOGGER.warning("could not close server, e=" + ex);
                    ex.printStackTrace(new LogPrintStream(LogPkg.LOGGER, Level.WARNING));
                }
                throw ExceptionUtil.toRuntimeExceptionOr(IOException.class, th);
            }
        }
        finally {
            Runtime.getRuntime().removeShutdownHook(jobKiller);
        }
    }

    protected abstract RunningJob execJob(DistJobController var1, JobTerminationHandler<Void> var2, int var3);
}

