/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.concurrent;

import ch.javasoft.metabolic.efm.concurrent.ConcurrentToken;
import ch.javasoft.metabolic.efm.concurrent.ReleasePolicy;
import ch.javasoft.metabolic.efm.config.Config;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class TimeoutWaitingReleasePolicy
implements ReleasePolicy {
    private volatile int jobCount;
    private volatile int threadCount;
    private volatile long timeMS;
    private volatile long maxWaitingTimeMS;
    private AtomicLong curWaitingTimeMS = new AtomicLong();
    private volatile Semaphore permitsToRelease;

    public void initialize(Config config, int jobs, int threads) {
        this.jobCount = jobs;
        this.threadCount = threads;
        this.timeMS = -System.currentTimeMillis();
        this.maxWaitingTimeMS = 64L;
        this.curWaitingTimeMS.set(-1L);
        this.permitsToRelease = new Semaphore(0);
    }

    public void releasePermit(ConcurrentToken token) throws InterruptedException {
        this.permitsToRelease.release();
        if (this.timeMS < 0L) {
            long dtMS = this.timeMS + System.currentTimeMillis();
            long curTimeMS = Math.max(0L, dtMS / (long)this.jobCount * (long)this.threadCount);
            if (this.curWaitingTimeMS.compareAndSet(-1L, curTimeMS = Math.min(this.maxWaitingTimeMS, curTimeMS))) {
                this.timeMS = dtMS;
            }
        }
        long waitMS = this.curWaitingTimeMS.get();
        int toCollect = 2;
        int toRelease = 0;
        while (toRelease == 0 && this.permitsToRelease.tryAcquire(toCollect, waitMS, TimeUnit.MILLISECONDS)) {
            toRelease = toCollect + this.permitsToRelease.drainPermits();
            if (toRelease >= this.threadCount) continue;
            this.permitsToRelease.release(toRelease);
            toCollect = Math.min(toRelease << 1, this.threadCount);
            toRelease = 0;
        }
        if ((toRelease += this.permitsToRelease.drainPermits()) > 0) {
            token.releasePermits(toRelease);
        }
    }
}

