/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.column;

import ch.javasoft.math.BigFraction;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnFactory;
import ch.javasoft.metabolic.efm.column.DoubleColumn;
import ch.javasoft.metabolic.efm.column.FractionalColumn;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnFactories {
    private static ColumnFactories sInstance;
    private final Map<Class<? extends Number>, ColumnFactory> factories = new HashMap<Class<? extends Number>, ColumnFactory>();

    public ColumnFactories() {
        ColumnFactory[] columnFactoryArray = this.getDefaultFactories();
        int n = columnFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnFactory fac = columnFactoryArray[n2];
            this.factories.put(fac.numberClass(), fac);
            ++n2;
        }
    }

    public static ColumnFactories instance() {
        if (sInstance == null) {
            sInstance = new ColumnFactories();
        }
        return sInstance;
    }

    public Column createBinaryColumn(Class<? extends Number> numberClass, int booleanSize) {
        ColumnFactory fac = this.factories.get(numberClass);
        if (fac == null) {
            throw new IllegalArgumentException("no column factory for number type " + numberClass.getName());
        }
        return fac.createBinaryColumn(booleanSize);
    }

    protected ColumnFactory[] getDefaultFactories() {
        return new ColumnFactory[]{new ColumnFactory(){

            @Override
            public Class<? extends Number> numberClass() {
                return Double.class;
            }

            @Override
            public Column createBinaryColumn(int booleanSize) {
                return new DoubleColumn(booleanSize);
            }
        }, new ColumnFactory(){

            @Override
            public Class<? extends Number> numberClass() {
                return BigFraction.class;
            }

            @Override
            public Column createBinaryColumn(int booleanSize) {
                return new FractionalColumn(booleanSize);
            }
        }};
    }
}

